/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.response.BroadcastMessage;
import de.virtimo.bpc.core.es.plugin.response.ClusterMessage;
import de.virtimo.bpc.core.es.plugin.response.IndexOperation;
import de.virtimo.bpc.core.es.plugin.response.ServerStateInfo;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ElasticsearchBpcPluginListener
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ElasticsearchBpcPluginListener.class.getName());
    public static final String RETRY_INTERVAL_IN_SECONDS_PROPERTY_NAME = "de.virtimo.bpc.core.es-bpc-plugin.retryInterval";
    private final BundleContext bundleContext;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private ElasticsearchBpcPluginManager elasticsearchBpcPluginManager;
    private WebSocketClient websocketClient = null;

    public ElasticsearchBpcPluginListener(BundleContext bundleContext, ElasticsearchBpcPluginManager elasticsearchBpcPluginManager) {
        this.bundleContext = bundleContext;
        this.elasticsearchBpcPluginManager = elasticsearchBpcPluginManager;
    }

    public void destroy() {
        LOG.info("destroy");
        if (this.websocketClient != null) {
            try {
                this.websocketClient.stop();
                this.websocketClient = null;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not stop the websocket connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ElasticsearchBpcPluginSocket socket;
        ServiceRegistration msgEventHandlerRegistration;
        LOG.info("run");
        if (this.websocketClient != null && this.websocketClient.isRunning()) {
            LOG.info("Nothing to do ... there is already a running websocket connection.");
            return;
        }
        if (this.websocketClient != null) {
            LOG.warning("Should not happen ... previously used websocket client is in state: " + this.websocketClient.getState());
            try {
                this.websocketClient.stop();
                this.websocketClient = null;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to stop an old/previously used websocket client.", ex);
            }
        }
        if ((msgEventHandlerRegistration = this.bundleContext.registerService(EventHandler.class, (Object)(socket = new ElasticsearchBpcPluginSocket()), DictionaryUtil.dictionaryOf("event.topics", new String[]{"de/virtimo/es-bpc-plugin-send-broadcast-message", "de/virtimo/es-bpc-plugin-send-state-info-message", "de/virtimo/es-bpc-plugin-send-percolator-hit-message", "de/virtimo/bpc/core/backendModuleLoaded", "de/virtimo/bpc/core/backendModuleUnloaded", "de/virtimo/es-bpc-plugin"}))) == null) {
            LOG.log(Level.SEVERE, "No websocket connection established. Could not register the event handler!");
            return;
        }
        LOG.info("Establishing Websocket connection");
        try {
            this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
            this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
            this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
            this.websocketClient = new WebSocketClient();
            this.websocketClient.start();
            this.websocketClient.setConnectTimeout(5000L);
            this.websocketClient.setStopTimeout(5000L);
            this.websocketClient.setMaxIdleTimeout(0L);
            URI elasticsearchBpcPluginWebsocketURI = new URI(this.elasticsearchBpcPluginManager.getElasticsearchBpcPluginWebsocketUrl());
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            this.websocketClient.connect((Object)socket, elasticsearchBpcPluginWebsocketURI, request);
            LOG.info("Connecting to : " + elasticsearchBpcPluginWebsocketURI);
            socket.await();
            LOG.info("Websocket client stopped");
        }
        catch (InterruptedException ex) {
            LOG.info("The websocket connection has been interrupted. Maybe just the core bundle stopped.");
            this.elasticsearchBpcPluginManager.setWebsocketState(ElasticsearchBpcPluginManager.WebsocketState.DISCONNECTED);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Could not establish the websocket connection", t);
            this.elasticsearchBpcPluginManager.addError("Could not establish the websocket connection.", t);
            this.elasticsearchBpcPluginManager.setWebsocketState(ElasticsearchBpcPluginManager.WebsocketState.ERROR);
        }
        finally {
            try {
                msgEventHandlerRegistration.unregister();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not unregister the message event handler", e);
            }
            if (this.websocketClient != null) {
                try {
                    this.websocketClient.stop();
                    this.websocketClient = null;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not stop the websocket connection", e);
                }
            }
            BpcServicesTracker.stopAll(this);
        }
    }

    @WebSocket(maxTextMessageSize=262144)
    public class ElasticsearchBpcPluginSocket
    extends AbstractEventHandler {
        private final CountDownLatch closeLatch = new CountDownLatch(1);
        private Session session;
        private RemoteEndpoint remote;

        public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
            return this.closeLatch.await(duration, unit);
        }

        public void await() throws InterruptedException {
            this.closeLatch.await();
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
            LOG.info(this.getClass().getSimpleName() + ".onConnect: " + session);
            this.session = session;
            this.remote = this.session.getRemote();
            ElasticsearchBpcPluginListener.this.elasticsearchBpcPluginManager.setWebsocketState(ElasticsearchBpcPluginManager.WebsocketState.CONNECTED);
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            LOG.info(this.getClass().getSimpleName() + ".onClose: " + statusCode + " - " + reason);
            this.session = null;
            this.remote = null;
            this.closeLatch.countDown();
            ElasticsearchBpcPluginListener.this.elasticsearchBpcPluginManager.setWebsocketState(ElasticsearchBpcPluginManager.WebsocketState.DISCONNECTED);
        }

        @OnWebSocketMessage
        public void onMessage(String msg) {
            block28: {
                LOG.info(this.getClass().getSimpleName() + ".onMessage: " + msg);
                try {
                    String index;
                    String msgContent;
                    block27: {
                        if (StringUtil.isNullOrEmpty(msg)) {
                            return;
                        }
                        if (msg.startsWith("WebsocketMessageForFrontendSession:::")) {
                            msgContent = msg.substring("WebsocketMessageForFrontendSession:::".length());
                            String sessionId = msgContent.substring(0, msgContent.indexOf(":::"));
                            String json = msgContent.substring((sessionId + ":::").length());
                            try {
                                ClientSessionManager clientSessionManager = ElasticsearchBpcPluginListener.this.clientSessionManagerTracker.getService();
                                if (sessionId.equalsIgnoreCase("ALL")) {
                                    clientSessionManager.broadcastMessage(json);
                                } else {
                                    clientSessionManager.sendByWebsocket(sessionId, json);
                                }
                            }
                            catch (ServiceNotFoundException ex) {
                                LOG.log(Level.SEVERE, "Failed to process the WebSocket message due to missing service.", ex);
                            }
                        }
                        if (msg.startsWith("BroadcastMessage:::")) {
                            try {
                                msgContent = msg.substring("BroadcastMessage:::".length());
                                try {
                                    BroadcastMessage broadcastMessage = JsonUtil.getInstance().convertJsonStringToPojo(msgContent, BroadcastMessage.class);
                                    LOG.finest("es-bpc-plugin response (BroadcastMessage): " + broadcastMessage);
                                    if (broadcastMessage == null) break block27;
                                    if (BroadcastMessage.BroadcastType.ClientEvent.name().equals(broadcastMessage.getType())) {
                                        Map eventData = (Map)broadcastMessage.getData();
                                        ElasticsearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/client/" + eventData.get("event"), DictionaryUtil.dictionaryOf("data", eventData.get("data")));
                                        break block27;
                                    }
                                    ElasticsearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin", "BroadcastMessage", broadcastMessage);
                                }
                                catch (IOException e) {
                                    LOG.log(Level.INFO, "Could not convert the broadcast message to a POJO. Processing as plain text.", e);
                                    ElasticsearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin", "PlainTextBroadcastMessage", msgContent);
                                }
                            }
                            catch (ServiceNotFoundException ex) {
                                LOG.log(Level.SEVERE, "Failed to fire the WebSocket broadcast message event.", ex);
                            }
                        }
                    }
                    if (msg.startsWith("IndexOperation:::")) {
                        msgContent = msg.substring("IndexOperation:::".length());
                        try {
                            IndexOperation indexOperation = JsonUtil.getInstance().convertJsonStringToPojo(msgContent, IndexOperation.class);
                            LOG.finest("es-bpc-plugin response (IndexOperation): " + indexOperation);
                            if (indexOperation != null) {
                                ElasticsearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin", "IndexOperation", indexOperation);
                            }
                        }
                        catch (ServiceNotFoundException ex) {
                            LOG.log(Level.SEVERE, "Failed to fire the Index operation event", ex);
                            ElasticsearchBpcPluginListener.this.elasticsearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
                        }
                        catch (IOException ex) {
                            LOG.log(Level.SEVERE, "Could not convert the index operation JSON to a POJO", ex);
                            ElasticsearchBpcPluginListener.this.elasticsearchBpcPluginManager.addError("Could not convert the index operation JSON to a POJO", ex);
                        }
                    }
                    if (msg.startsWith("IndexDeleted:::") && (index = msg.substring("IndexDeleted:::".length())).length() > 0) {
                        try {
                            Pattern p = Pattern.compile("(.+)_\\d+");
                            Matcher m = p.matcher(index);
                            if (m.matches()) {
                                String alias = m.group(1);
                                ElasticsearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin", "IndexDeleted", MapUtil.mapOf("index", index, "alias", alias));
                            }
                        }
                        catch (ServiceNotFoundException ex) {
                            LOG.log(Level.SEVERE, "Failed to fire the Index deleted event", ex);
                        }
                    }
                    if (!msg.startsWith("ClusterMessage:::")) break block28;
                    msgContent = msg.substring("ClusterMessage:::".length());
                    try {
                        ClusterMessage clusterMessage = JsonUtil.getInstance().convertJsonStringToPojo(msgContent, ClusterMessage.class);
                        LOG.finest("es-bpc-plugin response (ClusterMessage): " + clusterMessage);
                        if (clusterMessage != null) {
                            ElasticsearchBpcPluginListener.this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin", "ClusterMessage", clusterMessage);
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.SEVERE, "Failed to fire the cluster message event", ex);
                        ElasticsearchBpcPluginListener.this.elasticsearchBpcPluginManager.addError("Failed to get the EventManager service", ex);
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "Could not convert the cluster message JSON to a POJO", e);
                        ElasticsearchBpcPluginListener.this.elasticsearchBpcPluginManager.addError("Could not convert the cluster message JSON to a POJO", e);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Failed to process the received websocket message from the es-bpc-plugin.", t);
                }
            }
        }

        @OnWebSocketError
        public void onError(Throwable cause) {
            LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".onError", cause);
            this.closeLatch.countDown();
        }

        @Override
        public void processEvent(Event event) {
            Object msgObject;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=" + event);
            if (event.getTopic().equals("de/virtimo/es-bpc-plugin-send-broadcast-message")) {
                msgObject = event.getProperty("msg");
                if (msgObject instanceof String) {
                    this.sendMessageSync("[BROADCAST_TO_ALL_EXCEPT_SENDER]BroadcastMessage:::" + msgObject);
                } else if (msgObject instanceof BroadcastMessage) {
                    try {
                        this.sendMessageSync("[BROADCAST_TO_ALL_EXCEPT_SENDER]BroadcastMessage:::" + JsonUtil.getInstance().convertPojoToJsonString(msgObject));
                    }
                    catch (JsonProcessingException ex) {
                        LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".processEvent : Could not convert the BroadcastMessage object to JSON.", ex);
                    }
                }
            }
            if (event.getTopic().equals("de/virtimo/es-bpc-plugin-send-state-info-message")) {
                msgObject = event.getProperty("msg");
                if (msgObject instanceof String) {
                    this.sendMessageSync("ServerStateInfo:::" + msgObject);
                } else if (msgObject instanceof ServerStateInfo) {
                    try {
                        this.sendMessageSync("ServerStateInfo:::" + JsonUtil.getInstance().convertPojoToJsonString(msgObject));
                    }
                    catch (JsonProcessingException ex) {
                        LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".processEvent : Could not convert the ServerStateInfo object to JSON.", ex);
                    }
                }
            }
            if (event.getTopic().equals("de/virtimo/bpc/core/backendModuleLoaded") || event.getTopic().equals("de/virtimo/bpc/core/backendModuleUnloaded") || event.getTopic().equals("de/virtimo/es-bpc-plugin") && event.getProperty("WebsocketState") == ElasticsearchBpcPluginManager.WebsocketState.CONNECTED) {
                try {
                    ModuleManager moduleManager = ElasticsearchBpcPluginListener.this.moduleManagerTracker.getService();
                    ArrayList moduleInfos = new ArrayList();
                    for (Module m : moduleManager.getLoadedModules().values()) {
                        HashMap<String, String> moduleInfoMap = new HashMap<String, String>();
                        moduleInfoMap.put("id", m.getModuleId());
                        moduleInfoMap.put("version", m.getModuleBundle().getVersion().toString());
                        moduleInfos.add(moduleInfoMap);
                    }
                    this.sendMessageSync("ServerLoadedModules:::" + JsonUtil.getInstance().convertPojoToJsonString(moduleInfos));
                }
                catch (JsonProcessingException ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".processEvent : Failed not convert the server loaded modules list to JSON.", ex);
                }
                catch (ServiceNotFoundException ex) {
                    LOG.log(Level.WARNING, this.getClass().getSimpleName() + ".processEvent : Failed to inform the es-bpc-plugin about my loaded modules.", ex);
                }
            }
            if (event.getTopic().equals("de/virtimo/es-bpc-plugin-send-percolator-hit-message")) {
                String serverUUID = (String)event.getProperty("serverUUID");
                String sessionId = (String)event.getProperty("sessionId");
                String jsonMsg = (String)event.getProperty("jsonMsg");
                this.sendMessageSync("[BROADCAST_TO]" + serverUUID + ":::WebsocketMessageForFrontendSession:::" + sessionId + ":::" + jsonMsg);
            }
        }

        private void sendMessageSync(String msg) {
            block3: {
                LOG.info(this.getClass().getSimpleName() + ".sendMessageSync msg=" + msg);
                Future fut = null;
                try {
                    fut = this.remote.sendStringByFuture(msg);
                    fut.get(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".sendMessageSync : Could not send the websocket message: " + msg, e);
                }
                catch (TimeoutException e) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ".sendMessageSync : Timeout (15 seconds) while sending the websocket message: " + msg, e);
                    if (fut == null) break block3;
                    fut.cancel(true);
                }
            }
        }
    }
}

