/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginError;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginListener;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.response.Config;
import de.virtimo.bpc.core.es.plugin.response.ConnectedServers;
import de.virtimo.bpc.core.es.plugin.response.Filter;
import de.virtimo.bpc.core.es.plugin.response.Filters;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.osgi.framework.BundleContext;

public class ElasticsearchBpcPluginManagerImpl
implements ElasticsearchBpcPluginManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(ElasticsearchBpcPluginManagerImpl.class.getName());
    public static final int MAX_ERRORS = 10;
    private final BundleContext bundleContext;
    private final CoreBundleConfiguration coreBundleConfiguration;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private ScheduledExecutorService elasticsearchBpcPluginExecutorService;
    private final ElasticsearchBpcPluginListener elasticsearchBpcPluginListener;
    private final List<ElasticsearchBpcPluginError> lastErrors = new ArrayList<ElasticsearchBpcPluginError>();
    private ElasticsearchBpcPluginManager.PluginState pluginState = ElasticsearchBpcPluginManager.PluginState.UNKNOWN;
    private ElasticsearchBpcPluginManager.WebsocketState websocketState = ElasticsearchBpcPluginManager.WebsocketState.DISCONNECTED;

    public ElasticsearchBpcPluginManagerImpl(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.bundleContext = bundleContext;
        this.coreBundleConfiguration = coreBundleConfiguration;
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.elasticsearchBpcPluginListener = new ElasticsearchBpcPluginListener(bundleContext, this);
        this.elasticsearchBpcPluginExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-es-plugin-listener"));
        this.elasticsearchBpcPluginExecutorService.scheduleWithFixedDelay(this.elasticsearchBpcPluginListener, 5L, coreBundleConfiguration.getSystemPropertyValueAsInt("de.virtimo.bpc.core.es-bpc-plugin.retryInterval", 5), TimeUnit.SECONDS);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        if (this.elasticsearchBpcPluginExecutorService != null) {
            this.elasticsearchBpcPluginExecutorService.shutdownNow();
            this.elasticsearchBpcPluginExecutorService = null;
        }
        if (this.elasticsearchBpcPluginListener != null) {
            this.elasticsearchBpcPluginListener.destroy();
        }
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public String getElasticsearchBpcPluginWebsocketUrl() throws ServiceNotFoundException, SettingException {
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Config config = this.getElasticsearchBpcPluginConfig(es);
        if (config == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Failed to fetch the config from the 'es-bpc-plugin'.");
        }
        Config.Websocket websocket = config.getWebsocket();
        if (websocket == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Did not find the websocket property in the 'es-bpc-plugin' config: " + config);
        }
        Integer websocketPort = websocket.getPort();
        if (websocketPort == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Did not find the websocket port in the 'es-bpc-plugin' config: " + config);
        }
        return "ws://" + es.getEsHost() + ":" + websocketPort + "/ws/_bpc";
    }

    @Override
    public ElasticsearchBpcPluginManager.PluginState getPluginState() {
        return this.pluginState;
    }

    private void setPluginState(ElasticsearchBpcPluginManager.PluginState pluginState) {
        this.pluginState = pluginState;
    }

    @Override
    public ElasticsearchBpcPluginManager.WebsocketState getWebsocketState() {
        return this.websocketState;
    }

    @Override
    public void setWebsocketState(ElasticsearchBpcPluginManager.WebsocketState websocketState) {
        if (this.websocketState != websocketState) {
            this.websocketState = websocketState;
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin", "WebsocketState", (Object)websocketState);
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Failed to fire the websocket state change: " + websocketState, ex);
            }
        }
    }

    @Override
    public List<ElasticsearchBpcPluginError> getErrors() {
        return this.lastErrors;
    }

    @Override
    public synchronized void addError(String message, Throwable t) {
        LOG.log(Level.SEVERE, message);
        ElasticsearchBpcPluginError previousError = null;
        if (!this.lastErrors.isEmpty()) {
            previousError = this.lastErrors.get(this.lastErrors.size() - 1);
        }
        ElasticsearchBpcPluginError currentError = new ElasticsearchBpcPluginError(message, t);
        if (previousError != null && previousError.equals(currentError)) {
            this.lastErrors.remove(this.lastErrors.size() - 1);
        }
        this.lastErrors.add(currentError);
        if (this.lastErrors.size() > 10) {
            this.lastErrors.remove(0);
        }
    }

    @Override
    public synchronized Config getElasticsearchBpcPluginConfig() throws ServiceNotFoundException {
        LOG.info("getElasticsearchBpcPluginConfig");
        return this.getElasticsearchBpcPluginConfig(this.elasticsearchServiceTracker.getService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Config getElasticsearchBpcPluginConfig(ElasticsearchService es) {
        LOG.info("getElasticsearchBpcPluginConfig es=...");
        Config result = null;
        Request req = new Request("GET", "/_bpc/config");
        InputStream inputStream = null;
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Response resp = es.getClient().getLowLevelClient().performRequest(req);
            inputStream = resp.getEntity().getContent();
            result = (Config)objectMapper.readValue(inputStream, Config.class);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'es-bpc-plugin' is installed and that the following endpoint is accessible: " + req, null);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
        }
        catch (Throwable t) {
            this.addError("Failed to get the 'es-bpc-plugin' configuration using the endpoint: " + req, t);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ERRORS);
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return result;
    }

    @Override
    public synchronized Filters getRegisteredFilters() throws ServiceNotFoundException {
        LOG.info("getRegisteredFilters");
        return this.getRegisteredFilters(this.elasticsearchServiceTracker.getService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Filters getRegisteredFilters(ElasticsearchService es) {
        LOG.info("getRegisteredFilters es=...");
        Filters result = null;
        Request req = new Request("GET", "/_bpc/filters");
        req.addParameter("serverUUID", this.coreBundleConfiguration.getServerUUID());
        InputStream inputStream = null;
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Response resp = es.getClient().getLowLevelClient().performRequest(req);
            inputStream = resp.getEntity().getContent();
            result = (Filters)objectMapper.readValue(inputStream, Filters.class);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'es-bpc-plugin' is installed and that the following endpoint is accessible: " + req, null);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
        }
        catch (Throwable t) {
            this.addError("Failed to get the registered 'es-bpc-plugin' filters using the endpoint: " + req, t);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ERRORS);
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return result;
    }

    @Override
    public synchronized int registerFilter(Filter filter) throws ServiceNotFoundException {
        LOG.info("registerFilter filter=" + filter);
        return this.registerFilter(this.elasticsearchServiceTracker.getService(), filter);
    }

    @Override
    public synchronized int registerFilter(ElasticsearchService es, Filter filter) {
        int result;
        LOG.info("registerFilter es=..., filter=" + filter);
        Request req = new Request("PUT", "/_bpc/filters");
        req.addParameter("serverUUID", this.coreBundleConfiguration.getServerUUID());
        req.addParameter("index", filter.getIndex());
        req.addParameter("sendIndexEventsOnlyForModifiedSources", filter.isSendIndexEventsOnlyForModifiedSources() ? "true" : "false");
        try {
            Response resp = es.getClient().getLowLevelClient().performRequest(req);
            result = resp.getStatusLine().getStatusCode();
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'es-bpc-plugin' is installed and that the following endpoint is accessible: " + req, null);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
            result = 500;
        }
        catch (Throwable t) {
            this.addError("Failed to register the 'es-bpc-plugin' filter (" + filter + ") using the endpoint: " + req, t);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ERRORS);
            result = 500;
        }
        return result;
    }

    @Override
    public synchronized int unregisterFilter(Filter filter) throws ServiceNotFoundException {
        LOG.info("unregisterFilter filter=" + filter);
        return this.unregisterFilter(this.elasticsearchServiceTracker.getService(), filter);
    }

    @Override
    public synchronized int unregisterFilter(ElasticsearchService es, Filter filter) {
        int result;
        LOG.info("unregisterFilter es=..., filter=" + filter);
        Request req = new Request("DELETE", "/_bpc/filters");
        req.addParameter("serverUUID", this.coreBundleConfiguration.getServerUUID());
        req.addParameter("index", filter.getIndex());
        try {
            Response resp = es.getClient().getLowLevelClient().performRequest(req);
            result = resp.getStatusLine().getStatusCode();
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'es-bpc-plugin' is installed and that the following endpoint is accessible: " + req, null);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
            result = 500;
        }
        catch (Throwable t) {
            this.addError("Failed to unregister the 'es-bpc-plugin' filter (" + filter + ") using the endpoint: " + req, t);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ERRORS);
            result = 500;
        }
        return result;
    }

    @Override
    public synchronized int unregisterAllFilters() throws ServiceNotFoundException {
        LOG.info("unregisterAllFilters");
        return this.unregisterAllFilters(this.elasticsearchServiceTracker.getService());
    }

    @Override
    public synchronized int unregisterAllFilters(ElasticsearchService es) {
        int result;
        LOG.info("unregisterAllFilters es=...");
        Request req = new Request("DELETE", "/_bpc/filters");
        req.addParameter("serverUUID", this.coreBundleConfiguration.getServerUUID());
        req.addParameter("all", "true");
        try {
            Response resp = es.getClient().getLowLevelClient().performRequest(req);
            result = resp.getStatusLine().getStatusCode();
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'es-bpc-plugin' is installed and that the following endpoint is accessible: " + req, null);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
            result = 500;
        }
        catch (Throwable t) {
            this.addError("Failed to unregister all 'es-bpc-plugin' filters using the endpoint " + req, t);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ERRORS);
            result = 500;
        }
        return result;
    }

    @Override
    public synchronized void registerFilters(Filters filtersToRegister) throws ServiceNotFoundException {
        LOG.info("registerFilters es=... filtersToRegister=" + filtersToRegister);
        this.registerFilters(this.elasticsearchServiceTracker.getService(), filtersToRegister);
    }

    @Override
    public synchronized void registerFilters(ElasticsearchService es, Filters filtersToRegister) {
        LOG.info("registerFilters es=... filtersToRegister=" + filtersToRegister);
        Filters currentRegisteredFilters = this.getRegisteredFilters(es);
        LOG.info("Current registered filters: " + currentRegisteredFilters);
        for (Filter currentRegisteredFilter : currentRegisteredFilters.getFilters()) {
            boolean toRegister = filtersToRegister != null && filtersToRegister.containsFilter(currentRegisteredFilter);
            if (toRegister) continue;
            this.unregisterFilter(es, currentRegisteredFilter);
        }
        if (filtersToRegister != null) {
            for (Filter filterToRegister : filtersToRegister.getFilters()) {
                boolean alreadyRegistered = currentRegisteredFilters.containsFilter(filterToRegister);
                if (alreadyRegistered) continue;
                this.registerFilter(es, filterToRegister);
            }
        }
    }

    @Override
    public synchronized ConnectedServers getConnectedServers() throws ServiceNotFoundException {
        LOG.info("getConnectedServers");
        return this.getConnectedServers(this.elasticsearchServiceTracker.getService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ConnectedServers getConnectedServers(ElasticsearchService es) {
        LOG.info("getConnectedServers es=" + es);
        ConnectedServers result = null;
        Request req = new Request("GET", "/_bpc/servers");
        InputStream inputStream = null;
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Response resp = es.getClient().getLowLevelClient().performRequest(req);
            inputStream = resp.getEntity().getContent();
            result = (ConnectedServers)objectMapper.readValue(inputStream, ConnectedServers.class);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'es-bpc-plugin' is installed and that the following endpoint is accessible: " + req, null);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
        }
        catch (Throwable t) {
            this.addError("Failed to get the connected 'es-bpc-plugin' servers using the endpoint: " + req, t);
            this.setPluginState(ElasticsearchBpcPluginManager.PluginState.ERRORS);
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return result;
    }
}

