/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.plugin.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class BroadcastMessage {
    public static final String WEBSOCKET_MSG_PREFIX = "BroadcastMessage:::";
    public static final String EVENT_PROPERTY_NAME = "BroadcastMessage";
    String sender;
    long sendedAtUtcMilli;
    String type;
    Object data;

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public long getSendedAtUtcMilli() {
        return this.sendedAtUtcMilli;
    }

    public void setSendedAtUtcMilli(long sendedAtUtcMilli) {
        this.sendedAtUtcMilli = sendedAtUtcMilli;
    }

    @JsonIgnore
    public void setSendedAt(LocalDateTime sendedAt) {
        this.sendedAtUtcMilli = sendedAt.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @JsonIgnore
    public LocalDateTime getSendedAt() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.sendedAtUtcMilli), ZoneOffset.UTC);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return "BroadcastMessage{sender='" + this.sender + "', sendedAtUtcMilli=" + this.sendedAtUtcMilli + " (" + this.getSendedAt() + "), type='" + this.type + "', data='" + this.data + "'}";
    }

    public static enum BroadcastType {
        ModuleInstanceDeleted,
        ModuleInstanceUpdated,
        ModuleInstanceCreated,
        ModuleUpdated,
        ClientEvent;

    }
}

