/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.plugin.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class ClusterMessage {
    public static final String WEBSOCKET_MSG_PREFIX = "ClusterMessage:::";
    public static final String EVENT_PROPERTY_NAME = "ClusterMessage";
    String action;
    String serverUUID;
    long sendedAtUtcMilli;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public void setServerUUID(String serverUUID) {
        this.serverUUID = serverUUID;
    }

    public long getSendedAtUtcMilli() {
        return this.sendedAtUtcMilli;
    }

    public void setSendedAtUtcMilli(long sendedAtUtcMilli) {
        this.sendedAtUtcMilli = sendedAtUtcMilli;
    }

    @JsonIgnore
    public void setSendedAt(LocalDateTime sendedAt) {
        this.sendedAtUtcMilli = sendedAt.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @JsonIgnore
    public LocalDateTime getSendedAt() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.sendedAtUtcMilli), ZoneOffset.UTC);
    }

    public String toString() {
        return "ClusterMessage{action='" + this.action + "', serverUUID='" + this.serverUUID + "', sendedAtUtcMilli=" + this.sendedAtUtcMilli + " (" + this.getSendedAt() + ")}";
    }
}

