/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.plugin.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IndexOperation {
    public static final String WEBSOCKET_MSG_PREFIX = "IndexOperation:::";
    public static final String EVENT_PROPERTY_NAME = "IndexOperation";
    String index;
    Set<String> aliasesOfIndex;
    String type;
    String id;
    Operation operation;
    long version;
    long timestampInUtcMillis;
    Map<String, Object> source;

    public String getIndex() {
        return this.index;
    }

    public Set<String> getAliasesOfIndex() {
        return this.aliasesOfIndex;
    }

    public Set<String> getIndexAndAliasNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.aliasesOfIndex != null) {
            result.addAll(this.aliasesOfIndex);
        }
        if (this.index != null) {
            result.add(this.index);
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public long getVersion() {
        return this.version;
    }

    public long getTimestampInUtcMillis() {
        return this.timestampInUtcMillis;
    }

    @JsonIgnore
    public LocalDateTime getTimestamp() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.timestampInUtcMillis), ZoneOffset.UTC);
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    public String toString() {
        return "IndexOperation{index='" + this.index + "', aliasesOfIndex=" + this.aliasesOfIndex + ", type='" + this.type + "', id='" + this.id + "', operation=" + this.operation + ", version=" + this.version + ", timestampInUtcMillis=" + this.timestampInUtcMillis + " (" + this.getTimestamp() + "), source='" + this.source + "'}";
    }

    public static enum Operation {
        INDEX,
        CREATE,
        DELETE;

    }
}

