/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.plugin.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.virtimo.bpc.api.BpcServicesTracker;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ServerStateInfo {
    private static final Logger LOG = Logger.getLogger(ServerStateInfo.class.getName());
    String serverUUID;
    String serverHostname;
    String serverAddress;
    String serverHttpPort;
    String serverHttpsPort;
    String bpcName;
    String bpcUrl;
    boolean maintenanceModeEnabled;
    boolean replicationEnabled;
    long sendedAtUtcMilli;

    public static ServerStateInfo create(boolean maintenanceModeEnabled, boolean replicationEnabled, String serverUUID, String bpcName, String bpcUrl) {
        ServerStateInfo serverStateInfo = new ServerStateInfo();
        serverStateInfo.setServerUUID(serverUUID);
        try {
            serverStateInfo.setServerHostname(InetAddress.getLocalHost().getHostName());
            serverStateInfo.setServerAddress(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            LOG.info("Could not get the server hostname and address.");
        }
        BundleContext bundleContext = FrameworkUtil.getBundle(ServerStateInfo.class).getBundleContext();
        try (BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);){
            Configuration paxWebConf = configurationAdminTracker.getService().getConfiguration("org.ops4j.pax.web");
            Object httpPortObject = paxWebConf.getProcessedProperties(null).get("org.osgi.service.http.port");
            serverStateInfo.setServerHttpPort((String)httpPortObject);
            Object httpsPortObject = paxWebConf.getProcessedProperties(null).get("org.osgi.service.http.port.secure");
            serverStateInfo.setServerHttpsPort((String)httpsPortObject);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not get the server http/https ports from the configuration file: org.ops4j.pax.web.cfg", ex);
            serverStateInfo.setServerHttpPort("8181");
            serverStateInfo.setServerHttpsPort("8282");
        }
        serverStateInfo.setBpcName(bpcName);
        serverStateInfo.setBpcUrl(bpcUrl);
        serverStateInfo.setSendedAt(LocalDateTime.now());
        serverStateInfo.setMaintenanceModeEnabled(maintenanceModeEnabled);
        serverStateInfo.setReplicationEnabled(replicationEnabled);
        return serverStateInfo;
    }

    private ServerStateInfo() {
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public void setServerUUID(String serverUUID) {
        this.serverUUID = serverUUID;
    }

    public String getServerHostname() {
        return this.serverHostname;
    }

    public void setServerHostname(String serverHostname) {
        this.serverHostname = serverHostname;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getServerHttpPort() {
        return this.serverHttpPort;
    }

    public void setServerHttpPort(String serverHttpPort) {
        this.serverHttpPort = serverHttpPort;
    }

    public String getServerHttpsPort() {
        return this.serverHttpsPort;
    }

    public void setServerHttpsPort(String serverHttpsPort) {
        this.serverHttpsPort = serverHttpsPort;
    }

    public String getBpcName() {
        return this.bpcName;
    }

    public void setBpcName(String bpcName) {
        this.bpcName = bpcName;
    }

    public String getBpcUrl() {
        return this.bpcUrl;
    }

    public void setBpcUrl(String bpcUrl) {
        this.bpcUrl = bpcUrl;
    }

    public boolean isMaintenanceModeEnabled() {
        return this.maintenanceModeEnabled;
    }

    public void setMaintenanceModeEnabled(boolean maintenanceModeEnabled) {
        this.maintenanceModeEnabled = maintenanceModeEnabled;
    }

    public boolean isReplicationEnabled() {
        return this.replicationEnabled;
    }

    public void setReplicationEnabled(boolean replicationEnabled) {
        this.replicationEnabled = replicationEnabled;
    }

    public long getSendedAtUtcMilli() {
        return this.sendedAtUtcMilli;
    }

    public void setSendedAtUtcMilli(long sendedAtUtcMilli) {
        this.sendedAtUtcMilli = sendedAtUtcMilli;
    }

    @JsonIgnore
    public void setSendedAt(LocalDateTime sendedAt) {
        this.sendedAtUtcMilli = sendedAt.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @JsonIgnore
    public LocalDateTime getSendedAt() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.sendedAtUtcMilli), ZoneOffset.UTC);
    }

    public String toString() {
        return "ServerStateInfo{serverUUID='" + this.serverUUID + "', serverHostname='" + this.serverHostname + "', serverAddress='" + this.serverAddress + "', serverHttpPort='" + this.serverHttpPort + "', serverHttpsPort='" + this.serverHttpsPort + "', bpcName='" + this.bpcName + "', bpcUrl='" + this.bpcUrl + "', maintenanceModeEnabled=" + this.maintenanceModeEnabled + ", replicationEnabled=" + this.replicationEnabled + ", sendedAtUtcMilli=" + this.sendedAtUtcMilli + " (" + this.getSendedAt() + ")}";
    }
}

