/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.httpproxy.HttpProxyCallConfig;
import de.virtimo.bpc.core.httpproxy.HttpProxyServiceImpl;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.json.XML;

public class HttpProxyCall {
    private static final Logger LOG = Logger.getLogger(HttpProxyServiceImpl.class.getName());
    private final HttpProxyCallConfig config;

    public HttpProxyCall(HttpProxyCallConfig config) {
        this.config = config;
    }

    public void doConnectionTest(Map<String, Object> testData) throws ConnectionTestException {
        LOG.info("doConnectionTest testData=...");
        try {
            UserSession userSession = (UserSession)testData.get("___userSession___");
            HttpHeaders headers = (HttpHeaders)testData.get("___httpHeaders___");
            UriInfo uriInfo = (UriInfo)testData.get("___uriInfo___");
            String targetPath = (String)testData.get("targetPath");
            String targetUrl = (String)testData.get("targetUrl");
            String url = this.prepareUrl(targetPath, targetUrl, uriInfo);
            Response response = this.getWebClient(url, userSession, headers).get();
            Response.StatusType statusType = response.getStatusInfo();
            if (statusType.getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw new ConnectionTestException("Connection test failed with HTTP status code '${statusCode}': ${statusReason}", MapUtil.mapOf("url", url, "statusCode", statusType.getStatusCode(), "statusReason", statusType.getReasonPhrase()));
            }
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    public Response doGet(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, boolean forceJson) throws HttpProxyException {
        LOG.info("doGet targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., forceJson=" + forceJson);
        String url = this.prepareUrl(targetPath, targetUrl, uriInfo);
        LOG.info("forward to: " + url);
        Response response = null;
        try {
            response = this.getWebClient(url, userSession, headers).get();
            LOG.finest("GET Response Status: " + response.getStatus() + " Mediatype: " + response.getMediaType());
            response = this.prepareResponse(response, forceJson);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_TIMEOUT, "Connection to backend system '${url}' timed out.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            if (e.getCause() instanceof ConnectException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_REFUSED, "Connection to backend system '${url}' refused.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        return response;
    }

    public Response doPost(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body, boolean forceJson) throws HttpProxyException {
        LOG.info("doPost targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., body=..., forceJson=" + forceJson);
        String url = this.prepareUrl(targetPath, targetUrl, uriInfo);
        LOG.info("forward to: " + url);
        Response response = null;
        try {
            MediaType mediaType = headers.getMediaType();
            response = mediaType != null ? this.getWebClient(url, userSession, headers).type(mediaType).post((Object)Entity.entity((Object)body, (MediaType)mediaType)) : this.getWebClient(url, userSession, headers).post((Object)Entity.entity((Object)body, (String)""));
            response = this.prepareResponse(response, forceJson);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_TIMEOUT, "Connection to backend system '${url}' timed out.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            if (e.getCause() instanceof ConnectException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_REFUSED, "Connection to backend system '${url}' refused.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        return response;
    }

    public Response doPut(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body, boolean forceJson) throws HttpProxyException {
        LOG.info("doPut targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., body=..., forceJson=" + forceJson);
        String url = this.prepareUrl(targetPath, targetUrl, uriInfo);
        LOG.info("forward to: " + url);
        Response response = null;
        try {
            response = this.getWebClient(url, userSession, headers).type(headers.getMediaType()).put((Object)body);
            response = this.prepareResponse(response, forceJson);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_TIMEOUT, "Connection to backend system '${url}' timed out.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            if (e.getCause() instanceof ConnectException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_REFUSED, "Connection to backend system '${url}' refused.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        return response;
    }

    public Response doDelete(String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, boolean forceJson) throws HttpProxyException {
        LOG.info("doDelete targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., forceJson=" + forceJson);
        String url = this.prepareUrl(targetPath, targetUrl, uriInfo);
        LOG.info("forward to: " + url);
        Response response = null;
        try {
            response = this.getWebClient(url, userSession, headers).delete();
            response = this.prepareResponse(response, forceJson);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_TIMEOUT, "Connection to backend system '${url}' timed out.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            if (e.getCause() instanceof ConnectException) {
                throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_CONNECTION_REFUSED, "Connection to backend system '${url}' refused.", MapUtil.mapOf("url", url), (Throwable)e);
            }
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.UNEXPECTED, "Exception backend connection: ${error}", MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        return response;
    }

    private Response prepareResponse(Response response, boolean forceJson) {
        LOG.info("prepareResponse response=..., forceJson=" + forceJson);
        LOG.info("Check forceJson: " + forceJson + " for MediaType: " + response.getMediaType());
        try {
            if (forceJson) {
                String jsonString;
                BufferedInputStream is = new BufferedInputStream((InputStream)response.readEntity(InputStream.class));
                if (StreamUtil.isGZipped(is)) {
                    LOG.info("Found gzip encoding");
                    ((InputStream)is).reset();
                    jsonString = XML.toJSONObject((String)new String(StreamUtil.unzip(is), StandardCharsets.UTF_8)).toString();
                    response = Response.ok((Object)StreamUtil.gzip(jsonString), (MediaType)MediaType.APPLICATION_JSON_TYPE).encoding("gzip").build();
                } else {
                    LOG.info("Found no special encoding");
                    ((InputStream)is).reset();
                    jsonString = XML.toJSONObject((String)this.convertStreamToString(is)).toString();
                    response = Response.ok((Object)jsonString, (MediaType)new MediaType("application", "json", "UTF-8")).build();
                }
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            LOG.warning("Failed JSON conversion. Keep original content type: ");
            LOG.log(Level.WARNING, e.getLocalizedMessage(), e);
            LOG.info("Failed Content:\n" + response.getEntity().toString());
        }
        LOG.info("Prepare response to client");
        MultivaluedMap<String, Object> newHeaders = this.prepareResponseHeaders((MultivaluedMap<String, Object>)response.getHeaders());
        LOG.info("Old Headers: " + response.getHeaders());
        LOG.info("New Headers: " + newHeaders);
        Response newResponse = Response.fromResponse((Response)response).replaceAll(newHeaders).build();
        LOG.log(Level.INFO, "Response Status: " + newResponse.getStatus() + " Mediatype: " + newResponse.getMediaType());
        return newResponse;
    }

    private String convertStreamToString(InputStream is) {
        LOG.finest("convertStreamToString is=...");
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private String prepareUrlParams(UriInfo uriInfo) {
        LOG.finest("prepareUrlParams uriInfo=" + uriInfo);
        if (uriInfo == null) {
            return "";
        }
        MultivaluedMap queryParams = uriInfo.getQueryParameters(false);
        if (queryParams == null || queryParams.isEmpty()) {
            return "";
        }
        Object paramString = "?";
        for (String theKey : queryParams.keySet()) {
            for (String theValue : (List)queryParams.get((Object)theKey)) {
                if (!((String)paramString).equals("?")) {
                    paramString = (String)paramString + "&";
                }
                paramString = (String)paramString + theKey + "=" + theValue;
                LOG.finest("Found query param: " + theKey + " = " + theValue);
            }
        }
        return paramString;
    }

    private MultivaluedMap<String, String> prepareHeaders(HttpHeaders headers, List<String> cookieFilters) {
        LOG.finest("prepareHeaders headers=..., cookieFilters=...");
        return this.prepareHeaders((MultivaluedMap<String, String>)headers.getRequestHeaders(), cookieFilters);
    }

    private MultivaluedMap<String, Object> prepareResponseHeaders(MultivaluedMap<String, Object> headers) {
        LOG.finest("prepareResponseHeaders headers=...");
        MultivaluedHashMap newMap = new MultivaluedHashMap();
        for (String key : headers.keySet()) {
            List strings = ((List)headers.get((Object)key)).stream().map(Object::toString).collect(Collectors.toList());
            newMap.put((Object)key, strings);
        }
        MultivaluedMap<String, String> preparedMap = this.prepareHeaders((MultivaluedMap<String, String>)newMap, null);
        MultivaluedHashMap resultMap = new MultivaluedHashMap();
        for (String key : preparedMap.keySet()) {
            ArrayList objects = new ArrayList((Collection)preparedMap.get((Object)key));
            resultMap.put((Object)key, objects);
        }
        return resultMap;
    }

    private List<String> getHeaderValues(MultivaluedMap<String, String> headers, String caseInsensitiveKey) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                if (!key.equalsIgnoreCase(caseInsensitiveKey)) continue;
                return (List)headers.get((Object)key);
            }
        }
        return null;
    }

    private Set<String> getHttpHeaderFilterValuesInLowerCase() {
        HashSet<String> result = new HashSet<String>();
        List httpHeaderFilters = this.config.getHttpHeaderFilters();
        if (httpHeaderFilters != null) {
            for (Object httpHeaderFilter : httpHeaderFilters) {
                if (httpHeaderFilter instanceof String) {
                    result.add(((String)httpHeaderFilter).toLowerCase());
                    continue;
                }
                if (httpHeaderFilter == null) continue;
                result.add(String.valueOf(httpHeaderFilter).toLowerCase());
            }
        }
        return result;
    }

    private MultivaluedMap<String, String> prepareHeaders(MultivaluedMap<String, String> oldHeaders, List<String> cookieFilters) {
        LOG.finest("prepareHeaders oldHeaders=" + oldHeaders + ", cookieFilters=" + cookieFilters);
        MultivaluedHashMap newHeaders = new MultivaluedHashMap();
        Set<String> headerIgnoreListEntriesInLowerCase = this.getHttpHeaderFilterValuesInLowerCase();
        if (cookieFilters == null) {
            cookieFilters = new ArrayList<String>();
        }
        cookieFilters.add("(?i);[^;.]*path[^;,$]*");
        for (String key : oldHeaders.keySet()) {
            if (key.equalsIgnoreCase("cookie") || key.equalsIgnoreCase("set-cookie")) {
                ArrayList<String> newCookieList = new ArrayList<String>();
                for (String cookie : (List)oldHeaders.get((Object)key)) {
                    LOG.finest("OLD Cookie: " + cookie);
                    String newCookie = cookie;
                    for (String filter : cookieFilters) {
                        newCookie = newCookie.replaceAll(filter, "");
                    }
                    newCookieList.add(newCookie);
                    LOG.finest("NEW Cookie: " + newCookie);
                }
                newHeaders.put((Object)key, newCookieList);
                continue;
            }
            if (key.equalsIgnoreCase("host")) {
                List oldHostValues = (List)oldHeaders.get((Object)key);
                if (oldHostValues == null) continue;
                ArrayList<String> newForwardedHosts = new ArrayList<String>();
                List<String> oldForwardedHosts = this.getHeaderValues(oldHeaders, "X-Forwarded-Host");
                if (oldForwardedHosts != null) {
                    newForwardedHosts.addAll(oldForwardedHosts);
                }
                newForwardedHosts.addAll(oldHostValues);
                LOG.finest("Header X-Forwarded-Host" + newForwardedHosts);
                newHeaders.put((Object)"X-Forwarded-Host", newForwardedHosts);
                continue;
            }
            if (!headerIgnoreListEntriesInLowerCase.contains(key.toLowerCase())) {
                List values = (List)oldHeaders.get((Object)key);
                if (values.size() < 1 || values.size() == 1 && values.get(0) == null) {
                    LOG.finest("SKIP empty or null Header " + key + " - " + values);
                    continue;
                }
                LOG.finest("Header " + key + " - " + values);
                newHeaders.put((Object)key, new ArrayList(values));
                continue;
            }
            LOG.finest("Remove header: " + key);
        }
        LOG.info("newHeaders: " + (MultivaluedMap)newHeaders);
        return newHeaders;
    }

    String prepareUrl(String targetPath, String targetUrl, UriInfo uriInfo) throws HttpProxyException {
        LOG.fine("prepareUrl targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo);
        Object baseUrl = this.config.getBaseUrl();
        if (baseUrl == null) {
            baseUrl = "";
        }
        if (targetUrl == null) {
            LOG.info("targetUrl missing");
            targetUrl = "";
        }
        if (targetPath == null) {
            LOG.info("targetPath missing");
            targetPath = "";
        }
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        if (targetPath.startsWith("/")) {
            targetPath = targetPath.substring(1);
        }
        if (targetPath.endsWith("/") && targetUrl.startsWith("/")) {
            targetPath = targetPath.substring(0, targetPath.length() - 1);
        }
        try {
            URL url = new URL((String)baseUrl + targetPath + targetUrl + this.prepareUrlParams(uriInfo));
            LOG.info("Target url: " + url);
            if (Arrays.asList("LOCALHOST", "127.0.0.1").contains(url.getHost().toUpperCase())) {
                try {
                    String realHost = InetAddress.getLocalHost().getHostName();
                    url = url.getRef() != null ? new URL(url.getProtocol(), realHost, url.getPort(), url.getFile() + "#" + url.getRef()) : new URL(url.getProtocol(), realHost, url.getPort(), url.getFile());
                }
                catch (UnknownHostException ex) {
                    throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_ILLEGAL_ACCESS, "No URLs to local interface allowed: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
            LOG.info("Final target url: " + url);
            return url.toExternalForm();
        }
        catch (MalformedURLException ex) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_MALFORMED_URL, "Malformed URL: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    private WebClient getWebClient(String url, UserSession userSession, HttpHeaders headers) throws KeyStoreException, NoSuchAlgorithmException {
        WebClient client;
        LOG.finest("getWebClient url=" + url + ", userSession=..., headers=" + headers);
        if (this.config.isBasicAuthEnabled()) {
            client = WebClient.create((String)url, (String)this.config.getBasicAuthUsername(), (String)this.config.getBasicAuthPassword(), null);
            LOG.info("Using BasicAuth");
        } else {
            client = WebClient.create((String)url);
            LOG.info("Not using BasicAuth");
        }
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        HTTPClientPolicy policy = conduit.getClient();
        long timeout = this.config.getTimeout();
        if (timeout > 0L) {
            LOG.info("Set timeout to " + timeout);
            policy.setReceiveTimeout(timeout * 1000L);
            policy.setConnectionTimeout(timeout * 1000L);
        }
        String proxyServer = this.config.getProxyServer();
        Integer proxyServerPort = this.config.getProxyServerPort();
        if (proxyServer != null && proxyServer.trim().length() > 0) {
            LOG.log(Level.FINE, "Use proxy server {0}:{1}", new Object[]{proxyServer, proxyServerPort});
            policy.setProxyServer(proxyServer);
            policy.setProxyServerPort(proxyServerPort);
        }
        BpcTrustStore.getInstance().setTo(client, this.config.isAllowUntrustedConnectionsEnabled());
        if (this.config.isInjectSessionJwtEnabled()) {
            LOG.finest("inject userSession as JWT");
            JWTClaimsSet claimsSet = null;
            try {
                claimsSet = new JWTClaimsSet.Builder().subject("bpc").expirationTime(new Date(new Date().getTime() + 60000L)).claim("bpcUserSession", (Object)JsonUtil.getInstance().convertPojoToJsonString(userSession)).build();
                PlainJWT sessionJwt = new PlainJWT(claimsSet);
                MultivaluedHashMap jwtHeader = new MultivaluedHashMap();
                String bpcUserSessionJwt = sessionJwt.serialize();
                jwtHeader.putSingle((Object)"X-Bpc-Session", (Object)bpcUserSessionJwt);
                LOG.finest("JWT: " + bpcUserSessionJwt);
                client = client.headers((MultivaluedMap)jwtHeader);
            }
            catch (JsonProcessingException e) {
                LOG.log(Level.SEVERE, "failed to inject userSession as JWT", e);
            }
        }
        ArrayList<String> cookieFilter = new ArrayList<String>();
        if (this.config.isFilterSessionCookieEnabled()) {
            cookieFilter.add(userSession.getSessionId());
        }
        MultivaluedMap<String, String> newHeaders = this.prepareHeaders(headers, cookieFilter);
        Map<String, String> additionalHttpHeadersToSet = this.config.getAdditionalHttpHeaders();
        for (String httpHeaderName : additionalHttpHeadersToSet.keySet()) {
            String httpHeaderValue = additionalHttpHeadersToSet.get(httpHeaderName);
            newHeaders.add((Object)httpHeaderName, (Object)httpHeaderValue);
        }
        client = client.headers(newHeaders);
        if (!newHeaders.containsKey((Object)"Accept") || ((List)newHeaders.get((Object)"Accept")).isEmpty()) {
            client.accept(new String[]{"*/*"});
        }
        return client;
    }
}

