/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.httpproxy.HttpProxyCall;
import de.virtimo.bpc.core.httpproxy.HttpProxyCallConfigFromBackendConnection;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;

public class HttpProxyServiceImpl
implements HttpProxyService,
BpcService {
    private static final Logger LOG = Logger.getLogger(HttpProxyServiceImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public HttpProxyServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public ModuleConfiguration getConfig(String backendConnectionInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        BackendConnectionsModule backendConnectionModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        ModuleInstance backendConnectionInstance = backendConnectionModule.getModuleInstanceById(backendConnectionInstanceId);
        return backendConnectionInstance.getConfiguration();
    }

    private HttpProxyCall getHttpProxyCallForBackendConnectionInstance(String backendConnectionInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        BackendConnectionsModule backendConnectionModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        ModuleInstance backendConnectionInstance = backendConnectionModule.getModuleInstanceById(backendConnectionInstanceId);
        HttpProxyCallConfigFromBackendConnection config = new HttpProxyCallConfigFromBackendConnection(backendConnectionInstance);
        config.addAdditionalHttpHeader("X-BPC-Server-UUID", this.coreBundleConfigurationTracker.getService().getServerUUID());
        return new HttpProxyCall(config);
    }

    @Override
    public Response doGet(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doGet backendConnectionInstanceId=" + backendConnectionInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doGet(targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
    }

    @Override
    public Response doPost(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doPost backendConnectionInstanceId=" + backendConnectionInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., body=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doPost(targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
    }

    @Override
    public Response doPut(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doPut backendConnectionInstanceId=" + backendConnectionInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., body=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doPut(targetPath, targetUrl, uriInfo, headers, userSession, body, forceJson);
    }

    @Override
    public Response doDelete(String backendConnectionInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, boolean forceJson) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("doDelete backendConnectionInstanceId=" + backendConnectionInstanceId + ", targetPath=" + targetPath + ", targetUrl=" + targetUrl + ", uriInfo=" + uriInfo + ", headers=..., userSession=..., forceJson=" + forceJson);
        return this.getHttpProxyCallForBackendConnectionInstance(backendConnectionInstanceId).doDelete(targetPath, targetUrl, uriInfo, headers, userSession, forceJson);
    }
}

