/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.internationalization;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.InternationalizationService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.internationalization.InternationalizationException;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="i18n")
public class InternationalizationEndpoint {
    private static final Logger LOG = Logger.getLogger(InternationalizationEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<InternationalizationService> internationalizationServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public InternationalizationEndpoint(BundleContext bundleContext) {
        LOG.info("InternationalizationEndpoint");
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.internationalizationServiceTracker = new BpcServicesTracker<InternationalizationService>(this.bundleContext, InternationalizationService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private String getDefaultLanguage() {
        try {
            return this.internationalizationServiceTracker.getService().getFallbackLanguage();
        }
        catch (Exception e) {
            return "en";
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/languages")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    public Response getUsedLanguages(@QueryParam(value="only_keys") @DefaultValue(value="false") boolean onlyKeys) {
        LOG.info("getUsedLanguages");
        try {
            if (onlyKeys) {
                return Response.ok(this.internationalizationServiceTracker.getService().getKeysOfUsedLanguages(), (String)"application/json").build();
            }
            return Response.ok(this.internationalizationServiceTracker.getService().getUsedLanguages(), (String)"application/json").build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/languages/all")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    public Response getAllLanguages(@QueryParam(value="only_keys") @DefaultValue(value="false") boolean onlyKeys) {
        LOG.info("getAllLanguages onlyKeys=" + onlyKeys);
        try {
            if (onlyKeys) {
                return Response.ok(this.internationalizationServiceTracker.getService().getKeysOfAllLanguages(), (String)"application/json").build();
            }
            return Response.ok(this.internationalizationServiceTracker.getService().getAllLanguages(), (String)"application/json").build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/translations")
    @BpcRoleOrRightRequired(role="TRANSLATIONS_ADMIN", right="TRANSLATIONS_RELOAD", message="You are not allowed to force a translations reload.")
    public Response forceTranslationsReload() {
        LOG.info("forceTranslationsReload");
        try {
            this.internationalizationServiceTracker.getService().forceTranslationsReload();
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/translations/{lang}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    public Response getTranslations(@PathParam(value="lang") String lang, @QueryParam(value="ict") @DefaultValue(value="false") boolean ignoreCustomTranslations, @QueryParam(value="fallback") @DefaultValue(value="true") boolean fallbackToDefaultLanguageWhenMissing) {
        LOG.info("getTranslations lang=" + lang + ", ignoreCustomTranslations=" + ignoreCustomTranslations + ", fallbackToDefaultLanguageWhenMissing=" + fallbackToDefaultLanguageWhenMissing);
        try {
            InternationalizationService internationalizationService = this.internationalizationServiceTracker.getService();
            if (!fallbackToDefaultLanguageWhenMissing && !internationalizationService.getKeysOfUsedLanguages().contains(lang.toLowerCase())) {
                throw new InternationalizationException((ErrorCode)CoreErrorCode.INTERNATIONALIZATION_LANGUAGE_NOT_FOUND, "Failed to get translations. The language '${lang}' does not exist.", MapUtil.mapOf("lang", lang));
            }
            Map<String, Object> translationsForLanguage = internationalizationService.getTranslationsForLanguage(lang.toLowerCase(), ignoreCustomTranslations, fallbackToDefaultLanguageWhenMissing);
            TreeMap<String, Object> sortedTranslationsForLanguage = new TreeMap<String, Object>(translationsForLanguage);
            return Response.ok(sortedTranslationsForLanguage, (String)"application/json").build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to collect the translations", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/language/{lang}/valid")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    public Response getValidLanguage(@PathParam(value="lang") String lang) {
        LOG.info("getValidLanguage lang=" + lang);
        try {
            InternationalizationService internationalizationService = this.internationalizationServiceTracker.getService();
            if (!internationalizationService.getKeysOfUsedLanguages().contains(lang.toLowerCase())) {
                lang = this.getDefaultLanguage();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to validate the language=" + lang, ex);
            lang = this.getDefaultLanguage();
        }
        return Response.ok(MapUtil.mapOf("language", lang.toLowerCase()), (String)"application/json").build();
    }
}

