/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.internationalization;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.service.InternationalizationService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.internationalization.TranslationsOfBundles;
import de.virtimo.bpc.core.internationalization.TranslationsOfSetting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class InternationalizationServiceImpl
implements InternationalizationService,
BpcService {
    private static final Logger LOG = Logger.getLogger(InternationalizationServiceImpl.class.getName());
    public static final String DEFAULT_LANGUAGE = "en";
    private static final Object TRANSLATIONS_LOCK = new Object();
    private final BundleContext bundleContext;
    private final BundleChangedListener bundleChangedListener;
    private final EventRegistration eventRegistration;
    private final Set<String> isoLanguages;
    private String fallbackLanguage;
    private final TranslationsOfBundles translationsOfBundles;
    private final TranslationsOfSetting translationsOfSetting;

    public InternationalizationServiceImpl(BundleContext bundleContext) {
        LOG.info("InternationalizationServiceImpl bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.isoLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        this.fallbackLanguage = DEFAULT_LANGUAGE;
        this.translationsOfBundles = new TranslationsOfBundles(bundleContext);
        this.translationsOfSetting = new TranslationsOfSetting();
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("_core", new CoreModuleLoadedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("_core", "translationsFallbackLanguage", new TranslationsFallbackLanguageSettingUpdatedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("_core", "customTranslations", new CustomTranslationsSettingUpdatedEventHandler());
        this.bundleChangedListener = new BundleChangedListener();
        this.bundleContext.addBundleListener((BundleListener)this.bundleChangedListener);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.log(Level.FINEST, "shutdownService");
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.bundleChangedListener);
        }
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public String getFallbackLanguage() {
        return this.fallbackLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeysOfUsedLanguages() {
        LOG.info("getKeysOfUsedLanguages");
        Object object = TRANSLATIONS_LOCK;
        synchronized (object) {
            return this._getLanguages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map<String, String>> getUsedLanguages() {
        LOG.info("getLanguagesMap");
        Object object = TRANSLATIONS_LOCK;
        synchronized (object) {
            HashSet<Map<String, String>> result = new HashSet<Map<String, String>>();
            for (String localeKey : this._getLanguages()) {
                result.add(this.createDetailedLanguageMap(localeKey));
            }
            return result;
        }
    }

    private Set<String> _getLanguages() {
        LOG.info("_getLanguages");
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.translationsOfBundles.getLanguages());
        result.addAll(this.translationsOfSetting.getLanguages());
        return result;
    }

    @Override
    public Set<String> getKeysOfAllLanguages() {
        LOG.info("getKeysOfAllLanguages");
        return this.isoLanguages;
    }

    @Override
    public Set<Map<String, String>> getAllLanguages() {
        LOG.info("getAllLanguages");
        HashSet<Map<String, String>> result = new HashSet<Map<String, String>>();
        for (String localeKey : this.getKeysOfAllLanguages()) {
            result.add(this.createDetailedLanguageMap(localeKey));
        }
        return result;
    }

    private Map<String, String> createDetailedLanguageMap(String localeKey) {
        Locale l = new Locale(localeKey);
        return Map.of("id", localeKey, "name", l.getDisplayName(), "nativeName", l.getDisplayName(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceTranslationsReload() {
        LOG.info("forceTranslationsReload");
        Object object = TRANSLATIONS_LOCK;
        synchronized (object) {
            this.translationsOfBundles.forceTranslationsReload();
        }
    }

    @Override
    public Map<String, Object> getTranslationsForLanguage(String lang) {
        LOG.info("getTranslationsForLanguage lang=" + lang);
        return this.getTranslationsForLanguage(lang, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getTranslationsForLanguage(String lang, boolean ignoreCustomTranslations, boolean fallbackToDefaultLanguageWhenMissing) {
        LOG.info("getTranslationsForLanguage lang=" + lang + ", ignoreCustomTranslations=" + ignoreCustomTranslations + ", fallbackToDefaultLanguageWhenMissing=" + fallbackToDefaultLanguageWhenMissing);
        Object object = TRANSLATIONS_LOCK;
        synchronized (object) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (fallbackToDefaultLanguageWhenMissing && !this.fallbackLanguage.equalsIgnoreCase(lang)) {
                result.putAll(this.translationsOfBundles.getTranslationsForLanguage(this.fallbackLanguage));
            }
            result.putAll(this.translationsOfBundles.getTranslationsForLanguage(lang.toLowerCase()));
            if (!ignoreCustomTranslations) {
                result.putAll(this.translationsOfSetting.getTranslationsForLanguage(lang.toLowerCase()));
            }
            return result;
        }
    }

    private class CoreModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            CoreModule coreModule = (CoreModule)module;
            InternationalizationServiceImpl.this.fallbackLanguage = coreModule.getConfiguration().getSettingValue("translationsFallbackLanguage").asString(InternationalizationServiceImpl.DEFAULT_LANGUAGE);
            InternationalizationServiceImpl.this.translationsOfSetting.updateWithSetting(coreModule.getConfiguration().getSetting("customTranslations"));
        }
    }

    private class TranslationsFallbackLanguageSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private TranslationsFallbackLanguageSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting translationsFallbackLanguageSetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting translationsFallbackLanguageSetting=...");
            InternationalizationServiceImpl.this.fallbackLanguage = translationsFallbackLanguageSetting.getSettingValue().asString(InternationalizationServiceImpl.DEFAULT_LANGUAGE);
        }
    }

    private class CustomTranslationsSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private CustomTranslationsSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting customTranslationsSetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting customTranslationsSetting=...");
            InternationalizationServiceImpl.this.translationsOfSetting.updateWithSetting(customTranslationsSetting);
        }
    }

    private class BundleChangedListener
    implements BundleListener {
        private BundleChangedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            LOG.info("bundleChanged event=" + event);
            Object object = TRANSLATIONS_LOCK;
            synchronized (object) {
                if (!InternationalizationServiceImpl.this.translationsOfBundles.isInitialized()) {
                    LOG.info("Nothing to do until the translations are loaded once");
                } else if (event.getType() == 2) {
                    InternationalizationServiceImpl.this.translationsOfBundles.loadTranslationsFromBundle(event.getBundle());
                } else if (event.getType() == 4) {
                    InternationalizationServiceImpl.this.translationsOfBundles.removeTranslationsOfBundle(event.getBundle());
                }
            }
        }
    }
}

