/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.license;

import de.virtimo.bpc.api.AbstractLicense;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlFileLicense
extends AbstractLicense {
    private static final Logger LOG = Logger.getLogger(XmlFileLicense.class.getName());
    public static final String LICENSE_FILE_NAME = "license.xml.bpc";

    public XmlFileLicense(File licenseFile) throws FileNotFoundException, IOException {
        super(LICENSE_FILE_NAME);
        try (FileInputStream xmlInputStream = new FileInputStream(licenseFile);){
            Map<String, Object> licenseKeyObjectMap = this.getMapFromLicenseXml(xmlInputStream);
            this.setLicenseMap(licenseKeyObjectMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getMapFromLicenseXml(InputStream xmlInputStream) {
        HashMap<String, Object> licenseMap = new HashMap<String, Object>();
        XMLStreamReader reader = null;
        try {
            int event;
            reader = XMLInputFactory.newFactory().createXMLStreamReader(xmlInputStream);
            String elementName = null;
            Stack<String> elementStack = new Stack<String>();
            boolean bpcLicenseMode = false;
            boolean licenseKeyMode = false;
            boolean licenseMapMode = false;
            boolean licenseListMode = false;
            while ((event = reader.next()) != 8) {
                String value;
                if (event == 1) {
                    elementName = reader.getLocalName();
                    elementStack.push(elementName);
                    if ("bpc".equalsIgnoreCase(elementName)) {
                        bpcLicenseMode = true;
                        continue;
                    }
                    if (!bpcLicenseMode) continue;
                    if ("licenseKeys".equalsIgnoreCase(elementName)) {
                        licenseKeyMode = true;
                        continue;
                    }
                    if ("licenseMaps".equalsIgnoreCase(elementName)) {
                        licenseMapMode = true;
                        continue;
                    }
                    if (!"licenseLists".equalsIgnoreCase(elementName)) continue;
                    licenseListMode = true;
                    continue;
                }
                if (event == 2) {
                    elementName = reader.getLocalName();
                    elementStack.pop();
                    if ("bpc".equalsIgnoreCase(elementName)) {
                        bpcLicenseMode = false;
                        continue;
                    }
                    if (!bpcLicenseMode) continue;
                    if ("licenseKeys".equalsIgnoreCase(elementName)) {
                        licenseKeyMode = false;
                        continue;
                    }
                    if ("licenseMaps".equalsIgnoreCase(elementName)) {
                        licenseMapMode = false;
                        continue;
                    }
                    if ("licenseLists".equalsIgnoreCase(elementName)) {
                        licenseListMode = false;
                        continue;
                    }
                    if (!licenseListMode) continue;
                    String listName = (String)elementStack.elementAt(elementStack.size() - 1);
                    if (!licenseMap.containsKey(listName)) {
                        licenseMap.put(listName, new ArrayList());
                    }
                    List targetList = (List)licenseMap.get(listName);
                    targetList.add(elementName);
                    LOG.info("ADD LIST: " + listName + "." + elementName);
                    continue;
                }
                if (event != 4) continue;
                if (licenseKeyMode && !reader.isWhiteSpace()) {
                    value = reader.getText().trim();
                    licenseMap.put(elementName, value);
                    LOG.info("ADD: " + elementName + " = " + value);
                    continue;
                }
                if (!licenseMapMode || reader.isWhiteSpace()) continue;
                value = reader.getText().trim();
                String mapName = (String)elementStack.elementAt(elementStack.size() - 2);
                if (!licenseMap.containsKey(mapName)) {
                    licenseMap.put(mapName, new HashMap());
                }
                Map targetMap = (Map)licenseMap.get(mapName);
                targetMap.put(elementName, value);
                LOG.info("ADD MAP: " + mapName + "." + elementName + " = " + value);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error retrieving xml configuration", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return licenseMap;
    }
}

