/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.lookupjoins;

import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class LookupJoin {
    private static final Logger LOG = Logger.getLogger(LookupJoin.class.getName());
    private static final Map<String, Object> NotFound = new HashMap<String, Object>();
    private String keyField;
    private String keyFieldValuesSeparator;
    private String lookupIndex;
    private String lookupKeyField;
    private String resultFieldsPrefix;
    private String[] resultFieldsIncluded;
    private String[] resultFieldsExcluded;
    private boolean cachingEnabled;
    private Map<Object, Map<String, Object>> cache;

    public LookupJoin(Map<String, Object> lookupJoinConfig) {
        this.keyField = MapUtil.getValueAsString(lookupJoinConfig, "keyField", null);
        this.keyFieldValuesSeparator = MapUtil.getValueAsString(lookupJoinConfig, "keyFieldValuesSeparator", null);
        this.lookupIndex = MapUtil.getValueAsString(lookupJoinConfig, "lookupIndex", null);
        this.lookupKeyField = MapUtil.getValueAsString(lookupJoinConfig, "lookupKeyField", null);
        this.resultFieldsPrefix = MapUtil.getValueAsString(lookupJoinConfig, "resultFieldsPrefix", null);
        this.resultFieldsIncluded = MapUtil.getValueAsStringArray(lookupJoinConfig, "resultFieldsIncluded", null);
        this.resultFieldsExcluded = MapUtil.getValueAsStringArray(lookupJoinConfig, "resultFieldsExcluded", null);
        this.cachingEnabled = MapUtil.getValueAsBoolean(lookupJoinConfig, "caching", true);
        this.cache = new HashMap<Object, Map<String, Object>>();
    }

    public void clearCache() {
        LOG.fine("clearCache");
        this.cache.clear();
    }

    public String getKeyField() {
        return this.keyField;
    }

    public boolean isMultiValueKeyField() {
        return !StringUtil.isNullOrEmpty(this.keyFieldValuesSeparator);
    }

    public String getKeyFieldValuesSeparator() {
        return this.keyFieldValuesSeparator;
    }

    public String getLookupIndex() {
        return this.lookupIndex;
    }

    public String getLookupKeyField() {
        return this.lookupKeyField;
    }

    public String getResultFieldsPrefix() {
        return this.resultFieldsPrefix;
    }

    public String getResultFieldName(String fieldName) {
        return this.resultFieldsPrefix + fieldName;
    }

    public Map<String, Object> getAlreadyPrefixedLookupData(ElasticsearchService es, Object keyValue) throws ElasticsearchRelatedException {
        HashMap<String, Object> result;
        block10: {
            block9: {
                LOG.fine("getAlreadyPrefixedLookupData keyValue:" + keyValue);
                result = new HashMap<String, Object>();
                if (!this.isMultiValueKeyField()) break block9;
                List<String> values = StringUtil.explode((String)keyValue, this.keyFieldValuesSeparator);
                if (values == null) break block10;
                boolean previousLookupDataNotFound = false;
                for (String value : values) {
                    Map<String, Object> lookupData = this.getLookupData(es, value);
                    if (!lookupData.isEmpty()) {
                        String resultFieldName;
                        if (previousLookupDataNotFound) {
                            for (Map.Entry<String, Object> stringObjectEntry : lookupData.entrySet()) {
                                resultFieldName = this.getResultFieldName(stringObjectEntry.getKey());
                                Object existingResultFieldValueObject = result.get(resultFieldName);
                                if (existingResultFieldValueObject == null) {
                                    result.put(resultFieldName, this.keyFieldValuesSeparator);
                                    continue;
                                }
                                result.put(resultFieldName, existingResultFieldValueObject + this.keyFieldValuesSeparator);
                            }
                        }
                        previousLookupDataNotFound = false;
                        for (Map.Entry<String, Object> stringObjectEntry : lookupData.entrySet()) {
                            resultFieldName = this.getResultFieldName(stringObjectEntry.getKey());
                            Object resultFieldValue = stringObjectEntry.getValue();
                            String resultFieldValueAsString = resultFieldValue == null ? null : resultFieldValue.toString();
                            Object existingResultFieldValueObject = result.get(resultFieldName);
                            if (existingResultFieldValueObject == null) {
                                result.put(resultFieldName, resultFieldValueAsString);
                                continue;
                            }
                            result.put(resultFieldName, existingResultFieldValueObject + this.keyFieldValuesSeparator + resultFieldValueAsString);
                        }
                        continue;
                    }
                    previousLookupDataNotFound = true;
                }
                break block10;
            }
            Map<String, Object> lookupData = this.getLookupData(es, keyValue);
            if (!lookupData.isEmpty()) {
                for (Map.Entry<String, Object> stringObjectEntry : lookupData.entrySet()) {
                    String resultFieldName = this.getResultFieldName(stringObjectEntry.getKey());
                    Object resultFieldValue = stringObjectEntry.getValue();
                    result.put(resultFieldName, resultFieldValue);
                }
            }
        }
        return result;
    }

    private Map<String, Object> getLookupData(ElasticsearchService es, Object keyValue) throws ElasticsearchRelatedException {
        Map<String, Object> cachedResult;
        LOG.fine("getLookupData keyValue:" + keyValue);
        if (keyValue == null) {
            return NotFound;
        }
        if (this.cachingEnabled && (cachedResult = this.cache.get(keyValue)) != null) {
            if (cachedResult.size() == 0) {
                LOG.fine(keyValue + ": No cached result found");
                return NotFound;
            }
            LOG.fine(keyValue + ": Returning cached result: " + cachedResult);
            return cachedResult;
        }
        try {
            RestHighLevelClient esClient = es.getClient();
            SearchRequest searchReq = new SearchRequest().indices(this.lookupIndex).source(new SearchSourceBuilder().from(0).size(2).query(QueryBuilders.constantScoreQuery(QueryBuilders.termQuery(this.lookupKeyField, keyValue))).fetchSource(this.resultFieldsIncluded, this.resultFieldsExcluded)).searchType(SearchType.DEFAULT);
            SearchResponse response = esClient.search(searchReq, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            Map<String, Object> result = null;
            if (hits == null || hits.length == 0) {
                LOG.fine(keyValue + ": No lookup document found. " + this);
            } else if (hits.length > 1) {
                LOG.log(Level.SEVERE, keyValue + ": No unique lookup document found. They must be unique. " + this);
            } else {
                result = hits[0].getSourceAsMap();
                LOG.fine(keyValue + ": Found the lookup document: " + result);
            }
            if (this.cachingEnabled) {
                if (result == null) {
                    LOG.fine(keyValue + ": Caching the 'Not found' result");
                    this.cache.put(keyValue, NotFound);
                } else {
                    LOG.fine(keyValue + ": Caching the found result: " + result);
                    this.cache.put(keyValue, result);
                }
            }
            return result == null ? NotFound : result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public String toString() {
        return "LookupJoin{keyField='" + this.keyField + "', keyFieldValuesSeparator='" + this.keyFieldValuesSeparator + "', lookupIndex='" + this.lookupIndex + "', lookupKeyField='" + this.lookupKeyField + "', resultFieldsPrefix='" + this.resultFieldsPrefix + "', resultFieldsIncluded=" + Arrays.toString(this.resultFieldsIncluded) + ", resultFieldsExcluded=" + Arrays.toString(this.resultFieldsExcluded) + ", cachingEnabled=" + this.cachingEnabled + "}";
    }
}

