/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.lookupjoins;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.XContentBuilderUtil;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.response.Filter;
import de.virtimo.bpc.core.es.plugin.response.Filters;
import de.virtimo.bpc.core.es.plugin.response.IndexOperation;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.lookupjoins.LookupJoinUpdaterData;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsException;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsUpdater;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobNotFoundException;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;

public class LookupJoinsManagerImpl
implements LookupJoinsManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(LookupJoinsManager.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerTracker;
    private final EventRegistration eventRegistration;
    private ExecutorService executorService;
    private Map<String, Future<Boolean>> lookupJoinsUpdates;

    public LookupJoinsManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.elasticsearchBpcPluginManagerTracker = new BpcServicesTracker<ElasticsearchBpcPluginManager>(bundleContext, ElasticsearchBpcPluginManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("logservice", new LogServiceModuleLoadedEventHandler());
    }

    private void initializeExecutor() {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-lookupjoins-updater"));
        }
        if (this.lookupJoinsUpdates == null) {
            this.lookupJoinsUpdates = new HashMap<String, Future<Boolean>>();
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.stop();
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public synchronized void stop() {
        LOG.info("stop");
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.executorService = null;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Failed to shutdown the lookup joins thread pool.");
            }
        }
    }

    @Override
    public void clearLookupJoinCaches() throws ServiceNotFoundException {
        LOG.info("clearLookupJoinCaches");
        for (ReplicationJob replicationJob : this.replicationManagerTracker.getService().getJobs()) {
            replicationJob.getLookupJoins().clearCaches();
        }
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                logServiceModuleInstance.getLookupJoins().clearCaches();
            }
        }
        catch (ModuleNotFoundException ex) {
            LOG.warning("Failed to clear the lookup join caches of the '" + LogServiceModule.class.getSimpleName() + "'. The module is not loaded at the moment.");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void refreshAllLookupJoins() throws InterruptedException, LookupJoinsException, ServiceNotFoundException, ElasticsearchRelatedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void refreshLookupJoinsOfReplicationJob(String replicationJobId) throws InterruptedException, ReplicationJobNotFoundException, ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("refreshLookupJoinsOfReplicationJob replicationJobId:" + replicationJobId);
        ReplicationJob replicationJob = this.replicationManagerTracker.getService().getReplicationJobById(replicationJobId);
        LookupJoinUpdaterData updaterData = new LookupJoinUpdaterData(replicationJob.getTarget().getIndex(), replicationJob.getLookupJoins(), replicationJob.getLookupJoins().getKeyFields());
        this.refreshLookupJoins(updaterData);
    }

    @Override
    public void refreshLookupJoinsOfLogService(String logServiceId) throws InterruptedException, ModuleNotFoundException, ModuleInstanceNotFoundException, LookupJoinsException, ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("refreshLookupJoinsOfLogService logServiceId:" + logServiceId);
        LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class).getModuleInstanceById(logServiceId);
        if (!logServiceModuleInstance.isElasticsearchLoggingEnabled()) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_ELASTICSEARCH_LOGGING_DISABLED, "Lookup joins refresh failed. The Log Service with the ID '${logServiceId}' does not use Elasticsearch logging.", MapUtil.mapOf("logServiceId", logServiceId));
        }
        LookupJoins lookupJoins = logServiceModuleInstance.getLookupJoins();
        if (!lookupJoins.hasEntries()) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_SETTING_INVALID, "Lookup joins refresh failed. The Log Service with the ID '${logServiceId}' has no lookup joins.", MapUtil.mapOf("logServiceId", logServiceId));
        }
        try {
            LogServiceModuleInstance.Es esSettings = logServiceModuleInstance.getEsSettings();
            if (esSettings.parent != null) {
                LookupJoinUpdaterData parentUpdaterData = new LookupJoinUpdaterData(esSettings.parent.index, lookupJoins, lookupJoins.getKeyFields());
                this.refreshLookupJoins(parentUpdaterData);
            }
            if (esSettings.child != null) {
                LookupJoinUpdaterData childUpdaterData = new LookupJoinUpdaterData(esSettings.child.index, lookupJoins, lookupJoins.getKeyFields());
                this.refreshLookupJoins(childUpdaterData);
            }
        }
        catch (LogServiceSettingsException ex) {
            throw new LookupJoinsException((ErrorCode)CoreErrorCode.LOOKUP_JOIN_SETTING_INVALID, "Lookup joins refresh failed. The Elasticsearch settings of the Log Service with the ID '${instanceId}' are invalid.", MapUtil.mapOf("instanceId", logServiceId), (Throwable)ex);
        }
    }

    private void addDynamicTemplatesMapping(ElasticsearchService es, String esIndex) {
        LOG.info("addDynamicTemplatesMapping es=..., esIndex=" + esIndex);
        Map<String, Object> currentMapping = es.getMapping(esIndex);
        if (!es.hasDynamicTemplatesMapping(currentMapping)) {
            try {
                List defaultDynamicTemplates = es.getDefaultDynamicTemplates();
                XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().prettyPrint();
                mappingBuilder.startObject();
                XContentBuilderUtil.addExistingMapping(mappingBuilder, currentMapping);
                XContentBuilderUtil.addDynamicTemplatesMapping(mappingBuilder, defaultDynamicTemplates);
                mappingBuilder.endObject();
                this.doIndexMappingUpdate(es, esIndex, mappingBuilder);
            }
            catch (ElasticsearchRelatedException | IOException ex) {
                LOG.log(Level.SEVERE, "Could not create the dynamic template mapping of the index '" + esIndex + "'", ex);
            }
        }
    }

    private void doIndexMappingUpdate(ElasticsearchService es, String esIndex, XContentBuilder mappingBuilder) throws ElasticsearchRelatedException {
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(esIndex).source(mappingBuilder);
            es.getClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public void refreshLookupJoins(LookupJoinUpdaterData updaterData) throws InterruptedException, ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("refreshLookupJoins updaterData:" + updaterData);
        if (updaterData == null) {
            LOG.info("Nothing to do");
            return;
        }
        String esIndex = updaterData.getEsIndex();
        LookupJoins lookupJoins = updaterData.getLookupJoins();
        Set<String> keyFields = updaterData.getKeyFields();
        if (keyFields == null || keyFields.isEmpty()) {
            LOG.info("Nothing to do");
            return;
        }
        lookupJoins.clearCaches(keyFields);
        try {
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            RestHighLevelClient esClient = es.getClient();
            this.addDynamicTemplatesMapping(es, esIndex);
            SearchRequest searchReq = new SearchRequest().indices(esIndex).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery())).scroll(new TimeValue(60000L));
            SearchResponse searchResponse = esClient.search(searchReq, RequestOptions.DEFAULT);
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            do {
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    Map<String, Object> sourceValues = hit.getSourceAsMap();
                    boolean documentUpdateNecessary = false;
                    for (String keyField : keyFields) {
                        LOG.finest("Processing key field: " + keyField);
                        LookupJoin lookupJoin = lookupJoins.getLookupJoinByKeyField(keyField);
                        Map<String, Object> oldLookupValues = MapUtil.getEntriesWithKeyPrefix(sourceValues, lookupJoin.getResultFieldsPrefix());
                        if (sourceValues.containsKey(keyField)) {
                            Object columnValue = sourceValues.get(keyField);
                            Map<String, Object> newLookupValues = lookupJoin.getAlreadyPrefixedLookupData(es, columnValue);
                            LOG.finest("oldLookupValues: " + oldLookupValues);
                            LOG.finest("newLookupValues: " + newLookupValues);
                            if (!oldLookupValues.equals(newLookupValues)) {
                                LOG.finest("new and old lookup values are different, must be updated");
                                documentUpdateNecessary = true;
                                for (String oldKeyField : oldLookupValues.keySet()) {
                                    sourceValues.remove(oldKeyField);
                                }
                                sourceValues.putAll(newLookupValues);
                                continue;
                            }
                            LOG.finest("Great, the old and new lookup values are identical");
                            continue;
                        }
                        LOG.finest("Did not find old lookup values");
                        for (String oldKeyField : oldLookupValues.keySet()) {
                            if (sourceValues.remove(oldKeyField) == null) continue;
                            documentUpdateNecessary = true;
                        }
                    }
                    if (documentUpdateNecessary) {
                        LOG.finest("The document must be updated: " + hit);
                        bulkRequest.add(((IndexRequest)new IndexRequest().index(esIndex)).id(hit.getId()).source(sourceValues, XContentType.JSON));
                    } else {
                        LOG.finest("Nothing to do, the document is already up to date: " + hit);
                    }
                    if (bulkRequest.numberOfActions() <= 250) continue;
                    BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                    LOG.info("Refreshed lookup joins indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
                    bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                }
            } while ((searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            es.releaseScrollId(searchResponse);
            if (bulkRequest.numberOfActions() > 0) {
                BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                LOG.info("Refreshed lookup joins indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public void registerForElasticsearchChanges() throws ServiceNotFoundException {
        LOG.info("registerForElasticsearchChanges");
        Filters filtersToRegister = new Filters();
        for (ReplicationJob job : this.replicationManagerTracker.getService().getJobs()) {
            if (!job.getLookupJoins().hasEntries()) continue;
            for (LookupJoin lookupJoin : job.getLookupJoins().getEntries()) {
                Filter filterToRegister = new Filter(lookupJoin.getLookupIndex(), true);
                filtersToRegister.addFilter(filterToRegister);
            }
        }
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                LookupJoins lookupJoins;
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                if (!logServiceModuleInstance.isElasticsearchLoggingEnabled() || !(lookupJoins = logServiceModuleInstance.getLookupJoins()).hasEntries()) continue;
                for (LookupJoin lookupJoin : lookupJoins.getEntries()) {
                    Filter filterToRegister = new Filter(lookupJoin.getLookupIndex(), true);
                    filtersToRegister.addFilter(filterToRegister);
                }
            }
        }
        catch (ModuleNotFoundException ex) {
            LOG.warning("Failed to register the used '" + LogServiceModule.class.getSimpleName() + "' indices for Elasticsearch changes. The module is not loaded at the moment. Gets registered when loaded.");
        }
        LOG.info("Filters to register: " + filtersToRegister);
        this.elasticsearchBpcPluginManagerTracker.getService().registerFilters(filtersToRegister);
    }

    @Override
    public void handleElasticsearchBpcPluginIndexOperation(IndexOperation indexOperation) throws ServiceNotFoundException {
        LOG.fine("handleElasticsearchBpcPluginIndexOperation indexOperation=" + indexOperation);
        this.initializeExecutor();
        Set<String> indexAndAliasNames = indexOperation.getIndexAndAliasNames();
        ArrayList<LookupJoinUpdaterData> updaterDatas = new ArrayList<LookupJoinUpdaterData>();
        for (ReplicationJob replicationJob : this.replicationManagerTracker.getService().getJobs()) {
            List<LookupJoin> relatedLookupJoinEntries;
            LookupJoins lookupJoins = replicationJob.getLookupJoins();
            if (lookupJoins == null || !lookupJoins.hasEntries() || (relatedLookupJoinEntries = lookupJoins.getLookupJoinsByLookupIndex(indexAndAliasNames)) == null || relatedLookupJoinEntries.isEmpty()) continue;
            LookupJoinUpdaterData updaterData = new LookupJoinUpdaterData(replicationJob.getTarget().getIndex(), lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
            updaterDatas.add(updaterData);
        }
        try {
            LogServiceModule logServiceModule = this.moduleManagerTracker.getService().getModuleByClass(LogServiceModule.class);
            for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                List<LookupJoin> relatedLookupJoinEntries;
                LookupJoins lookupJoins;
                LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                if (!logServiceModuleInstance.isElasticsearchLoggingEnabled() || !(lookupJoins = logServiceModuleInstance.getLookupJoins()).hasEntries() || (relatedLookupJoinEntries = lookupJoins.getLookupJoinsByLookupIndex(indexAndAliasNames)) == null || relatedLookupJoinEntries.isEmpty()) continue;
                try {
                    LogServiceModuleInstance.Es esSettings = logServiceModuleInstance.getEsSettings();
                    boolean childProcessingEnabled = esSettings.child != null;
                    LookupJoinUpdaterData parentUpdaterData = new LookupJoinUpdaterData(esSettings.parent.index, lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
                    updaterDatas.add(parentUpdaterData);
                    if (!childProcessingEnabled) continue;
                    LookupJoinUpdaterData childUpdaterData = new LookupJoinUpdaterData(esSettings.child.index, lookupJoins, LookupJoins.getKeyFields(relatedLookupJoinEntries));
                    updaterDatas.add(childUpdaterData);
                }
                catch (LogServiceSettingsException e) {
                    LOG.log(Level.SEVERE, "Could not get the Elasticsearch settings.", e);
                }
            }
        }
        catch (ModuleNotFoundException ex) {
            LOG.warning("Skipping '" + LogServiceModule.class.getSimpleName() + "' indices related events until the module is loaded.");
        }
        for (LookupJoinUpdaterData lookupJoinUpdaterData : updaterDatas) {
            LOG.info("Loookup joins to refresh: " + lookupJoinUpdaterData);
            Future<Boolean> lookupJoinUpdaterFuture = this.lookupJoinsUpdates.get(lookupJoinUpdaterData.getEsIndex());
            if (lookupJoinUpdaterFuture != null && !lookupJoinUpdaterFuture.isDone()) {
                lookupJoinUpdaterFuture.cancel(true);
            }
            Future<Boolean> futureUpdate = this.executorService.submit(new LookupJoinsUpdater(this, lookupJoinUpdaterData));
            this.lookupJoinsUpdates.put(lookupJoinUpdaterData.getEsIndex(), futureUpdate);
        }
    }

    private class LogServiceModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private LogServiceModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            try {
                LookupJoinsManagerImpl.this.registerForElasticsearchChanges();
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Failed to register for Elasticsearch changes.", ex);
            }
        }
    }
}

