/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationException;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.NotificationPersistenceHandler;
import de.virtimo.bpc.core.notification.Notifications;
import de.virtimo.bpc.util.DictionaryUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class NotificationManagerImpl
implements NotificationManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(NotificationManagerImpl.class.getName());
    private static final Object NOTIFICATION_INDEX_LOCK = new Object();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;

    public NotificationManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.coreBundleServiceTracker = new BpcServicesTracker<CoreBundleService>(bundleContext, CoreBundleService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification addNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, ElasticsearchRelatedException {
        LOG.info("addNotification notification=" + notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(es);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification createdNotification = persistenceHandler.saveNotification(notification);
            this.fireNotificationAddedEvent(createdNotification);
            return createdNotification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification updateNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, ElasticsearchRelatedException {
        LOG.info("updateNotification notification=" + notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(es);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification existingNotification = persistenceHandler.loadNotification(notification.getId());
            Notification updatedNotification = persistenceHandler.saveNotification(notification);
            this.fireNotificationUpdatedEvent(existingNotification, updatedNotification);
            return updatedNotification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification deleteNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, ElasticsearchRelatedException {
        LOG.info("deleteNotification notification=" + notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(es);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            persistenceHandler.deleteNotification(notification.getId());
            this.fireNotificationDeletedEvent(notification);
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification deleteNotificationById(String notificationId) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, ElasticsearchRelatedException {
        LOG.info("deleteNotificationById notificationId=" + notificationId);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(es);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification notification = persistenceHandler.loadNotification(notificationId);
            persistenceHandler.deleteNotification(notification.getId());
            this.fireNotificationDeletedEvent(notification);
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification getNotification(String notificationId) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, ElasticsearchRelatedException {
        LOG.info("getNotification notificationId=" + notificationId);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(es);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            return persistenceHandler.loadNotification(notificationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notifications getNotifications(UserSession userSession, Integer start, Integer limit) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, ElasticsearchRelatedException {
        LOG.info("getNotifications userSession=" + userSession + ", start=" + start + ", limit=" + limit);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(es);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            return persistenceHandler.loadNotifications(start, limit, userSession.getLoginName(), userSession.getRoles(), userSession.getOrganisations());
        }
    }

    private void fireNotificationAddedEvent(Notification notification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationAdded", DictionaryUtil.dictionaryOf("notification", notification));
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.WARNING, "Failed to send the notification added event.", ex);
        }
    }

    private void fireNotificationUpdatedEvent(Notification oldNotification, Notification newNotification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationUpdated", DictionaryUtil.dictionaryOf("notification", newNotification));
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.WARNING, "Failed to send the notification updated event.", ex);
        }
    }

    private void fireNotificationDeletedEvent(Notification notification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationDeleted", DictionaryUtil.dictionaryOf("notification", notification));
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.WARNING, "Failed to send the notification deleted event.", ex);
        }
    }
}

