/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.es.BpcIndexCreateCallable;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationData;
import de.virtimo.bpc.core.notification.NotificationException;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.Notifications;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class NotificationPersistenceHandler {
    private static final Logger LOG = Logger.getLogger(NotificationPersistenceHandler.class.getName());
    public static final String NOTIFICATION_INDEX_ALIAS_NAME = "bpc-notification";
    private final ElasticsearchService es;

    public NotificationPersistenceHandler(ElasticsearchService es) {
        this.es = es;
    }

    public void createBpcNotificationIndexIfMissing() throws NotificationException {
        LOG.fine("createBpcNotificationIndexIfMissing");
        try {
            BpcIndexState bpcNotificationIndexState = this.es.getIndexState(NOTIFICATION_INDEX_ALIAS_NAME);
            bpcNotificationIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return es.getManagedIndicesHandler().createManagedIndex(NotificationPersistenceHandler.NOTIFICATION_INDEX_ALIAS_NAME);
                }
            });
        }
        catch (Exception ex) {
            throw new NotificationException((ErrorCode)CoreErrorCode.NOTIFICATION_FAILED, "Failed to prepare the notification index '${index}'.", MapUtil.mapOf("index", NOTIFICATION_INDEX_ALIAS_NAME), (Throwable)ex);
        }
    }

    public void deleteNotification(String notificationId) throws NotificationNotFoundException, ElasticsearchRelatedException {
        LOG.info("deleteNotification notificationId=" + notificationId);
        try {
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(NOTIFICATION_INDEX_ALIAS_NAME)).id(notificationId);
            DeleteResponse response = this.es.getClient().delete(deleteRequest, RequestOptions.DEFAULT);
            if (response == null || response.status() == RestStatus.NOT_FOUND) {
                throw new NotificationNotFoundException(notificationId);
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public Notification loadNotification(String notificationId) throws NotificationNotFoundException, ElasticsearchRelatedException {
        LOG.info("loadNotification notificationId=" + notificationId);
        try {
            GetRequest getRequest = ((GetRequest)new GetRequest().index(NOTIFICATION_INDEX_ALIAS_NAME)).id(notificationId);
            GetResponse response = this.es.getClient().get(getRequest, RequestOptions.DEFAULT);
            if (response == null || !response.isExists()) {
                throw new NotificationNotFoundException(notificationId);
            }
            return this.createNotificationFromElasticsearchSource(response.getVersion(), response.getSourceAsString());
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public Notification saveNotification(Notification notification) throws ElasticsearchRelatedException {
        LOG.info("saveNotification notification=...");
        try {
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(NOTIFICATION_INDEX_ALIAS_NAME)).id(notification.getId()).source(JsonUtil.getInstance().convertPojoToJsonString(notification), XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            IndexResponse response = this.es.getClient().index(indexRequest, RequestOptions.DEFAULT);
            return new Notification.Builder(notification).version(response.getVersion()).build();
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public Notifications loadNotifications(Integer start, Integer limit, String userName, List<Role> roles, List<Organisation> organisations) throws ElasticsearchRelatedException {
        LOG.info("loadNotifications start=" + start + ", limit=" + limit + ", userName=" + userName + ", roles=" + roles + ", organisations=" + organisations);
        try {
            RestHighLevelClient esClient = this.es.getClient();
            SearchRequest searchRequest = new SearchRequest().indices(NOTIFICATION_INDEX_ALIAS_NAME).source(new SearchSourceBuilder().from(start).size(limit).version(true).query(this.getQuery(userName, roles, organisations)).sort("date", SortOrder.DESC));
            SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            Notifications notifications = new Notifications(start, limit);
            notifications.setTotalCountFromSource(searchResponse.getHits().getTotalHits().value);
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                String notificationId = hit.getId();
                try {
                    notifications.addData(this.createNotificationFromElasticsearchSource(hit.getVersion(), hit.getSourceAsString()));
                }
                catch (Exception ex) {
                    LOG.warning("Could not create a Notification object from a Elasticsearch response hit. Please fix the notification with the ID '" + notificationId + "' in the index 'bpc-notification'.");
                    notifications.addAsIdWithError(notificationId);
                }
            }
            return notifications;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private QueryBuilder getQuery(String userName, List<Role> roles, List<Organisation> organisations) {
        BoolQueryBuilder qb = QueryBuilders.boolQuery();
        if (!StringUtil.isNullOrEmpty(userName)) {
            qb.should(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("recipientsType", "user")).must(QueryBuilders.termQuery("recipients", userName)));
        }
        if (roles != null && !roles.isEmpty()) {
            BoolQueryBuilder oneOfTheRolesQuery = QueryBuilders.boolQuery();
            for (Role role : roles) {
                oneOfTheRolesQuery.should(QueryBuilders.termQuery("recipients", role.getName()));
            }
            qb.should(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("recipientsType", "role")).must(oneOfTheRolesQuery));
        }
        if (organisations != null && !organisations.isEmpty()) {
            BoolQueryBuilder oneOfTheOrganisationsQuery = QueryBuilders.boolQuery();
            for (Organisation organisation : organisations) {
                oneOfTheOrganisationsQuery.should(QueryBuilders.termQuery("recipients", organisation.getName()));
            }
            qb.should(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("recipientsType", "organisation")).must(oneOfTheOrganisationsQuery));
        }
        return qb;
    }

    private Notification createNotificationFromElasticsearchSource(long version, String sourceAsString) throws IOException {
        NotificationData esData = JsonUtil.getInstance().convertJsonStringToPojo(sourceAsString, NotificationData.class);
        return new Notification.Builder(esData).version(version).build();
    }
}

