/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.response.ConnectedServers;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class PercolatorsChecker
implements Checker {
    private static final Logger LOG = Logger.getLogger(PercolatorsChecker.class.getName());
    private static final String INTERVAL_IN_MINUTES_PROPERTY_NAME = "de.virtimo.bpc.core.percolatorschecker.intervalInMinutes";
    private static final long INTERVAL_IN_MINUTES_PROPERTY_DEFAULT = 60L;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerTracker;

    public PercolatorsChecker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void startChecker() {
        LOG.info("startChecker");
        if (this.checkerHandle != null) {
            LOG.warning("Percolators checker is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(this.bundleContext, ElasticsearchService.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(this.bundleContext, PercolatorsManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.elasticsearchBpcPluginManagerTracker = new BpcServicesTracker<ElasticsearchBpcPluginManager>(this.bundleContext, ElasticsearchBpcPluginManager.class);
        try {
            long checkInterval = this.coreBundleConfigurationTracker.getService().getSystemPropertyValueAsLong(INTERVAL_IN_MINUTES_PROPERTY_NAME, 60L);
            LOG.info("Init PercolatorsChecker with interval: every " + checkInterval + " minutes");
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-percolators-checker"));
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), checkInterval, checkInterval, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to start the percolators checker.", ex);
        }
    }

    @Override
    public void stopChecker() {
        LOG.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOG.info("Running percolators checker cancelled");
            } else {
                LOG.warning("Could not cancel the running percolators checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
    }

    private Runnable createCheckerRunnable() {
        LOG.info("createCheckerRunnable");
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.info("Check for outdated percolators: START");
                long sessionCheckStartTime = System.currentTimeMillis();
                try {
                    ElasticsearchService es = PercolatorsChecker.this.elasticsearchServiceTracker.getService();
                    PercolatorsManager percolatorsManager = PercolatorsChecker.this.percolatorsManagerTracker.getService();
                    ReplicationManager replicationManager = PercolatorsChecker.this.replicationManagerTracker.getService();
                    ClientSessionManager clientSessionManager = PercolatorsChecker.this.clientSessionManagerTracker.getService();
                    CoreBundleConfiguration coreBundleConfiguration = PercolatorsChecker.this.coreBundleConfigurationTracker.getService();
                    ElasticsearchBpcPluginManager elasticsearchBpcPluginManager = PercolatorsChecker.this.elasticsearchBpcPluginManagerTracker.getService();
                    String thisServerUUID = coreBundleConfiguration.getServerUUID();
                    LOG.info("thisServerUUID = " + thisServerUUID);
                    Set<String> percolatorRelatedIndexNames = percolatorsManager.getPercolatorRelatedIndexNames();
                    if (!percolatorRelatedIndexNames.isEmpty()) {
                        Set<Percolator> percolators = percolatorsManager.getPercolatorsFromIndices(es, percolatorRelatedIndexNames);
                        ConnectedServers connectedServers = replicationManager.isReplicationEnabled() ? elasticsearchBpcPluginManager.getConnectedServers() : null;
                        LOG.info("connectedServers: " + connectedServers);
                        HashSet<Percolator> percolatorsToDelete = new HashSet<Percolator>();
                        for (Percolator percolator : percolators) {
                            if (!percolator.isValid()) {
                                LOG.info("DELETE invalid percolator: " + percolator);
                                percolatorsToDelete.add(percolator);
                                continue;
                            }
                            if (thisServerUUID.equals(percolator.getServerUUID())) {
                                if (clientSessionManager.existsSession(percolator.getSessionId())) continue;
                                LOG.info("DELETE percolator without valid session: " + percolator);
                                percolatorsToDelete.add(percolator);
                                continue;
                            }
                            if (connectedServers == null || connectedServers.isConnectedServerUUID(percolator.getServerUUID())) continue;
                            LOG.info("DELETE percolator without registered server UUID: " + percolator);
                            percolatorsToDelete.add(percolator);
                        }
                        if (!percolatorsToDelete.isEmpty()) {
                            percolatorsManager.deletePercolators(es, percolatorsToDelete);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Failed to perform the check for outdated percolators.", t);
                }
                finally {
                    LOG.info("Check for outdated percolators: STOP (" + (System.currentTimeMillis() - sessionCheckStartTime) + " ms)");
                }
            }
        };
    }
}

