/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.percolators.PercolatorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

class PercolatorsElasticsearchHandler {
    private static final Logger LOG = Logger.getLogger(PercolatorsElasticsearchHandler.class.getName());
    private final ElasticsearchService es;

    PercolatorsElasticsearchHandler(ElasticsearchService es) {
        this.es = es;
    }

    boolean registerPercolator(Percolator percolator, QueryBuilder esQueryBuilder) {
        LOG.info("registerPercolator percolator=" + percolator + ", esQueryBuilder=" + esQueryBuilder);
        try {
            if (!this.es.existsIndex(percolator.getIndex())) {
                LOG.info("Must not register the percolator query, because the related index '" + percolator.getIndex() + "' does not exist.");
                return false;
            }
            Map<String, String> currentFieldTypeMapping = this.es.getFieldsTypeMapping(percolator.getIndex());
            if (!currentFieldTypeMapping.containsKey("_percolator_query") || !"percolator".equalsIgnoreCase(currentFieldTypeMapping.get("_percolator_query"))) {
                LOG.severe("Could not register the percolator query, because the mapping of the percolator type field '_percolator_query' is missing or is not of type 'percolator' in the related index '" + percolator.getIndex() + "'.");
                return false;
            }
            IndexRequest req = (IndexRequest)((IndexRequest)new IndexRequest().index(percolator.getIndex())).id(percolator.getUID()).source(XContentFactory.jsonBuilder().startObject().field("_percolator_query", esQueryBuilder).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            IndexResponse indexResponse = this.es.getClient().index(req, RequestOptions.DEFAULT);
            LOG.info("indexResponse:" + indexResponse);
            return true;
        }
        catch (IOException | ElasticsearchException ex) {
            LOG.log(Level.SEVERE, "Failed to create/update the percolator query of index '" + percolator.getIndex() + "' due to an Elasticsearch error.", ex);
            return false;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create/update the percolator query of index '" + percolator.getIndex() + "'.", ex);
            return false;
        }
    }

    Set<Percolator> getPercolatorsFromIndex(String index) {
        LOG.info("getPercolatorsFromIndex index=" + index);
        HashSet<Percolator> result = new HashSet<Percolator>();
        try {
            RestHighLevelClient esClient = this.es.getClient();
            SearchResponse searchResponse = esClient.search(new SearchRequest().indices(index).source(new SearchSourceBuilder().size(100).query(QueryBuilders.existsQuery("_percolator_query"))).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            while (hits != null && hits.length > 0) {
                for (SearchHit hit : hits) {
                    String indexName = hit.getIndex();
                    String indexAliasName = this.es.aliasFromBpcIndexName(indexName);
                    String percolatorUID = hit.getId();
                    result.add(new PercolatorImpl(indexAliasName != null ? indexAliasName : indexName, percolatorUID));
                }
                searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT);
                hits = searchResponse.getHits().getHits();
            }
            this.es.releaseScrollId(searchResponse);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOG.warning("Evaluate percolator IDs ... the Elasticsearch index does not exist: " + index);
            } else {
                LOG.log(Level.SEVERE, "Unhandled exception in PercolatorsManagerImpl.getPercolatorsFromIndex(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Evaluate percolator IDs .... failed to get the percolator of the index: " + index, ex);
        }
        return result;
    }

    void deletePercolators(Set<Percolator> percolatorsToDelete) throws ElasticsearchRelatedException {
        LOG.info("deletePercolators percolatorsToDelete=" + percolatorsToDelete);
        if (percolatorsToDelete == null || percolatorsToDelete.isEmpty()) {
            return;
        }
        try {
            RestHighLevelClient esClient = this.es.getClient();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Percolator percolatorToDelete : percolatorsToDelete) {
                bulkRequest.add(((DeleteRequest)new DeleteRequest().index(percolatorToDelete.getIndex())).id(percolatorToDelete.getUID()));
            }
            BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            LOG.info("Percolators deleted: " + bulkRequest.numberOfActions() + ", with failures: " + bulkResponse.hasFailures());
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    List<Object> getContentOfNewOrUpdatedDatabaseIDs(String index, Set<String> newOrUpdatedDatabaseIDs) throws IOException {
        LOG.info("getContentOfNewOrUpdatedDatabaseIDs index=" + index + ", newOrUpdatedDatabaseIDs=...");
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (newOrUpdatedDatabaseIDs != null && !newOrUpdatedDatabaseIDs.isEmpty()) {
            MultiGetRequest req = new MultiGetRequest().refresh(true);
            for (String databaseID : newOrUpdatedDatabaseIDs) {
                req.add(index, databaseID);
            }
            MultiGetResponse multiGetResponse = this.es.getClient().mget(req, RequestOptions.DEFAULT);
            for (MultiGetItemResponse response : multiGetResponse.getResponses()) {
                dataList.add(response.getResponse().getSource());
            }
        }
        return dataList;
    }
}

