/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorRelatedDatabaseIDs;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.PercolatorsProcessor;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.percolators.PercolatorImpl;
import de.virtimo.bpc.core.percolators.PercolatorsElasticsearchHandler;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.utils.EventUtil;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.SetUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class PercolatorsManagerImpl
implements PercolatorsManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(PercolatorsManagerImpl.class.getName());
    private final BundleContext bundleContext;
    private String serverUUID;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final EventRegistration eventRegistration;

    public PercolatorsManagerImpl(BundleContext bundleContext, String serverUUID) {
        this.bundleContext = bundleContext;
        this.serverUUID = serverUUID;
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forServerUuidUpdatedEvents(new ServerUuidUpdatedEventHandler());
        this.eventRegistration.forUserSessionRemovedEvents(new UserSessionRemovedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerPercolator(String sessionId, String componentId, String customId, ElasticsearchService es, String esIndex, QueryBuilder esQueryBuilder) {
        LOG.info("registerPercolator sessionId=" + sessionId + ", componentId=" + componentId + ", customId=" + customId + ", es=..., esIndex=" + esIndex + ", esQueryBuilder=...");
        long startTimeCreatePercolator = System.currentTimeMillis();
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            if (sessionId == null || !clientSessionManager.existsSession(sessionId)) {
                LOG.warning("Could not create/update percolator due to unknown session id: " + sessionId);
                boolean bl = false;
                return bl;
            }
            PercolatorImpl percolator = new PercolatorImpl(esIndex, this.serverUUID, sessionId, componentId, customId);
            LOG.info("percolator: " + percolator);
            PercolatorsElasticsearchHandler esHandler = new PercolatorsElasticsearchHandler(es);
            boolean bl = esHandler.registerPercolator(percolator, esQueryBuilder);
            return bl;
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to register the query as a percolator.", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            LOG.info("Time to create/update the percolator: " + (System.currentTimeMillis() - startTimeCreatePercolator) + " ms");
        }
    }

    @Override
    public void informClientsAboutReplicatedData(ElasticsearchService es, String esIndex, PercolatorsProcessor percolatorsProcessor) throws ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("informClientsAboutReplicatedData es=..., esIndex=" + esIndex + ", percolatorsProcessor=...");
        if (es == null || percolatorsProcessor == null) {
            return;
        }
        es.refreshIndices(esIndex);
        if (percolatorsProcessor.hasReceivedTooManyDatabaseIDsToGetThePercolatorsFor()) {
            try {
                Event event = new Event("de/virtimo/bpc/core/ReplicationService/dataLoaded", DictionaryUtil.dictionaryOf("esIndex", esIndex, "dataCount", percolatorsProcessor.getNumberOfDatabaseIDs()));
                this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin-send-percolator-hit-message", DictionaryUtil.dictionaryOf("sessionId", "ALL", "jsonMsg", EventUtil.eventAsJsonString(event)));
            }
            catch (JsonProcessingException ex) {
                LOG.log(Level.SEVERE, "Could not send the monitor/replication data by websocket.", ex);
            }
        } else {
            Map<Percolator, PercolatorRelatedDatabaseIDs> percolatorsAndTheirRelatedDatabaseIDs = percolatorsProcessor.getPercolatorsAndTheirRelatedDatabaseIDs();
            Set<String> allUpdatedDatabaseIDs = percolatorsProcessor.getUpdatedDatabaseIDs();
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            for (Percolator existingPercolator : percolatorsProcessor.getAllPercolators()) {
                Set<String> deletedDatabaseIDs;
                Set<String> newOrUpdatedDatabaseIDs;
                String percolatorServerUUID = existingPercolator.getServerUUID();
                String percolatorSessionId = existingPercolator.getSessionId();
                String percolatorComponentId = existingPercolator.getComponentId();
                String percolatorCustomId = existingPercolator.getCustomId();
                if (this.serverUUID.equals(percolatorServerUUID) && !clientSessionManager.existsSession(percolatorSessionId)) {
                    this.deletePercolators(es, esIndex, percolatorSessionId);
                    continue;
                }
                HashSet<String> obsoleteDatabaseIDs = new HashSet<String>();
                if (percolatorsAndTheirRelatedDatabaseIDs != null && percolatorsAndTheirRelatedDatabaseIDs.containsKey(existingPercolator)) {
                    PercolatorRelatedDatabaseIDs percolatorRelatedDatabaseIDs = percolatorsAndTheirRelatedDatabaseIDs.get(existingPercolator);
                    newOrUpdatedDatabaseIDs = percolatorRelatedDatabaseIDs.getNewOrUpdatedDatabaseIDs();
                    for (String updatedDatabaseID : allUpdatedDatabaseIDs) {
                        if (newOrUpdatedDatabaseIDs.contains(updatedDatabaseID)) continue;
                        obsoleteDatabaseIDs.add(updatedDatabaseID);
                    }
                    deletedDatabaseIDs = percolatorRelatedDatabaseIDs.getDeletedDatabaseIDs();
                } else {
                    newOrUpdatedDatabaseIDs = null;
                    obsoleteDatabaseIDs.addAll(allUpdatedDatabaseIDs);
                    deletedDatabaseIDs = null;
                }
                if (!(newOrUpdatedDatabaseIDs != null && !newOrUpdatedDatabaseIDs.isEmpty() || obsoleteDatabaseIDs != null && !obsoleteDatabaseIDs.isEmpty() || deletedDatabaseIDs != null && !deletedDatabaseIDs.isEmpty())) {
                    LOG.info("No replicated data to send to the clients by websocket!");
                    continue;
                }
                this.sendReplicatedDataByWebsocket(es, esIndex, newOrUpdatedDatabaseIDs, obsoleteDatabaseIDs, deletedDatabaseIDs, percolatorServerUUID, percolatorSessionId, percolatorComponentId, percolatorCustomId);
            }
        }
    }

    @Override
    public void informClientsAboutReplicatedData(ElasticsearchService es, String esIndex, BulkResponse bulkResponse) throws ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("informClientsAboutReplicatedData es=..., esIndex=" + esIndex + ", bulkResponse=...");
        if (bulkResponse != null) {
            Set<Percolator> percolatorsFromIndex = this.getAllValidPercolatorsFromIndex(es, esIndex);
            PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(es, esIndex, percolatorsFromIndex);
            percolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
            percolatorsProcessor.process();
            this.informClientsAboutReplicatedData(es, esIndex, percolatorsProcessor);
        }
    }

    @Override
    public void informClientsAboutDeletedData(ElasticsearchService es, String esIndex, Set<String> deletedIDs) throws ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("informClientsAboutDeletedData es=..., esIndex=" + esIndex + ", deletedIDs=...");
        if (deletedIDs != null && !deletedIDs.isEmpty()) {
            Set<Percolator> percolatorsFromIndex = this.getAllValidPercolatorsFromIndex(es, esIndex);
            PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(es, esIndex, percolatorsFromIndex);
            percolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            percolatorsProcessor.keepDeletedDatabaseIDs(deletedIDs);
            percolatorsProcessor.processForDeleted();
            this.informClientsAboutReplicatedData(es, esIndex, percolatorsProcessor);
        }
    }

    private void sendReplicatedDataByWebsocket(ElasticsearchService es, String esIndex, Set<String> newOrUpdatedDatabaseIDs, Set<String> obsoleteDatabaseIDs, Set<String> deletedDatabaseIDs, String serverUUID, String sessionId, String componentId, String customId) {
        LOG.info("sendReplicatedDataByWebsocket es=..., esIndex=" + esIndex + ", newOrUpdatedDatabaseIDs=..., obsoleteDatabaseIDs=..., deletedDatabaseIDs=..., serverUUID=" + serverUUID + ", sessionId=" + sessionId + ", componentId=" + componentId + ", customId=" + customId);
        try {
            PercolatorsElasticsearchHandler esHandler = new PercolatorsElasticsearchHandler(es);
            List<Object> dataList = esHandler.getContentOfNewOrUpdatedDatabaseIDs(esIndex, newOrUpdatedDatabaseIDs);
            Event event = new Event("de/virtimo/bpc/core/ReplicationService/dataLoaded", DictionaryUtil.dictionaryOf("componentId", componentId, "customId", customId, "dataCount", dataList.size(), "obsoleteIDs", obsoleteDatabaseIDs == null ? new HashSet() : obsoleteDatabaseIDs, "deletedIDs", deletedDatabaseIDs == null ? new HashSet() : deletedDatabaseIDs));
            this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin-send-percolator-hit-message", DictionaryUtil.dictionaryOf("serverUUID", serverUUID, "sessionId", sessionId, "jsonMsg", EventUtil.eventAsJsonString(event)));
        }
        catch (IOException | ElasticsearchException ex) {
            LOG.log(Level.SEVERE, "Failed to send the monitor/replication data by websocket due to an Elasticsearch error.", ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not send the monitor/replication data by websocket.", ex);
        }
    }

    @Override
    public Set<Percolator> getPercolatorsFromIndices(ElasticsearchService es, Set<String> indices) {
        LOG.info("getPercolatorsFromIndices es=..., indices=" + indices);
        HashSet<Percolator> result = new HashSet<Percolator>();
        if (indices != null) {
            PercolatorsElasticsearchHandler esHandler = new PercolatorsElasticsearchHandler(es);
            for (String index : indices) {
                result.addAll(esHandler.getPercolatorsFromIndex(index));
            }
        }
        return result;
    }

    @Override
    public Set<Percolator> getAllValidPercolatorsFromIndex(ElasticsearchService es, String esIndex) {
        LOG.info("getAllValidPercolatorsFromIndex esIndex:" + esIndex);
        HashSet<Percolator> result = new HashSet<Percolator>();
        Set<Percolator> percolatorsFromIndex = this.getPercolatorsFromIndices(es, SetUtil.setOf(esIndex));
        for (Percolator percolatorFromIndex : percolatorsFromIndex) {
            if (!percolatorFromIndex.isValid()) continue;
            result.add(percolatorFromIndex);
        }
        return result;
    }

    @Override
    public Set<String> getPercolatorRelatedIndexNames() throws ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("getPercolatorRelatedIndexNames");
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        return es.getAliasesOfAllIndices();
    }

    @Override
    public void deletePercolators(String sessionId) throws ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("deletePercolators sessionId=" + sessionId);
        if (sessionId == null) {
            return;
        }
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Set<String> indexNames = this.getPercolatorRelatedIndexNames();
        for (String indexName : indexNames) {
            this.deletePercolators(es, indexName, sessionId);
        }
    }

    private void deletePercolators(ElasticsearchService es, String esIndex, String sessionId) throws ElasticsearchRelatedException {
        LOG.info("deletePercolators es=..., esIndex=" + esIndex + ", sessionId=" + sessionId);
        if (es == null || esIndex == null || sessionId == null) {
            return;
        }
        Set<Percolator> percolators = this.getPercolatorsFromIndices(es, SetUtil.setOf(esIndex));
        HashSet<Percolator> toDelete = new HashSet<Percolator>();
        for (Percolator percolator : percolators) {
            if (!percolator.isValid() || !sessionId.equalsIgnoreCase(percolator.getSessionId())) continue;
            toDelete.add(percolator);
        }
        this.deletePercolators(es, toDelete);
    }

    @Override
    public void deletePercolators(ElasticsearchService es, Set<Percolator> percolatorsToDelete) throws ElasticsearchRelatedException {
        LOG.info("deletePercolators es=..., percolatorsToDelete=" + percolatorsToDelete);
        if (es == null || percolatorsToDelete == null || percolatorsToDelete.isEmpty()) {
            return;
        }
        PercolatorsElasticsearchHandler esHandler = new PercolatorsElasticsearchHandler(es);
        esHandler.deletePercolators(percolatorsToDelete);
    }

    private class ServerUuidUpdatedEventHandler
    extends AbstractEventHandler {
        private ServerUuidUpdatedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Object newServerUuidObject = event.getProperty("new");
            if (newServerUuidObject instanceof String) {
                PercolatorsManagerImpl.this.serverUUID = (String)newServerUuidObject;
            }
        }
    }

    private class UserSessionRemovedEventHandler
    extends AbstractEventHandler {
        private UserSessionRemovedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Object sessionIdObject = event.getProperty("SessionId");
            if (sessionIdObject instanceof String) {
                try {
                    PercolatorsManagerImpl.this.deletePercolators((String)sessionIdObject);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to delete the percolators of a session id.", ex);
                }
            }
        }
    }
}

