/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorRelatedDatabaseIDs;
import de.virtimo.bpc.api.PercolatorsProcessor;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.percolators.PercolatorImpl;
import de.virtimo.bpc.core.percolators.PercolatorRelatedDatabaseIDsImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;

public class PercolatorsProcessorImpl
implements PercolatorsProcessor {
    private static final Logger LOG = Logger.getLogger(PercolatorsProcessorImpl.class.getName());
    private static final long DEFAULT_MAX_NUMBER_OF_PROCESSABLE_DATABASE_IDS = 10000L;
    private final ElasticsearchService es;
    private final String esIndex;
    private final Set<String> realIndexNames;
    private final Set<Percolator> percolators;
    private List<String> databaseIDs;
    private long numberOfDatabaseIDs;
    private long maxNumberOfProcessableDatabaseIDs;
    private final Set<String> updatedDatabaseIDs;
    private final Map<Percolator, PercolatorRelatedDatabaseIDs> percolatorsAndTheirRelatedDatabaseIDs;
    private boolean alreadyProcessed;
    private final List<String> deletedDatabaseIDs;
    private boolean deletedAlreadyProcessed;

    public PercolatorsProcessorImpl(ElasticsearchService es, String esIndex, Set<Percolator> percolators) throws ElasticsearchRelatedException {
        this.es = es;
        this.esIndex = esIndex;
        this.realIndexNames = es.getIndexNamesWithAlias(esIndex);
        this.percolators = percolators;
        this.databaseIDs = new ArrayList<String>();
        this.numberOfDatabaseIDs = 0L;
        this.updatedDatabaseIDs = new HashSet<String>();
        this.maxNumberOfProcessableDatabaseIDs = 10000L;
        this.percolatorsAndTheirRelatedDatabaseIDs = new HashMap<Percolator, PercolatorRelatedDatabaseIDs>();
        this.alreadyProcessed = false;
        this.deletedDatabaseIDs = new ArrayList<String>();
        this.deletedAlreadyProcessed = false;
    }

    @Override
    public boolean existSomePercolators() {
        return !this.percolators.isEmpty();
    }

    @Override
    public boolean hasData() {
        return this.numberOfDatabaseIDs > 0L || this.deletedDatabaseIDs.size() > 0;
    }

    @Override
    public Set<Percolator> getAllPercolators() {
        return this.percolators;
    }

    @Override
    public void setMaxNumberOfProcessableDatabaseIDs(long maxNumberOfProcessableDatabaseIDs) {
        this.maxNumberOfProcessableDatabaseIDs = maxNumberOfProcessableDatabaseIDs;
    }

    @Override
    public Set<String> getUpdatedDatabaseIDs() {
        return this.updatedDatabaseIDs;
    }

    @Override
    public Set<String> getDeletedDatabaseIDs() {
        return new HashSet<String>(this.deletedDatabaseIDs);
    }

    @Override
    public long getNumberOfDatabaseIDs() {
        return this.numberOfDatabaseIDs;
    }

    @Override
    public boolean hasReceivedTooManyDatabaseIDsToGetThePercolatorsFor() {
        return this.numberOfDatabaseIDs > this.maxNumberOfProcessableDatabaseIDs;
    }

    @Override
    @NotNull
    public Map<Percolator, PercolatorRelatedDatabaseIDs> getPercolatorsAndTheirRelatedDatabaseIDs() {
        return this.percolatorsAndTheirRelatedDatabaseIDs;
    }

    @Override
    public void keepDeletedDatabaseIDs(Set<String> databaseIDs) {
        LOG.info("keepDeletedDatabaseIDs databaseIDs=" + databaseIDs);
        if (this.existSomePercolators() && databaseIDs != null) {
            this.deletedDatabaseIDs.addAll(databaseIDs);
        }
    }

    @Override
    public void keepDatabaseIDsFromBulkResponse(BulkResponse bulkResponse) {
        LOG.info("keepDatabaseIDsFromBulkResponse");
        if (this.existSomePercolators()) {
            for (BulkItemResponse bulkItemResponse : bulkResponse) {
                if (bulkItemResponse.isFailed()) continue;
                String index = bulkItemResponse.getIndex();
                String databaseId = bulkItemResponse.getId();
                if (!this.esIndex.equals(index) && !this.realIndexNames.contains(index)) continue;
                this.databaseIDs.add(databaseId);
                if (bulkItemResponse.getVersion() <= 1L) continue;
                this.updatedDatabaseIDs.add(databaseId);
            }
            this.numberOfDatabaseIDs = this.databaseIDs.size();
        }
    }

    private static QueryBuilder percolateQuery(String index, String field, String documentId) {
        return QueryBuilders.wrapperQuery("{\n  \"percolate\": {\n    \"index\": \"" + index + "\",\n    \"field\": \"" + field + "\",\n    \"id\": \"" + documentId + "\"\n  }\n}");
    }

    private static MultiSearchRequest prepareMultiPercolateSearchRequest(String esIndex, List<String> ids) {
        LOG.fine("prepareMultiPercolateSearch esClient=..., esIndex=" + esIndex + ", ids=" + ids);
        MultiSearchRequest multiSearchRequests = new MultiSearchRequest();
        for (String id : ids) {
            QueryBuilder pQuery = PercolatorsProcessorImpl.percolateQuery(esIndex, "_percolator_query", id);
            SearchRequest sr = new SearchRequest().indices(esIndex).source(new SearchSourceBuilder().size(100).query(QueryBuilders.constantScoreQuery(pQuery))).scroll(new TimeValue(60000L));
            multiSearchRequests.add(sr);
        }
        return multiSearchRequests;
    }

    @Override
    public void process() throws ElasticsearchRelatedException {
        LOG.info("process");
        if (this.alreadyProcessed) {
            LOG.warning("process() can only be called once!");
            return;
        }
        this.alreadyProcessed = true;
        LOG.info("existSomePercolators: " + (this.existSomePercolators() ? "YES" : "NO"));
        LOG.info("Number of databaseIDs: " + this.databaseIDs.size());
        LOG.info("Max number of processable database IDs: " + this.maxNumberOfProcessableDatabaseIDs);
        try {
            if (this.existSomePercolators() && !this.hasReceivedTooManyDatabaseIDsToGetThePercolatorsFor() && this.databaseIDs.size() > 0) {
                RestHighLevelClient esClient = this.es.getClient();
                MultiSearchResponse multiPercolateSearchResponse = esClient.msearch(PercolatorsProcessorImpl.prepareMultiPercolateSearchRequest(this.esIndex, this.databaseIDs), RequestOptions.DEFAULT);
                MultiSearchResponse.Item[] items = multiPercolateSearchResponse.getResponses();
                for (int i = 0; i < this.databaseIDs.size(); ++i) {
                    String processedID = this.databaseIDs.get(i);
                    SearchResponse searchResponse = items[i].getResponse();
                    if (searchResponse == null || searchResponse.getHits().getTotalHits().value <= 0L) continue;
                    do {
                        for (SearchHit hit : searchResponse.getHits().getHits()) {
                            String matchedPercolatorUID = hit.getId();
                            PercolatorImpl percolator = new PercolatorImpl(this.esIndex, matchedPercolatorUID);
                            if (!percolator.isValid()) continue;
                            PercolatorRelatedDatabaseIDs ids = this.percolatorsAndTheirRelatedDatabaseIDs.get(percolator);
                            if (ids == null) {
                                ids = new PercolatorRelatedDatabaseIDsImpl();
                                this.percolatorsAndTheirRelatedDatabaseIDs.put(percolator, ids);
                            }
                            ids.keepAsNewOrUpdatedDatabaseId(processedID);
                        }
                    } while ((searchResponse = searchResponse.getScrollId() != null ? esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT) : null) != null && searchResponse.getHits().getHits().length != 0);
                    this.es.releaseScrollId(searchResponse);
                }
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        finally {
            this.databaseIDs = null;
        }
    }

    @Override
    public void processForDeleted() throws ElasticsearchRelatedException {
        LOG.info("processForDeleted");
        if (this.deletedAlreadyProcessed) {
            LOG.warning("processForDeleted() can only be called once!");
            return;
        }
        this.deletedAlreadyProcessed = true;
        LOG.info("existSomePercolators: " + (this.existSomePercolators() ? "YES" : "NO"));
        LOG.info("Number of deletedDatabaseIDs: " + this.deletedDatabaseIDs.size());
        if (this.existSomePercolators() && !this.deletedDatabaseIDs.isEmpty()) {
            try {
                RestHighLevelClient esClient = this.es.getClient();
                MultiSearchResponse multiPercolateSearchResponse = esClient.msearch(PercolatorsProcessorImpl.prepareMultiPercolateSearchRequest(this.esIndex, this.deletedDatabaseIDs), RequestOptions.DEFAULT);
                MultiSearchResponse.Item[] items = multiPercolateSearchResponse.getResponses();
                for (int i = 0; i < this.deletedDatabaseIDs.size(); ++i) {
                    String processedID = this.deletedDatabaseIDs.get(i);
                    SearchResponse searchResponse = items[i].getResponse();
                    if (searchResponse == null || searchResponse.getHits().getTotalHits().value <= 0L) continue;
                    do {
                        for (SearchHit hit : searchResponse.getHits().getHits()) {
                            String matchedPercolatorUID = hit.getId();
                            PercolatorImpl percolator = new PercolatorImpl(this.esIndex, matchedPercolatorUID);
                            if (!percolator.isValid()) continue;
                            PercolatorRelatedDatabaseIDs ids = this.percolatorsAndTheirRelatedDatabaseIDs.get(percolator);
                            if (ids == null) {
                                ids = new PercolatorRelatedDatabaseIDsImpl();
                                this.percolatorsAndTheirRelatedDatabaseIDs.put(percolator, ids);
                            }
                            ids.keepAsDeletedDatabaseId(processedID);
                        }
                    } while ((searchResponse = searchResponse.getScrollId() != null ? esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT) : null) != null && searchResponse.getHits().getHits().length != 0);
                    this.es.releaseScrollId(searchResponse);
                }
            }
            catch (IOException ex) {
                throw new ElasticsearchRelatedException(ex);
            }
            catch (ElasticsearchException ex) {
                throw new ElasticsearchRelatedException(ex);
            }
        }
    }
}

