/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.performance;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.es.BpcIndexCreateCallable;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.performance.PerformanceMeasurementException;
import de.virtimo.bpc.core.performance.PerformanceMeasurementManager;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.framework.BundleContext;

public class PerformanceMeasurementManagerImpl
implements PerformanceMeasurementManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(PerformanceMeasurementManagerImpl.class.getName());
    private static final String INDEX_ALIAS_NAME = "bpc-performance";
    private static final DateTimeFormatter UTC_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneOffset.UTC);
    private static final Object PERFORMANCE_INDEX_LOCK = new Object();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ElasticsearchService> elasticSearchServiceTracker;
    private final BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private int cleanupPeriodInMinutes;
    private String deleteEntriesOlderThan;
    private BulkProcessor bulkProcessor = null;
    private final ExecutorService informClientsExecutorService;

    public PerformanceMeasurementManagerImpl(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.bundleContext = bundleContext;
        this.cleanupPeriodInMinutes = coreBundleConfiguration.getSystemPropertyValueAsInt("de.virtimo.bpc.core.performance.cleanupPeriodInMinutes", 60);
        this.deleteEntriesOlderThan = coreBundleConfiguration.getSystemPropertyValueAsString("de.virtimo.bpc.core.performance.deleteEntriesOlderThan", "4 weeks ago");
        this.elasticSearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.coreBundleServiceTracker = new BpcServicesTracker<CoreBundleService>(bundleContext, CoreBundleService.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.informClientsExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-performance-data-clients-informer"));
        this.startPerformanceIndexCleanupTask();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        if (this.bulkProcessor != null) {
            this.bulkProcessor.close();
        }
        if (this.informClientsExecutorService != null) {
            this.informClientsExecutorService.shutdown();
        }
        this.stopPerformanceIndexCleanupTask();
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePerformanceData(String sessionId, String userAgent, List<Map<String, Object>> measurements) throws PerformanceMeasurementException, ServiceNotFoundException, MaintenanceModeEnabledException {
        LOG.info("savePerformanceData sessionId=" + sessionId + ", userAgent=" + userAgent + ", measurements=...");
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        ElasticsearchService es = this.elasticSearchServiceTracker.getService();
        Object object = PERFORMANCE_INDEX_LOCK;
        synchronized (object) {
            String indexName;
            try {
                BpcIndexState bpcPerformanceIndexState = es.getIndexState(INDEX_ALIAS_NAME);
                bpcPerformanceIndexState.prepareUsing(new BpcIndexCreateCallable(){

                    @Override
                    public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                        return es.getManagedIndicesHandler().createManagedIndex(PerformanceMeasurementManagerImpl.INDEX_ALIAS_NAME);
                    }
                });
                indexName = bpcPerformanceIndexState.getIndexName();
            }
            catch (Exception ex) {
                throw new PerformanceMeasurementException((ErrorCode)CoreErrorCode.PERFORMANCE_MEASUREMENT_FAILED, "Failed to prepare the performance measurement index '${index}'.", MapUtil.mapOf("index", INDEX_ALIAS_NAME), (Throwable)ex);
            }
            if (this.bulkProcessor == null) {
                this.bulkProcessor = this.createBulkProcessor(es);
            }
            ZonedDateTime localDateTime = ZonedDateTime.now();
            for (Map<String, Object> measurement : measurements) {
                measurement.put("session", sessionId);
                measurement.put("user-agent", userAgent);
                measurement.put("timestamp", localDateTime.toInstant().toEpochMilli());
                measurement.put("timestampUTC", UTC_TIMESTAMP_FORMATTER.format(localDateTime));
                this.bulkProcessor.add(new IndexRequest(indexName).source(measurement));
            }
        }
    }

    private BulkProcessor createBulkProcessor(final ElasticsearchService es) {
        LOG.info("createBulkProcessor es=...");
        RestHighLevelClient esClient = es.getClient();
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            @Override
            public void beforeBulk(long executionId, BulkRequest request) {
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, final BulkResponse bulkResponse) {
                try {
                    final PercolatorsManager percolatorsManager = PerformanceMeasurementManagerImpl.this.percolatorsManagerTracker.getService();
                    FutureTask<Exception> informClientsFutureTask = new FutureTask<Exception>(new Callable<Exception>(){

                        @Override
                        public Exception call() {
                            try {
                                percolatorsManager.informClientsAboutReplicatedData(es, PerformanceMeasurementManagerImpl.INDEX_ALIAS_NAME, bulkResponse);
                                return null;
                            }
                            catch (Exception ex) {
                                LOG.log(Level.SEVERE, ex.getMessage(), ex);
                                return ex;
                            }
                        }
                    });
                    PerformanceMeasurementManagerImpl.this.informClientsExecutorService.execute(informClientsFutureTask);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to inform the frontends about new performance data.", ex);
                }
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            }
        };
        return BulkProcessor.builder((request, bulkListener) -> esClient.bulkAsync((BulkRequest)request, RequestOptions.DEFAULT, (ActionListener<BulkResponse>)bulkListener), listener).setBulkActions(1000).setFlushInterval(TimeValue.timeValueSeconds(15L)).setConcurrentRequests(1).build();
    }

    private void stopPerformanceIndexCleanupTask() {
        LOG.info("stopPerformanceIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_ALIAS_NAME);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to stop/cancel the running cleanup task for the index 'bpc-performance'.", ex);
        }
    }

    private void startPerformanceIndexCleanupTask() {
        LOG.info("startPerformanceIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_ALIAS_NAME, "timestampUTC", this.deleteEntriesOlderThan, this.cleanupPeriodInMinutes, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to schedule the index cleanup task for the index 'bpc-performance'.", ex);
        }
    }
}

