/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.core.replicator.DatabaseProduct;
import de.virtimo.bpc.util.StringUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbQueryBuilder {
    private DatabaseProduct.Identifier dbIdentifier;
    private String query;
    private Map<String, Object> placeHolderValues;

    private DbQueryBuilder() {
    }

    public DbQueryBuilder(Connection dbConnection) {
        this.dbIdentifier = DatabaseProduct.getIdentifierFromConnection(dbConnection);
    }

    public DbQueryBuilder(DatabaseProduct.Identifier dbIdentifier) {
        this.dbIdentifier = dbIdentifier;
    }

    public DbQueryBuilder withQuery(String query) {
        this.query = query;
        return this;
    }

    public DbQueryBuilder withPlaceHolders(Map<String, Object> placeHolders) {
        this.placeHolderValues = placeHolders;
        return this;
    }

    public String build() {
        String result = new String(this.query);
        if (this.placeHolderValues != null) {
            ArrayList<Replacer> replacers = new ArrayList<Replacer>();
            replacers.add(new PreparedStatementQuestionMarksReplacer());
            replacers.add(new CommaSeparatedColumnsReplacer(this.dbIdentifier));
            replacers.add(new ColumnsToJoinReplacer(this.dbIdentifier));
            replacers.add(new DefaultPlaceHolderReplacer(this.dbIdentifier));
            block0: for (String key : this.placeHolderValues.keySet()) {
                for (Replacer replacer : replacers) {
                    if (!replacer.matches(key)) continue;
                    Object value = this.placeHolderValues.get(key);
                    String replacementValue = replacer.replacementValue(value);
                    result = result.replace(key, replacementValue);
                    continue block0;
                }
            }
        }
        return result;
    }

    private static List<String> prepareValuesForQuery(DatabaseProduct.Identifier dbIdentifier, List<String> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values) {
            result.add(DbQueryBuilder.prepareValueForQuery(dbIdentifier, value));
        }
        return result;
    }

    private static String prepareValueForQuery(DatabaseProduct.Identifier dbIdentifier, String value) {
        if (dbIdentifier == DatabaseProduct.Identifier.POSTGRESQL && DbQueryBuilder.mustBeQuotedForPostgreSQL(value)) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private static boolean mustBeQuotedForPostgreSQL(String tableOrColumnName) {
        if (tableOrColumnName != null && !tableOrColumnName.isEmpty()) {
            for (int i = 0; i < tableOrColumnName.length(); ++i) {
                if (!Character.isUpperCase(tableOrColumnName.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    static class PreparedStatementQuestionMarksReplacer
    implements Replacer {
        PreparedStatementQuestionMarksReplacer() {
        }

        @Override
        public boolean matches(String key) {
            return "$?[]".equalsIgnoreCase(key);
        }

        @Override
        public String replacementValue(Object forValue) {
            if (forValue instanceof Number) {
                Number numberOfPreparedStatementPlaceHolders = (Number)forValue;
                return "?, ".repeat(numberOfPreparedStatementPlaceHolders.intValue() - 1) + "?";
            }
            return String.valueOf(forValue);
        }
    }

    static class CommaSeparatedColumnsReplacer
    implements Replacer {
        private final DatabaseProduct.Identifier dbIdentifier;
        private final Pattern commaSeparatedColumnsPattern = Pattern.compile("^\\$COLUMNS(.*)\\[\\]");
        private Matcher commaSeparatedColumnsMatcher = null;

        public CommaSeparatedColumnsReplacer(DatabaseProduct.Identifier dbIdentifier) {
            this.dbIdentifier = dbIdentifier;
        }

        @Override
        public boolean matches(String key) {
            this.commaSeparatedColumnsMatcher = this.commaSeparatedColumnsPattern.matcher(key);
            return this.commaSeparatedColumnsMatcher.matches();
        }

        @Override
        public String replacementValue(Object forValue) {
            if (forValue instanceof List) {
                return StringUtil.implode(", ", DbQueryBuilder.prepareValuesForQuery(this.dbIdentifier, (List)forValue));
            }
            return String.valueOf(forValue);
        }
    }

    static class ColumnsToJoinReplacer
    implements Replacer {
        private final DatabaseProduct.Identifier dbIdentifier;
        private final Pattern columnsToJoinPattern = Pattern.compile("^\\$COLUMN(.*)\\[(.+)\\]$");
        private Matcher columnsToJoinMatcher = null;

        public ColumnsToJoinReplacer(DatabaseProduct.Identifier dbIdentifier) {
            this.dbIdentifier = dbIdentifier;
        }

        @Override
        public boolean matches(String key) {
            this.columnsToJoinMatcher = this.columnsToJoinPattern.matcher(key);
            return this.columnsToJoinMatcher.matches();
        }

        @Override
        public String replacementValue(Object forValue) {
            String condition = this.columnsToJoinMatcher.group(1);
            String link = this.columnsToJoinMatcher.group(2);
            if (forValue instanceof List) {
                List valueAsList = (List)forValue;
                forValue = valueAsList.toArray(new String[valueAsList.size()]);
            }
            if (forValue instanceof Set) {
                Set valueAsSet = (Set)forValue;
                forValue = valueAsSet.toArray(new String[valueAsSet.size()]);
            }
            if (forValue instanceof String[]) {
                String[] dbIdColumnNames = forValue;
                ArrayList<String> idColumnConditions = new ArrayList<String>();
                for (String dbIdColumnName : dbIdColumnNames) {
                    String preparedDbIdColumnName = DbQueryBuilder.prepareValueForQuery(this.dbIdentifier, dbIdColumnName);
                    idColumnConditions.add(preparedDbIdColumnName + condition);
                }
                return StringUtil.implode(link, idColumnConditions);
            }
            return String.valueOf(forValue);
        }
    }

    static class DefaultPlaceHolderReplacer
    implements Replacer {
        private final DatabaseProduct.Identifier dbIdentifier;

        public DefaultPlaceHolderReplacer(DatabaseProduct.Identifier dbIdentifier) {
            this.dbIdentifier = dbIdentifier;
        }

        @Override
        public boolean matches(String key) {
            return true;
        }

        @Override
        public String replacementValue(Object forValue) {
            String value = String.valueOf(forValue);
            return DbQueryBuilder.prepareValueForQuery(this.dbIdentifier, value);
        }
    }

    static interface Replacer {
        public boolean matches(String var1);

        public String replacementValue(Object var1);
    }
}

