/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.JsonSchemaSettingValidator;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.util.SetUtil;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class ElasticsearchSettingsValidator
extends JsonSchemaSettingValidator {
    private static final Logger LOG = Logger.getLogger(ElasticsearchSettingsValidator.class.getName());

    public ElasticsearchSettingsValidator(BundleContext bundleContext) {
        super(bundleContext);
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "_core".equalsIgnoreCase(moduleId);
    }

    @Override
    public boolean canValidate(Setting setting) {
        return SetUtil.setOf("indexCreationSettings", "indexTemplates", "indexDynamicTemplates").contains(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOG.info("validate setting:" + setting);
        if ("indexCreationSettings".equalsIgnoreCase(setting.getName())) {
            this.validateJsonSchemaOfSetting(setting);
        }
        if ("indexTemplates".equalsIgnoreCase(setting.getName())) {
            this.validateJsonSchemaOfSetting(setting);
        }
        if ("indexDynamicTemplates".equalsIgnoreCase(setting.getName())) {
            this.validateJsonSchemaOfSetting(setting);
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOG.info("validate moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", settings:...");
        return null;
    }
}

