/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import java.sql.Timestamp;
import java.util.logging.Logger;

public class LastUpdateTimestampOnRestartHandler {
    private static final Logger LOG = Logger.getLogger(LastUpdateTimestampOnRestartHandler.class.getName());
    private final String replicationJobId;
    private final ElasticsearchService es;
    private final String index;

    public LastUpdateTimestampOnRestartHandler(String replicationJobId, ElasticsearchService es, String index) {
        this.replicationJobId = replicationJobId;
        this.es = es;
        this.index = index;
    }

    public String getReplicationJobId() {
        return this.replicationJobId;
    }

    public String getIndex() {
        return this.index;
    }

    public Timestamp readFromIndex() {
        LOG.fine("readLastUpdateTimestampOnRestartFromIndex");
        Object lastUpdateTimestampOnRestartObject = this.es.getMetaDataValue(this.index, "last_update_timestamp:::" + this.replicationJobId);
        if (lastUpdateTimestampOnRestartObject instanceof Number) {
            return new Timestamp(((Number)lastUpdateTimestampOnRestartObject).longValue());
        }
        return null;
    }

    public void deleteFromIndex() throws ElasticsearchRelatedException {
        LOG.fine("deleteLastUpdateTimestampOnRestartFromIndex");
        this.es.removeMetaDataValue(this.index, "last_update_timestamp:::" + this.replicationJobId);
    }

    public void saveToIndex(Timestamp timestamp) throws ElasticsearchRelatedException {
        LOG.fine("saveLastUpdateTimestampOnRestartToIndex timestamp=...");
        this.es.setMetaDataValue(this.index, "last_update_timestamp:::" + this.replicationJobId, timestamp.getTime());
    }
}

