/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.es.BpcIndexCreateCallable;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.XContentBuilderUtil;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.DbColumnNamesToEsFieldNamesConverter;
import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.core.replicator.ElasticsearchRecordID;
import de.virtimo.bpc.core.replicator.LastUpdateTimestampOnRestartHandler;
import de.virtimo.bpc.core.replicator.ReplicationJobCallback;
import de.virtimo.bpc.core.replicator.ReplicationJobException;
import de.virtimo.bpc.core.replicator.ReplicationJobSettings;
import de.virtimo.bpc.core.replicator.ReplicationJobStats;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.VamSpecificXmlTypeProcessor;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheck;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobLogData;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogService;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.tailsync.TailSync;
import de.virtimo.bpc.core.resource.ConfigurationEndpoint;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StreamUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.osgi.framework.BundleContext;

public class ReplicationJob
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ReplicationJob.class.getName());
    public static final String REPLICATION_ENABLED_FIELD = "replicationEnabled";
    public static final boolean DEFAULT_REPLICATION_ENABLED = true;
    private final String id;
    private final String name;
    private final boolean enabled;
    private final ReplicationJobStats stats;
    private final ReplicationJobSettings settings;
    private final ReplicationSource source;
    private final ReplicationTarget target;
    private Timestamp lastUpdateTimestamp;
    private Timestamp lastUpdateTimestampOnRestart;
    private boolean forcedLastUpdateTimestampOnRestartReset;
    private java.util.Date lastDataRecordTimestamp;
    private ReplicationJobCallback callback;
    private Integer indexMappingPreparedHashCode;
    private final ShadowCopy shadowCopy;
    private final TailSync tailSync;
    private final ConsistencyCheck consistencyCheck;
    private final LookupJoins lookupJoins;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker = null;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker = null;
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker = null;
    private BpcServicesTracker<ReplicationJobsLogService> replicationJobsLogServiceTracker = null;

    public ReplicationJob(BundleContext bundleContext, String moduleInstanceId, ModuleConfiguration jobConfig) {
        this.id = moduleInstanceId;
        this.name = ConfigurationEndpoint.getModuleInstanceName(jobConfig);
        this.enabled = jobConfig.getSettingValue(REPLICATION_ENABLED_FIELD).asBoolean(true);
        this.stats = new ReplicationJobStats();
        this.settings = new ReplicationJobSettings(jobConfig);
        this.source = new ReplicationSource(jobConfig);
        this.target = new ReplicationTarget(jobConfig);
        this.callback = null;
        this.indexMappingPreparedHashCode = null;
        this.lastUpdateTimestamp = new Timestamp(this.settings.getReplicationStartDateAsDate().getTime());
        this.lastUpdateTimestampOnRestart = null;
        this.forcedLastUpdateTimestampOnRestartReset = false;
        this.shadowCopy = new ShadowCopy(jobConfig);
        this.tailSync = new TailSync(jobConfig);
        this.consistencyCheck = new ConsistencyCheck(jobConfig);
        this.lookupJoins = new LookupJoins(jobConfig.getSetting("join"));
        this.initialize(bundleContext);
    }

    public void initialize(BundleContext bundleContext) {
        LOG.info("initialize bundleContext=" + bundleContext);
        BpcServicesTracker.stopAll(this);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.replicationJobsLogServiceTracker = new BpcServicesTracker<ReplicationJobsLogService>(bundleContext, ReplicationJobsLogService.class);
    }

    public void destroy() {
        LOG.info(this.id + ": destroy");
        BpcServicesTracker.stopAll(this);
        this.callback = null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ReplicationJobStats getStats() {
        return this.stats;
    }

    public ReplicationJobSettings getSettings() {
        return this.settings;
    }

    public Timestamp getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public Timestamp getLastUpdateTimestampOnRestart() {
        return this.lastUpdateTimestampOnRestart;
    }

    public void resetLastUpdateTimestampOnRestart() throws ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("resetLastUpdateTimestampOnRestart");
        if (!this.stats.isRunning()) {
            LastUpdateTimestampOnRestartHandler lastUpdateTimestampOnRestartHandler = new LastUpdateTimestampOnRestartHandler(this.id, this.elasticsearchServiceTracker.getService(), this.target.getIndex());
            lastUpdateTimestampOnRestartHandler.deleteFromIndex();
            this.lastUpdateTimestampOnRestart = null;
        }
        this.forcedLastUpdateTimestampOnRestartReset = true;
    }

    public ReplicationSource getSource() {
        return this.source;
    }

    public ReplicationTarget getTarget() {
        return this.target;
    }

    public java.util.Date getLastDataRecordTimestamp() {
        return this.lastDataRecordTimestamp;
    }

    public void setCallback(ReplicationJobCallback callback) {
        this.callback = callback;
    }

    public ShadowCopy getShadowCopy() {
        return this.shadowCopy;
    }

    public TailSync getTailSync() {
        return this.tailSync;
    }

    public ConsistencyCheck getConsistencyCheck() {
        return this.consistencyCheck;
    }

    public LookupJoins getLookupJoins() {
        return this.lookupJoins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLowerLimitTimestamp(Connection connection, String tableName, String lastUpdateTimestampColumn, Timestamp startFromTimestamp) throws SQLException {
        LOG.info(this.id + ": getLowerLimitTimestamp tableName:" + tableName + ", lastUpdateTimestampColumn:" + lastUpdateTimestampColumn + ", startFromTimestamp:" + startFromTimestamp);
        Timestamp ts = null;
        Statement lowerLimitStatement = null;
        ResultSet lowerLimitResultSet = null;
        try {
            long currentTimestamp = System.currentTimeMillis();
            LOG.info(this.id + ": getLowerLimitTimestamp prepare statement");
            String lowerLimitQuery = new DbQueryBuilder(connection).withQuery("SELECT min($LASTUPDATE_COLUMN) AS MINDATE FROM $TABLE WHERE $LASTUPDATE_COLUMN >= ?").withPlaceHolders(MapUtil.mapOf("$TABLE", tableName, "$LASTUPDATE_COLUMN", lastUpdateTimestampColumn)).build();
            lowerLimitStatement = connection.prepareStatement(lowerLimitQuery);
            lowerLimitStatement.setTimestamp(1, startFromTimestamp);
            if (this.source.getQueryTimeoutInSeconds() >= 0) {
                lowerLimitStatement.setQueryTimeout(this.source.getQueryTimeoutInSeconds());
            }
            long beforeQueryTimestamp = System.currentTimeMillis();
            LOG.info(this.id + ": getLowerLimitTimestamp execute query");
            lowerLimitResultSet = lowerLimitStatement.executeQuery();
            LOG.info(this.id + ": getLowerLimitTimestamp query executed in " + (System.currentTimeMillis() - beforeQueryTimestamp) + "ms");
            if (lowerLimitResultSet.next()) {
                ts = lowerLimitResultSet.getTimestamp(1);
                if (ts != null) {
                    ts = DateUtil.addDurationToTimestamp(13, -1, ts);
                    LOG.info(this.id + ": lower limit resolved: " + ts.toString());
                } else {
                    ts = DateUtil.addDurationToTimestamp(13, -1, new Timestamp(currentTimestamp));
                    LOG.info(this.id + ": special case handling when the table is empty ... using the current timestamp as lower limit: " + ts);
                }
            }
        }
        finally {
            if (lowerLimitStatement != null) {
                lowerLimitStatement.close();
            }
            if (lowerLimitResultSet != null) {
                lowerLimitResultSet.close();
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.enabled) {
            LOG.fine(this.id + ": Replication job is disabled");
            return;
        }
        if (this.shadowCopy != null && this.shadowCopy.isEnabled() && this.shadowCopy.isRunning()) {
            LOG.warning(this.id + ": Replication job is suspended while a shadow copy task is running");
            return;
        }
        if (this.stats.isRunning()) {
            LOG.info(this.id + ": Replication job is already running");
            return;
        }
        this.stats.start();
        ReplicationJobLogData logData = new ReplicationJobLogData(this);
        ResultSet rs = null;
        Connection connection = null;
        Statement preparedStatement = null;
        int overallCounter = 0;
        try {
            String query;
            LOG.info(this.id + ": Started replication " + this.stats.getJobCount() + " - " + this.stats.getLastRunStartDate());
            LOG.info(this.id + ": Block size: " + this.settings.getBlockSize());
            LOG.info(this.id + ": Sync files: " + this.settings.isSyncFiles());
            LOG.info(this.id + ": Unzip synced files: " + this.settings.isUnzipSyncedFiles());
            LOG.info(this.id + ": Restart replication where left off: " + this.settings.isRestartReplicationWhereLeftOff());
            LOG.info(this.id + ": Adjust upper date limit in seconds: " + this.settings.getAdjustUpperDateLimitInSeconds());
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            PercolatorsManager percolatorsManager = this.percolatorsManagerTracker.getService();
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            LastUpdateTimestampOnRestartHandler lastUpdateTimestampOnRestartHandler = new LastUpdateTimestampOnRestartHandler(this.id, es, this.target.getIndex());
            if (this.forcedLastUpdateTimestampOnRestartReset) {
                this.forcedLastUpdateTimestampOnRestartReset = false;
                lastUpdateTimestampOnRestartHandler.deleteFromIndex();
                this.lastUpdateTimestampOnRestart = null;
                this.lastUpdateTimestamp = new Timestamp(this.settings.getReplicationStartDateAsDate().getTime());
                this.stats.reset();
            }
            BpcIndexState indexState = es.getIndexState(this.target.getIndex());
            indexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    String indexName = es.createIndex(ReplicationJob.this.target.getIndex(), ReplicationJob.this.target.hasIndexCreationSettings() ? ReplicationJob.this.target.getIndexCreationSettings() : es.getDefaultIndexCreationSettings(), ReplicationJob.this.target.hasIndexMappings() ? ReplicationJob.this.target.getIndexMappings() : null);
                    ReplicationJob.this.indexMappingPreparedHashCode = null;
                    ReplicationJob.this.lastUpdateTimestampOnRestart = null;
                    ReplicationJob.this.lastUpdateTimestamp = new Timestamp(ReplicationJob.this.settings.getReplicationStartDateAsDate().getTime());
                    ReplicationJob.this.stats.reset();
                    return indexName;
                }
            });
            if (this.stats.isFirstRun()) {
                this.lastUpdateTimestampOnRestart = lastUpdateTimestampOnRestartHandler.readFromIndex();
                if (this.lastUpdateTimestampOnRestart != null && this.lastUpdateTimestampOnRestart.before(this.lastUpdateTimestamp)) {
                    this.lastUpdateTimestampOnRestart = null;
                }
            }
            if (this.stats.isFirstRun()) {
                long t1 = System.currentTimeMillis();
                try {
                    if (!es.waitForElasticsearch(60, new String[]{this.target.getIndex()})) {
                        indexState.reset();
                        throw new Exception("Replication job '" + this.id + "' failed. The target index '" + this.target.getIndex() + "' is not in an useable state.");
                    }
                }
                finally {
                    LOG.info(this.id + ": Waiting for ES index '" + this.target.getIndex() + "' took " + (System.currentTimeMillis() - t1) + "ms");
                }
            }
            connection = databaseManager.getDataSource(this.source.getDataSourceName()).getConnection();
            connection.setAutoCommit(false);
            if (this.stats.isFirstRun()) {
                LOG.info(this.id + ": firstRun - detecting lower date limit");
                if (this.settings.isRestartReplicationWhereLeftOff() && this.lastUpdateTimestampOnRestart != null) {
                    this.lastUpdateTimestamp = new Timestamp(this.lastUpdateTimestampOnRestart.getTime());
                    LOG.info(this.id + ": Using the restart timestamp: " + this.lastUpdateTimestamp);
                } else {
                    Timestamp lowerLimitTimestamp = this.getLowerLimitTimestamp(connection, this.source.getTable(), this.source.getLastUpdateTimestampColumn(), this.lastUpdateTimestamp);
                    if (lowerLimitTimestamp != null && lowerLimitTimestamp.after(this.lastUpdateTimestamp)) {
                        LOG.info(this.id + ": Fittet start date to oldest record found in range. Old limit: " + this.lastUpdateTimestamp.toLocalDateTime() + " new limit: " + lowerLimitTimestamp.toLocalDateTime());
                        this.lastUpdateTimestamp = lowerLimitTimestamp;
                    } else {
                        LOG.info(this.id + ": No lower limit fitting needed");
                    }
                }
                this.stats.setFirstRun(false);
            }
            Timestamp lowerDateLimit = DateUtil.cloneTimestampWithNanos(this.lastUpdateTimestamp);
            Timestamp upperDateLimit = DateUtil.addDaysToTimestamp(this.settings.getBlockDayRange(), this.lastUpdateTimestamp);
            boolean replicatingLatestRecords = upperDateLimit.getTime() >= this.stats.getLastRunStartDate().getTime();
            Calendar generalDateFieldColumnCalendar = DateUtil.getCalendar(this.source.getTimeZoneId());
            Calendar lastUpdateTimestampColumnCalendar = DateUtil.getCalendar(this.source.getLastUpdateTimestampColumnTimeZoneId());
            if (replicatingLatestRecords && this.settings.getAdjustUpperDateLimitInSeconds() > 0) {
                query = new DbQueryBuilder(connection).withQuery("SELECT * FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN < ? ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$TABLE", this.source.getTable(), "$LASTUPDATE_COLUMN", this.source.getLastUpdateTimestampColumn())).build();
                preparedStatement = connection.prepareStatement(query, 1003, 1007);
                preparedStatement.setTimestamp(1, lowerDateLimit);
                logData.setQueryFromDate(lowerDateLimit);
                Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis() - (long)(this.settings.getAdjustUpperDateLimitInSeconds() * 1000));
                if (lastUpdateTimestampColumnCalendar != null) {
                    LOG.info(this.id + ": upper date limit query with " + this.settings.getAdjustUpperDateLimitInSeconds() + " seconds adjustment in '" + this.source.getLastUpdateTimestampColumnTimeZoneId() + "' timezone - " + query + " (from:" + lowerDateLimit.toLocalDateTime() + ", to: " + currentTimestamp.toLocalDateTime() + ")");
                    preparedStatement.setTimestamp(2, currentTimestamp, lastUpdateTimestampColumnCalendar);
                } else {
                    LOG.info(this.id + ": upper date limit query with " + this.settings.getAdjustUpperDateLimitInSeconds() + " seconds adjustment - " + query + " (from:" + lowerDateLimit.toLocalDateTime() + ", to: " + currentTimestamp.toLocalDateTime() + ")");
                    preparedStatement.setTimestamp(2, currentTimestamp);
                }
                logData.setQueryToDate(currentTimestamp);
            } else {
                query = new DbQueryBuilder(connection).withQuery("SELECT * FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN <= ? ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$TABLE", this.source.getTable(), "$LASTUPDATE_COLUMN", this.source.getLastUpdateTimestampColumn())).build();
                preparedStatement = connection.prepareStatement(query, 1003, 1007);
                preparedStatement.setTimestamp(1, lowerDateLimit);
                logData.setQueryFromDate(lowerDateLimit);
                preparedStatement.setTimestamp(2, upperDateLimit);
                logData.setQueryToDate(upperDateLimit);
                LOG.info(this.id + ": regular query - " + query + " (from:" + lowerDateLimit.toLocalDateTime() + ", to: " + upperDateLimit.toLocalDateTime() + ")");
            }
            preparedStatement.setFetchSize(this.settings.getBlockSize());
            if (this.source.getQueryTimeoutInSeconds() >= 0) {
                preparedStatement.setQueryTimeout(this.source.getQueryTimeoutInSeconds());
            }
            long beforeQueryTimestamp = System.currentTimeMillis();
            rs = preparedStatement.executeQuery();
            LOG.info(this.id + ": Query executed in " + (System.currentTimeMillis() - beforeQueryTimestamp) + "ms");
            Integer dbColumnsHashCode = this.getDatabaseColumnsHashCode(rs);
            if (this.indexMappingPreparedHashCode == null || !this.indexMappingPreparedHashCode.equals(dbColumnsHashCode)) {
                if (!indexState.isValid()) {
                    throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
                }
                this.prepareIndexMapping(es, rs);
                es.prepareAttachmentsPipeline(this.target.getIndex());
                this.indexMappingPreparedHashCode = dbColumnsHashCode;
            }
            RestHighLevelClient esClient = es.getClient();
            Set<Percolator> percolatorsFromIndex = percolatorsManager.getAllValidPercolatorsFromIndex(es, this.target.getIndex());
            PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(es, this.target.getIndex(), percolatorsFromIndex);
            percolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            Timestamp lastDate = new Timestamp(this.stats.getLastRunStartDate().getTime());
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            while (rs.next()) {
                if (this.settings.getVamOrganizationId() != null && (!"0".equals(rs.getString("DELETED")) || !this.settings.getVamOrganizationId().equals(rs.getString("ORGANIZATIONID")))) continue;
                lastDate = rs.getTimestamp(this.source.getLastUpdateTimestampColumn());
                this.lastDataRecordTimestamp = lastDate;
                String recordId = ElasticsearchRecordID.create(rs, this.source.getIdColumns());
                XContentBuilder jdbcResultSetContentBuilder = this.resultToJsonObject(rs, this.settings.isSyncFiles(), this.settings.isUnzipSyncedFiles(), generalDateFieldColumnCalendar, this.source.getLastUpdateTimestampColumn(), lastUpdateTimestampColumnCalendar, this.lookupJoins, es);
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(this.target.getIndex())).id(recordId).source(jdbcResultSetContentBuilder);
                if (this.settings.isSyncFiles()) {
                    indexRequest.setPipeline(es.getAttachmentsPipelineName(this.target.getIndex()));
                }
                bulkRequest.add(indexRequest);
                if (bulkRequest.numberOfActions() == this.settings.getBlockSize()) {
                    LOG.fine(this.id + ": Blocksize reached. Send data to ES.");
                    if (!indexState.isValid()) {
                        throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
                    }
                    BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                    LOG.fine(this.id + ": ES call done");
                    overallCounter += this.getNumberOfSuccessfullyIndexedDocuments(bulkResponse);
                    if (bulkResponse.hasFailures()) {
                        throw new Exception(bulkResponse.buildFailureMessage());
                    }
                    this.lastUpdateTimestamp = lastDate;
                    percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
                    bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                }
                if (!this.forcedLastUpdateTimestampOnRestartReset) continue;
                LOG.info(this.id + ": Cancelling running replication job due to user request.");
                break;
            }
            if (bulkRequest.numberOfActions() > 0) {
                if (!indexState.isValid()) {
                    throw new Exception("Replication job (" + this.id + ") cancelled due to deleted index.");
                }
                BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                LOG.fine(this.id + ": ES call done");
                overallCounter += this.getNumberOfSuccessfullyIndexedDocuments(bulkResponse);
                if (bulkResponse.hasFailures()) {
                    throw new Exception(bulkResponse.buildFailureMessage());
                }
                this.lastUpdateTimestamp = lastDate;
                percolatorsProcessor.keepDatabaseIDsFromBulkResponse(bulkResponse);
            }
            LOG.info(this.id + ": call percolator");
            percolatorsProcessor.process();
            if (overallCounter == 0 && !replicatingLatestRecords) {
                this.lastUpdateTimestamp = DateUtil.cloneTimestampWithNanos(upperDateLimit);
                LOG.info(this.id + ": Shift fetch date lower limit to " + upperDateLimit);
            }
            LOG.info(this.id + ": Stop replication number " + this.stats.getJobCount() + " - " + new java.util.Date());
            LOG.info(this.id + ": Replicated " + overallCounter + " records in " + this.stats.runningTimeInMillis() + "ms");
            if (this.lastUpdateTimestamp != null && (this.lastUpdateTimestampOnRestart == null || this.lastUpdateTimestampOnRestart.getTime() != this.lastUpdateTimestamp.getTime())) {
                this.lastUpdateTimestampOnRestart = DateUtil.cloneTimestampWithNanos(this.lastUpdateTimestamp);
                lastUpdateTimestampOnRestartHandler.saveToIndex(this.lastUpdateTimestampOnRestart);
            }
            if (this.callback != null) {
                this.callback.onFinished("replication", this, percolatorsProcessor);
            }
            this.stats.resetLastOccurredException();
        }
        catch (ServiceNotFoundException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Failed to start the replication job. " + ex.getMessage(), ex);
        }
        catch (SQLRecoverableException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Could be that setting the pool properties like pool.testOnBorrow, ... can solve this error (Timeout, BPC-1893): " + ex.getMessage(), ex);
        }
        catch (SQLException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": SQL error: " + ex.getLocalizedMessage(), ex);
        }
        catch (IOException | ElasticsearchException ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Elasticsearch error: " + ex.getLocalizedMessage(), ex);
        }
        catch (Exception ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Unexpected Exception!", ex);
        }
        catch (Throwable ex) {
            this.stats.keepAsLastOccurredException(ex);
            LOG.log(Level.SEVERE, this.id + ": Unexpected Throwable!", ex);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, this.id + ": Closing prepared statement failed.", ex);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, this.id + ": Closing ResultSet failed.", ex);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, this.id + ": Closing database connection failed.", ex);
                }
            }
            this.stats.stop(overallCounter);
            logData.setValues(this.stats);
            this.persistLogData(logData);
        }
    }

    private int getNumberOfSuccessfullyIndexedDocuments(BulkResponse bulkResponse) {
        int result = 0;
        if (bulkResponse != null) {
            for (BulkItemResponse response : bulkResponse.getItems()) {
                if (response.isFailed()) continue;
                ++result;
            }
        }
        return result;
    }

    private void persistLogData(ReplicationJobLogData replicationJobLogData) {
        LOG.fine("persistLogData replicationJobsLogData=...");
        if (this.settings.isLoggingEnabled()) {
            try {
                ReplicationJobsLogService replicationJobsLogService = this.replicationJobsLogServiceTracker.getService();
                replicationJobsLogService.log(replicationJobLogData);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to persist the replication job log data.", ex);
            }
        }
    }

    private Integer getDatabaseColumnsHashCode(ResultSet rs) {
        try {
            TreeMap<String, Integer> hashParts = new TreeMap<String, Integer>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                hashParts.put(rsmd.getColumnName(i), rsmd.getColumnType(i));
            }
            StringBuilder hash = new StringBuilder();
            for (Map.Entry stringIntegerEntry : hashParts.entrySet()) {
                hash.append((String)stringIntegerEntry.getKey()).append("=").append(stringIntegerEntry.getValue()).append("|");
            }
            return hash.toString().hashCode();
        }
        catch (Exception e) {
            LOG.warning("Could not create the database columns hash");
            return null;
        }
    }

    private void addPropertiesMapping(XContentBuilder mappingBuilder, ResultSet rs) throws IOException, SQLException {
        LOG.info("addPropertiesMapping");
        mappingBuilder.startObject("properties");
        mappingBuilder.startObject("_percolator_query").field("type", "percolator").endObject();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            String dbColumnName = rsmd.getColumnName(i);
            int dbColumnType = rsmd.getColumnType(i);
            String esFieldName = this.target.getDbColumnNamesToEsFieldNamesConverter().convert(dbColumnName);
            switch (dbColumnType) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    mappingBuilder.startObject(esFieldName).field("type", "binary").endObject();
                }
            }
        }
        mappingBuilder.endObject();
    }

    private void prepareIndexMapping(ElasticsearchService es, ResultSet rs) throws ReplicationJobException {
        LOG.info(this.id + ": prepareIndexMapping es=..., rs=...");
        try {
            LOG.info(this.id + ": prepareIndexMapping : " + this.target);
            XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().prettyPrint();
            mappingBuilder.startObject();
            if (this.target.hasDynamicTemplates()) {
                XContentBuilderUtil.addDynamicTemplatesMapping(mappingBuilder, this.target.getDynamicTemplates());
            } else {
                XContentBuilderUtil.addDynamicTemplatesMapping(mappingBuilder, es.getDefaultDynamicTemplates());
            }
            this.addPropertiesMapping(mappingBuilder, rs);
            mappingBuilder.endObject();
            this.doIndexMappingUpdate(es, this.target.getIndex(), mappingBuilder);
        }
        catch (ElasticsearchRelatedException | IOException | SQLException ex) {
            throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_INDEX_PREPARATION_FAILED, "Failed to prepare the mapping of index '${index}'.", MapUtil.mapOf("index", this.target.getIndex()), (Throwable)ex);
        }
    }

    private void doIndexMappingUpdate(ElasticsearchService es, String esIndex, XContentBuilder mappingBuilder) throws ElasticsearchRelatedException {
        LOG.fine(this.id + ": doIndexMappingUpdate es=..., esIndex=" + esIndex + ", mappingBuilder=" + Strings.toString(mappingBuilder));
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(esIndex).source(mappingBuilder);
            es.getClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private Calendar evaluateCalendarToUse(String dbColumnName, Calendar generalDateFieldColumnCalendar, String lastUpdateTimestampColumnName, Calendar lastUpdateTimestampColumnCalendar) {
        Calendar result = null;
        if (dbColumnName.equalsIgnoreCase(lastUpdateTimestampColumnName)) {
            result = lastUpdateTimestampColumnCalendar;
        }
        if (result == null) {
            result = generalDateFieldColumnCalendar;
        }
        return result;
    }

    public XContentBuilder resultToJsonObject(ResultSet rs, boolean syncFiles, boolean unzipSyncedFiles, Calendar generalDateFieldColumnCalendar, String lastUpdateTimestampColumnName, Calendar lastUpdateTimestampColumnCalendar, LookupJoins lookupJoins, ElasticsearchService es) throws IOException, SQLException, ElasticsearchRelatedException {
        XContentBuilder jsonObject = XContentFactory.jsonBuilder().startObject();
        DbColumnNamesToEsFieldNamesConverter dbColumnNamesToEsFieldNamesConverter = this.target.getDbColumnNamesToEsFieldNamesConverter();
        VamSpecificXmlTypeProcessor vamSpecificXmlTypeProcessor = null;
        if (this.settings.getVamOrganizationId() != null) {
            vamSpecificXmlTypeProcessor = new VamSpecificXmlTypeProcessor(es, this.target.getIndex(), dbColumnNamesToEsFieldNamesConverter);
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        block24: for (int i = 1; i <= colCount; ++i) {
            String dbColumnName = rsmd.getColumnName(i);
            Calendar calToUse = this.evaluateCalendarToUse(dbColumnName, generalDateFieldColumnCalendar, lastUpdateTimestampColumnName, lastUpdateTimestampColumnCalendar);
            int dbColumnType = rsmd.getColumnType(i);
            String esFieldName = this.target.getDbColumnNamesToEsFieldNamesConverter().convert(dbColumnName);
            if (vamSpecificXmlTypeProcessor != null) {
                if (dbColumnName.equals("VERSIONEDATTRIBUTES") || dbColumnName.endsWith("_PROPERTIES")) {
                    SQLXML xml = rs.getSQLXML(dbColumnName);
                    if (xml == null) continue;
                    DOMSource columnValue = xml.getSource(DOMSource.class);
                    vamSpecificXmlTypeProcessor.appendVAMAttributes(es, jsonObject, lookupJoins, columnValue);
                    continue;
                }
                if (dbColumnName.startsWith("VERSIONEDATTRIBUTES") || dbColumnName.equals("UNVERSIONEDATTRIBUTES")) continue;
            }
            switch (dbColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    String charValue = rs.getString(dbColumnName);
                    charValue = StringUtil.isNullOrEmpty(charValue) ? null : charValue;
                    jsonObject.field(esFieldName, charValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, charValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case -16: 
                case -15: 
                case -9: {
                    String ncharValue = rs.getNString(dbColumnName);
                    ncharValue = StringUtil.isNullOrEmpty(ncharValue) ? null : ncharValue;
                    jsonObject.field(esFieldName, ncharValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, ncharValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case -7: 
                case 16: {
                    boolean booleanValue = rs.getBoolean(dbColumnName);
                    if (rs.wasNull()) {
                        jsonObject.field(esFieldName, (Boolean)null);
                        continue block24;
                    }
                    jsonObject.field(esFieldName, booleanValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, booleanValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case 92: {
                    Time timeObject = rs.getTime(dbColumnName);
                    String timeValue = timeObject == null ? null : timeObject.toString();
                    jsonObject.field(esFieldName, timeValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, timeValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case 91: {
                    Date dateValue = calToUse != null ? rs.getDate(dbColumnName, calToUse) : rs.getDate(dbColumnName);
                    jsonObject.timeField(esFieldName, es.formatForElasticsearch(dateValue));
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, dateValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case 93: {
                    Timestamp timestampValue = calToUse != null ? rs.getTimestamp(dbColumnName, calToUse) : rs.getTimestamp(dbColumnName);
                    jsonObject.timeField(esFieldName, es.formatForElasticsearch(timestampValue));
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, timestampValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case -8: {
                    Object object = rs.getObject(dbColumnName);
                    if (object != null && Arrays.asList("oracle.sql.ROWID").contains(object.getClass().getName())) {
                        String rowidValue = String.valueOf(object);
                        jsonObject.field(esFieldName, rowidValue);
                        ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, rowidValue, dbColumnNamesToEsFieldNamesConverter);
                        continue block24;
                    }
                    if (object == null) continue block24;
                    LOG.log(Level.SEVERE, "Unhandled JDBC type class found for column '" + dbColumnName + "' with the type '" + dbColumnType + "': " + object.getClass().getName());
                    continue block24;
                }
                case -102: 
                case -101: 
                case -100: {
                    Object object = rs.getObject(dbColumnName);
                    if (object != null && Arrays.asList("oracle.sql.TIMESTAMPNS", "oracle.sql.TIMESTAMPTZ", "oracle.sql.TIMESTAMPLTZ").contains(object.getClass().getName())) {
                        Timestamp timestampValue = calToUse != null ? rs.getTimestamp(dbColumnName, calToUse) : rs.getTimestamp(dbColumnName);
                        jsonObject.timeField(esFieldName, es.formatForElasticsearch(timestampValue));
                        ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, timestampValue, dbColumnNamesToEsFieldNamesConverter);
                        continue block24;
                    }
                    if (object == null) continue block24;
                    LOG.log(Level.SEVERE, "Unhandled JDBC type class found for column '" + dbColumnName + "' with the type '" + dbColumnType + "': " + object.getClass().getName());
                    continue block24;
                }
                case -155: {
                    Object object = rs.getObject(dbColumnName);
                    if (object != null && Arrays.asList("microsoft.sql.DateTimeOffset").contains(object.getClass().getName())) {
                        Timestamp timestampValue = calToUse != null ? rs.getTimestamp(dbColumnName, calToUse) : rs.getTimestamp(dbColumnName);
                        jsonObject.timeField(esFieldName, es.formatForElasticsearch(timestampValue));
                        ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, timestampValue, dbColumnNamesToEsFieldNamesConverter);
                        continue block24;
                    }
                    if (object == null) continue block24;
                    LOG.log(Level.SEVERE, "Unhandled JDBC type class found for column '" + dbColumnName + "' with the type '" + dbColumnType + "': " + object.getClass().getName());
                    continue block24;
                }
                case -6: 
                case 4: 
                case 5: {
                    int intValue = rs.getInt(dbColumnName);
                    if (rs.wasNull()) {
                        jsonObject.field(esFieldName, (Integer)null);
                        continue block24;
                    }
                    jsonObject.field(esFieldName, intValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, intValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case -5: {
                    long bigintValue = rs.getLong(dbColumnName);
                    if (rs.wasNull()) {
                        jsonObject.field(esFieldName, (Long)null);
                        continue block24;
                    }
                    jsonObject.field(esFieldName, bigintValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, bigintValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case 7: {
                    float realValue = rs.getFloat(dbColumnName);
                    if (rs.wasNull()) {
                        jsonObject.field(esFieldName, (Float)null);
                        continue block24;
                    }
                    jsonObject.field(esFieldName, realValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, Float.valueOf(realValue), dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case 6: 
                case 8: {
                    double doubleValue = rs.getDouble(dbColumnName);
                    if (rs.wasNull()) {
                        jsonObject.field(esFieldName, (Double)null);
                        continue block24;
                    }
                    jsonObject.field(esFieldName, doubleValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, doubleValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case 2: 
                case 3: {
                    BigDecimal bd = rs.getBigDecimal(dbColumnName);
                    if (bd == null || bd.scale() < 0) {
                        Object objectValue = rs.getObject(dbColumnName);
                        jsonObject.field(esFieldName, objectValue);
                        continue block24;
                    }
                    try {
                        long longValue = bd.longValueExact();
                        if (Long.toString(longValue).equals(rs.getString(i))) {
                            jsonObject.field(esFieldName, longValue);
                            ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, longValue, dbColumnNamesToEsFieldNamesConverter);
                            continue block24;
                        }
                        double doubleValue = bd.doubleValue();
                        jsonObject.field(esFieldName, doubleValue);
                        ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, doubleValue, dbColumnNamesToEsFieldNamesConverter);
                    }
                    catch (ArithmeticException e) {
                        double doubleValue = bd.doubleValue();
                        jsonObject.field(esFieldName, doubleValue);
                        ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, doubleValue, dbColumnNamesToEsFieldNamesConverter);
                    }
                    continue block24;
                }
                case 2003: {
                    Array arrayValue = rs.getArray(dbColumnName);
                    jsonObject.field(esFieldName, arrayValue);
                    continue block24;
                }
                case -3: 
                case -2: {
                    byte[] binaryData;
                    if (!syncFiles || (binaryData = rs.getBytes(dbColumnName)) == null || binaryData.length <= 0) continue block24;
                    jsonObject.field(esFieldName, Base64.getEncoder().encode(binaryData));
                    continue block24;
                }
                case -4: {
                    if (!syncFiles) continue block24;
                    if (unzipSyncedFiles && StreamUtil.isGZipped(rs.getBinaryStream(dbColumnName))) {
                        jsonObject.field(esFieldName, StreamUtil.unzip(rs.getBinaryStream(dbColumnName)));
                        continue block24;
                    }
                    byte[] binaryData = rs.getBytes(dbColumnName);
                    if (binaryData == null || binaryData.length <= 0) continue block24;
                    jsonObject.field(esFieldName, Base64.getEncoder().encode(binaryData));
                    continue block24;
                }
                case 2004: {
                    Blob blob;
                    if (!syncFiles || (blob = rs.getBlob(dbColumnName)) == null) continue block24;
                    byte[] byteArrayValue = unzipSyncedFiles && StreamUtil.isGZipped(blob.getBinaryStream()) ? StreamUtil.unzip(blob.getBinaryStream()) : Base64.getEncoder().encode(blob.getBytes(1L, (int)blob.length()));
                    jsonObject.field(esFieldName, byteArrayValue);
                    continue block24;
                }
                case 2005: {
                    Clob clob = rs.getClob(dbColumnName);
                    if (clob == null) continue block24;
                    String clobValue = StreamUtil.characterStreamAsString(clob.getCharacterStream());
                    jsonObject.field(esFieldName, clobValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, clobValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                case 2009: {
                    SQLXML sqlXml = rs.getSQLXML(dbColumnName);
                    if (sqlXml == null) continue block24;
                    String xmlValue = sqlXml.getString();
                    jsonObject.field(esFieldName, xmlValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, xmlValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
                default: {
                    Object defaultValue = rs.getObject(dbColumnName);
                    jsonObject.field(esFieldName, defaultValue);
                    ReplicationJob.appendLookupData(es, jsonObject, lookupJoins, dbColumnName, defaultValue, dbColumnNamesToEsFieldNamesConverter);
                    continue block24;
                }
            }
        }
        jsonObject.endObject();
        return jsonObject;
    }

    public static void appendLookupData(ElasticsearchService es, XContentBuilder jsonObject, LookupJoins lookupJoins, String columnName, Object columnValue, DbColumnNamesToEsFieldNamesConverter dbColumnNamesToEsFieldNamesConverter) throws IOException, ElasticsearchRelatedException {
        if (columnValue != null && lookupJoins.isLookupJoinKeyField(columnName)) {
            Map<String, Object> alreadyPrefixedLookupData = lookupJoins.getLookupJoinByKeyField(columnName).getAlreadyPrefixedLookupData(es, columnValue);
            for (Map.Entry<String, Object> alreadyPrefixedLookupDataEntry : alreadyPrefixedLookupData.entrySet()) {
                String fieldName = dbColumnNamesToEsFieldNamesConverter.convert(alreadyPrefixedLookupDataEntry.getKey());
                Object fieldValue = alreadyPrefixedLookupDataEntry.getValue();
                if (fieldValue instanceof Date) {
                    jsonObject.timeField(fieldName, es.formatForElasticsearch((Date)fieldValue));
                    continue;
                }
                if (fieldValue instanceof Timestamp) {
                    jsonObject.timeField(fieldName, es.formatForElasticsearch((Timestamp)fieldValue));
                    continue;
                }
                if (fieldValue instanceof java.util.Date) {
                    jsonObject.timeField(fieldName, es.formatForElasticsearch((java.util.Date)fieldValue));
                    continue;
                }
                jsonObject.field(fieldName, fieldValue);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationJob)) {
            return false;
        }
        ReplicationJob that = (ReplicationJob)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ReplicationJob{id=" + this.id + ", enabled=" + this.enabled + ", settings=" + this.settings + ", source=" + this.source + ", target=" + this.target + ", lastUpdateTimestamp=" + this.lastUpdateTimestamp + ", shadowCopy=" + this.shadowCopy + ", tailSync=" + this.tailSync + ", consistencyCheck=" + this.consistencyCheck + ", lookupJoins=" + this.lookupJoins + "}";
    }
}

