/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.StringUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class ReplicationJobSettings {
    private static final Logger LOG = Logger.getLogger(ReplicationJobSettings.class.getName());
    private static final String DATE_FORMAT = "yyyy-MM-dd' 'HH:mm:ss.SSS";
    public static final String REPLICATION_DELAY = "replicationDelay";
    public static final String REPLICATION_INTERVAL = "replicationInterval";
    public static final String REPLICATION_START_DATE = "replicationStartDate";
    public static final String REPLICATION_BLOCK_SIZE = "replicationBlockSize";
    public static final String REPLICATION_BLOCK_DAY_RANGE = "replicationBlockDayRange";
    public static final String REPLICATION_SYNC_FILES = "replicationSyncFiles";
    public static final String REPLICATION_UNZIP_SYNCED_FILES = "replicationUnzipSyncedFiles";
    public static final String REPLICATION_RESTART_WHERE_LEFT_OFF = "restartReplicationWhereLeftOff";
    public static final String REPLICATION_ADJUST_UPPER_DATE_LIMIT_IN_SECONDS = "adjustUpperDateLimitInSeconds";
    public static final String REPLICATION_VAM_ORGANIZATION_ID = "vamOrganizationId";
    public static final String REPLICATION_LOGGING_ENABLED = "replicationLoggingEnabled";
    public static final int DEFAULT_REPLICATION_DELAY = 60;
    public static final int DEFAULT_REPLICATION_INTERVAL = 10;
    public static final String DEFAULT_REPLICATION_START_DATE = "2010-01-01 00:00:00.000";
    public static final int DEFAULT_BLOCK_SIZE = 2500;
    public static final int DEFAULT_BLOCK_DAY_RANGE = 10;
    public static final boolean DEFAULT_SYNC_FILES = false;
    public static final boolean DEFAULT_UNZIP_SYNCED_FILES = true;
    public static final boolean DEFAULT_REPLICATION_RESTART_WHERE_LEFT_OFF = true;
    public static final int DEFAULT_ADJUST_UPPER_DATE_LIMIT_IN_SECONDS = 0;
    public static final String DEFAULT_VAM_ORGANIZATION_ID = null;
    public static final boolean DEFAULT_REPLICATION_LOGGING_ENABLED = false;
    private int replicationDelay;
    private int replicationInterval;
    private int blockSize;
    private int blockDayRange;
    private int adjustUpperDateLimitInSeconds;
    private boolean syncFiles;
    private boolean unzipSyncedFiles;
    private boolean restartReplicationWhereLeftOff;
    private String replicationStartDate;
    private String vamOrganizationId;
    private boolean loggingEnabled;
    private final DateFormat dateFormatter;

    public ReplicationJobSettings(ModuleConfiguration jobConfig) {
        this.replicationDelay = jobConfig.getSettingValue(REPLICATION_DELAY).asInt(60);
        this.replicationInterval = jobConfig.getSettingValue(REPLICATION_INTERVAL).asInt(10);
        this.replicationStartDate = jobConfig.getSettingValue(REPLICATION_START_DATE).asString(DEFAULT_REPLICATION_START_DATE);
        this.blockSize = jobConfig.getSettingValue(REPLICATION_BLOCK_SIZE).asInt(2500);
        this.blockDayRange = jobConfig.getSettingValue(REPLICATION_BLOCK_DAY_RANGE).asInt(10);
        this.syncFiles = jobConfig.getSettingValue(REPLICATION_SYNC_FILES).asBoolean(false);
        this.unzipSyncedFiles = jobConfig.getSettingValue(REPLICATION_UNZIP_SYNCED_FILES).asBoolean(true);
        this.restartReplicationWhereLeftOff = jobConfig.getSettingValue(REPLICATION_RESTART_WHERE_LEFT_OFF).asBoolean(true);
        this.adjustUpperDateLimitInSeconds = jobConfig.getSettingValue(REPLICATION_ADJUST_UPPER_DATE_LIMIT_IN_SECONDS).asInt(0);
        this.vamOrganizationId = jobConfig.getSettingValue(REPLICATION_VAM_ORGANIZATION_ID).asString(DEFAULT_VAM_ORGANIZATION_ID);
        if (StringUtil.isNullOrEmpty(this.vamOrganizationId)) {
            this.vamOrganizationId = null;
        }
        this.loggingEnabled = jobConfig.getSettingValue(REPLICATION_LOGGING_ENABLED).asBoolean(false);
        this.dateFormatter = new SimpleDateFormat(DATE_FORMAT);
    }

    public int getReplicationDelay() {
        return this.replicationDelay;
    }

    public int getReplicationInterval() {
        return this.replicationInterval;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getBlockDayRange() {
        return this.blockDayRange;
    }

    public int getAdjustUpperDateLimitInSeconds() {
        return this.adjustUpperDateLimitInSeconds;
    }

    public boolean isSyncFiles() {
        return this.syncFiles;
    }

    public boolean isUnzipSyncedFiles() {
        return this.unzipSyncedFiles;
    }

    public boolean isRestartReplicationWhereLeftOff() {
        return this.restartReplicationWhereLeftOff;
    }

    public String getReplicationStartDate() {
        return this.replicationStartDate;
    }

    public String getVamOrganizationId() {
        return this.vamOrganizationId;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public Date getReplicationStartDateAsDate() {
        Date result;
        try {
            result = this.dateFormatter.parse(this.replicationStartDate);
        }
        catch (ParseException e) {
            LOG.info("replicationStartDate ignored. Can't parse replicationStartDate (" + this.replicationStartDate + ") with format yyyy-MM-dd' 'HH:mm:ss.SSS. Trying to parse it as an relative value.");
            try {
                result = DateUtil.getDateForRelativeValue(this.replicationStartDate);
            }
            catch (IllegalArgumentException ex) {
                LOG.warning("replicationStartDate ignored. replicationStartDate (" + this.replicationStartDate + ") is not a relative value (" + ex.getMessage() + ").");
                result = new Date(0L);
            }
        }
        return result;
    }

    public DateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public String toString() {
        return "ReplicationJobSettings{replicationDelay=" + this.replicationDelay + ", replicationInterval=" + this.replicationInterval + ", blockSize=" + this.blockSize + ", blockDayRange=" + this.blockDayRange + ", adjustUpperDateLimitInSeconds=" + this.adjustUpperDateLimitInSeconds + ", syncFiles=" + this.syncFiles + ", unzipSyncedFiles=" + this.unzipSyncedFiles + ", restartReplicationWhereLeftOff=" + this.restartReplicationWhereLeftOff + ", replicationStartDate='" + this.replicationStartDate + "', vamOrganizationId='" + this.vamOrganizationId + "', loggingEnabled=" + this.loggingEnabled + "}";
    }
}

