/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import java.util.Date;

public class ReplicationJobStats {
    private boolean firstRun = true;
    private boolean running = false;
    private int jobCount = 0;
    private Date lastRunStartDate = new Date(0L);
    private Date lastRunEndDate = new Date(0L);
    private int lastRunReplicatedRecords = 0;
    private int replicatedRecords = 0;
    private int errorCount = 0;
    private Throwable lastOccurredException = null;

    public void reset() {
        this.firstRun = true;
        this.jobCount = 1;
        this.replicatedRecords = 0;
        this.lastRunReplicatedRecords = 0;
        this.errorCount = 0;
        this.lastOccurredException = null;
    }

    public void start() {
        this.running = true;
        ++this.jobCount;
        this.lastRunStartDate = new Date();
    }

    public void stop(int records) {
        this.running = false;
        this.lastRunEndDate = new Date();
        this.lastRunReplicatedRecords = records;
        this.replicatedRecords += records;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public void setFirstRun(boolean firstRun) {
        this.firstRun = firstRun;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getJobCount() {
        return this.jobCount;
    }

    public Date getLastRunStartDate() {
        return this.lastRunStartDate;
    }

    public long runningTimeInMillis() {
        return System.currentTimeMillis() - this.lastRunStartDate.getTime();
    }

    public Date getLastRunEndDate() {
        return this.lastRunEndDate;
    }

    public long getLastRunReplicatedRecords() {
        return this.lastRunReplicatedRecords;
    }

    public int getReplicatedRecords() {
        return this.replicatedRecords;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void keepAsLastOccurredException(Throwable ex) {
        ++this.errorCount;
        this.lastOccurredException = ex;
    }

    public Throwable getLastOccurredException() {
        return this.lastOccurredException;
    }

    public void resetLastOccurredException() {
        this.lastOccurredException = null;
    }

    public String getCurrentErrorMessage() {
        if (this.lastOccurredException != null) {
            return this.lastOccurredException.getLocalizedMessage();
        }
        return null;
    }
}

