/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class ReplicationMetricsCollector
extends Collector {
    private static final Logger LOG = Logger.getLogger(ReplicationMetricsCollector.class.getName());
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;

    public ReplicationMetricsCollector(BundleContext bundleContext) {
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
    }

    public void unregister() {
        LOG.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_enabled", "Status of the replication (1=enabled; 0=disabled)", this.replicationManagerTracker.getService().isReplicationEnabled() ? 1.0 : 0.0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            long numberOfReplicationJobs = 0L;
            long numberOfEnabledReplicationJobs = 0L;
            long numberOfDisabledReplicationJobs = 0L;
            long numberOfReplicationJobsWithErrors = 0L;
            for (ReplicationJob job : this.replicationManagerTracker.getService().getJobs()) {
                ++numberOfReplicationJobs;
                if (job.isEnabled()) {
                    ++numberOfEnabledReplicationJobs;
                } else {
                    ++numberOfDisabledReplicationJobs;
                }
                if (job.getStats().getCurrentErrorMessage() == null) continue;
                ++numberOfReplicationJobsWithErrors;
            }
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_jobs", "Number of replication jobs", (double)numberOfReplicationJobs));
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_enabled_jobs", "Number of enabled replication jobs", (double)numberOfEnabledReplicationJobs));
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_disabled_jobs", "Number of disabled replication jobs", (double)numberOfDisabledReplicationJobs));
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_replication_number_of_jobs_with_errors", "Number of replication jobs with errors", (double)numberOfReplicationJobsWithErrors));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }
}

