/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class ReplicationSource {
    private static final Logger LOG = Logger.getLogger(ReplicationSource.class.getName());
    public static final String RDMS_DATASOURCE_NAME_FIELD = "rdmsDataSourceName";
    public static final String SOURCE_TABLE_FIELD = "sourceTable";
    public static final String SOURCE_TIMEZONE_FIELD = "sourceTimeZone";
    public static final String LAST_UPDATE_COLUMN_FIELD = "lastUpdateColumn";
    public static final String LAST_UPDATE_COLUMN_TIMEZONE_FIELD = "lastUpdateColumnTimeZone";
    public static final String ID_COLUMNS_FIELD = "idColumns";
    public static final String DB_QUERY_TIMEOUT_IN_SECONDS = "sourceQueryTimeoutInSeconds";
    public static final int DEFAULT_DB_QUERY_TIMEOUT_IN_SECONDS = 300;
    private final String dataSourceName;
    private final String table;
    private final String timeZoneId;
    private final String lastUpdateTimestampColumn;
    private final String lastUpdateTimestampColumnTimeZoneId;
    private final List<String> idColumns;
    private final int queryTimeoutInSeconds;

    public ReplicationSource(ModuleConfiguration jobConfig) {
        this(jobConfig.getSettingValue(RDMS_DATASOURCE_NAME_FIELD).asString(null), jobConfig.getSettingValue(SOURCE_TABLE_FIELD).asString(null), jobConfig.getSettingValue(LAST_UPDATE_COLUMN_FIELD).asString(null), jobConfig.getSettingValue(LAST_UPDATE_COLUMN_TIMEZONE_FIELD).asString(null), jobConfig.getSettingValue(ID_COLUMNS_FIELD).asString(null), jobConfig.getSettingValue(SOURCE_TIMEZONE_FIELD).asString(null), jobConfig.getSettingValue(DB_QUERY_TIMEOUT_IN_SECONDS).asInt(300));
    }

    public ReplicationSource(String dataSourceName, String table, String lastUpdateTimestampColumn, String lastUpdateTimestampColumnTimeZoneId, String idColumns, String timeZoneId, int queryTimeoutInSeconds) {
        this.dataSourceName = dataSourceName;
        this.table = table;
        this.lastUpdateTimestampColumn = lastUpdateTimestampColumn == null ? "LASTUPDATE" : lastUpdateTimestampColumn;
        this.lastUpdateTimestampColumnTimeZoneId = lastUpdateTimestampColumnTimeZoneId;
        this.idColumns = idColumns == null ? Arrays.asList("PROCESSID") : StringUtil.explode(idColumns, ",");
        this.timeZoneId = timeZoneId;
        this.queryTimeoutInSeconds = queryTimeoutInSeconds;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getTable() {
        return this.table;
    }

    public String getLastUpdateTimestampColumn() {
        return this.lastUpdateTimestampColumn;
    }

    public String getLastUpdateTimestampColumnTimeZoneId() {
        return this.lastUpdateTimestampColumnTimeZoneId;
    }

    public String[] getIdColumns() {
        return this.idColumns.toArray(new String[0]);
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public int getQueryTimeoutInSeconds() {
        return this.queryTimeoutInSeconds;
    }

    public String toString() {
        return "ReplicationSource{dataSourceName='" + this.dataSourceName + "', table='" + this.table + "', lastUpdateTimestampColumn='" + this.lastUpdateTimestampColumn + "', lastUpdateTimestampColumnTimeZoneId='" + this.lastUpdateTimestampColumnTimeZoneId + "', idColumns=" + this.idColumns + ", timeZoneId=" + this.timeZoneId + ", queryTimeoutInSeconds=" + this.queryTimeoutInSeconds + "}";
    }
}

