/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.core.replicator.DbColumnNamesToEsFieldNamesConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ReplicationTarget {
    private static final Logger LOG = Logger.getLogger(ReplicationTarget.class.getName());
    public static final String TARGET_INDEX = "targetIndex";
    public static final String TARGET_INDEX_CREATION_SETTINGS = "targetIndexCreationSettings";
    public static final String TARGET_INDEX_MAPPINGS = "targetIndexMappings";
    public static final String TARGET_INDEX_DYNAMIC_TEMPLATES = "targetIndexDynamicTemplates";
    public static final String TARGET_INDEX_CASE_SENSITIVITY_OF_FIELDS = "targetIndexCaseSensitivityOfFields";
    private final String index;
    private final Map indexCreationSettings;
    private final Map indexMappings;
    private final List dynamicTemplates;
    private final DbColumnNamesToEsFieldNamesConverter dbColumnNamesToEsFieldNamesConverter;

    public ReplicationTarget(ModuleConfiguration jobConfig) {
        this(jobConfig.getSettingValue(TARGET_INDEX).asString(null), jobConfig.getSettingValue(TARGET_INDEX_CREATION_SETTINGS).asMap(null), jobConfig.getSettingValue(TARGET_INDEX_MAPPINGS).asMap(null), jobConfig.getSettingValue(TARGET_INDEX_DYNAMIC_TEMPLATES).asList(null), jobConfig.getSettingValue(TARGET_INDEX_CASE_SENSITIVITY_OF_FIELDS).asString("asSource"));
    }

    public ReplicationTarget(String index, Map indexCreationSettings, Map indexMappings, List dynamicTemplatesMapping, String caseSensitivityOfFields) {
        this.index = index != null ? index.toLowerCase() : index;
        this.indexCreationSettings = indexCreationSettings;
        this.indexMappings = indexMappings;
        this.dynamicTemplates = dynamicTemplatesMapping;
        this.dbColumnNamesToEsFieldNamesConverter = new DbColumnNamesToEsFieldNamesConverter(caseSensitivityOfFields);
    }

    public String getIndex() {
        return this.index;
    }

    public boolean hasIndexCreationSettings() {
        return this.indexCreationSettings != null && !this.indexCreationSettings.isEmpty();
    }

    public Map getIndexCreationSettings() {
        return this.hasIndexCreationSettings() ? new HashMap(this.indexCreationSettings) : null;
    }

    public boolean hasIndexMappings() {
        return this.indexMappings != null && !this.indexMappings.isEmpty();
    }

    public Map getIndexMappings() {
        return this.hasIndexMappings() ? new HashMap(this.indexMappings) : null;
    }

    public boolean hasDynamicTemplates() {
        return this.dynamicTemplates != null && !this.dynamicTemplates.isEmpty();
    }

    public List getDynamicTemplates() {
        return this.hasDynamicTemplates() ? new ArrayList(this.dynamicTemplates) : null;
    }

    public DbColumnNamesToEsFieldNamesConverter getDbColumnNamesToEsFieldNamesConverter() {
        return this.dbColumnNamesToEsFieldNamesConverter;
    }

    public String toString() {
        return "ReplicationTarget{index='" + this.index + "', indexCreationSettings=" + this.indexCreationSettings + ", indexMappings=" + this.indexMappings + ", dynamicTemplates=" + this.dynamicTemplates + ", dbColumnNamesToEsFieldNamesConverter=" + this.dbColumnNamesToEsFieldNamesConverter + "}";
    }
}

