/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.util.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SourceTableNameExtractor {
    private String separator;
    private String catalogName = null;
    private String schemaName = null;
    private String tableName = null;

    public SourceTableNameExtractor(DatabaseMetaData databaseMetaData, String sourceTableName) throws SQLException {
        if (!StringUtil.isNullOrEmpty(sourceTableName)) {
            List<String> entries;
            this.separator = databaseMetaData.getCatalogSeparator();
            if (StringUtil.isNullOrEmpty(this.separator)) {
                this.separator = ".";
            }
            if ((entries = StringUtil.explode(sourceTableName, this.separator)).size() == 3) {
                this.catalogName = entries.get(0);
                this.schemaName = entries.get(1);
                this.tableName = entries.get(2);
            } else if (entries.size() == 2) {
                boolean valid = false;
                if (!valid) {
                    ResultSet schemaCheckResultSet = databaseMetaData.getTables(null, entries.get(0), entries.get(1), null);
                    if (schemaCheckResultSet.next()) {
                        valid = true;
                        this.schemaName = entries.get(0);
                        this.tableName = entries.get(1);
                    }
                    schemaCheckResultSet.close();
                }
                if (!valid) {
                    ResultSet catalogCheckResultSet = databaseMetaData.getTables(entries.get(0), null, entries.get(1), null);
                    if (catalogCheckResultSet.next()) {
                        valid = true;
                        this.catalogName = entries.get(0);
                        this.tableName = entries.get(1);
                    }
                    catalogCheckResultSet.close();
                }
            } else if (entries.size() == 1) {
                this.tableName = entries.get(0);
            }
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isParsed() {
        return this.catalogName != null || this.schemaName != null || this.tableName != null;
    }

    public String toString() {
        return "SourceTableNameExtractor{separator='" + this.separator + "', catalogName='" + this.catalogName + "', schemaName='" + this.schemaName + "', tableName='" + this.tableName + "'}";
    }
}

