/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import java.io.IOException;
import java.time.Instant;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.builder.SearchSourceBuilder;

class ConsistencyCheckElasticsearchHandler {
    private static final Logger LOG = Logger.getLogger(ConsistencyCheckElasticsearchHandler.class.getName());
    private final ElasticsearchService es;
    private final String esIndex;
    private final String lastUpdateTimestampColumn;
    private final String loggingPrefix;

    ConsistencyCheckElasticsearchHandler(ElasticsearchService es, String esIndex, String lastUpdateTimestampColumn, String loggingPrefix) {
        this.es = es;
        this.esIndex = esIndex;
        this.lastUpdateTimestampColumn = lastUpdateTimestampColumn;
        this.loggingPrefix = loggingPrefix;
    }

    Instant getUpperTargetDate() throws ElasticsearchRelatedException {
        LOG.info(this.loggingPrefix + ": getUpperTargetDate");
        long start = System.currentTimeMillis();
        try {
            SearchRequest searchReq = new SearchRequest().indices(this.esIndex).source(new SearchSourceBuilder().size(0).query(QueryBuilders.matchAllQuery()).aggregation((AggregationBuilder)AggregationBuilders.max("max_lastupdate").field(this.lastUpdateTimestampColumn)));
            SearchResponse maxLastupdateDateResponse = this.es.getClient().search(searchReq, RequestOptions.DEFAULT);
            if (maxLastupdateDateResponse.getHits().getTotalHits().value == 0L) {
                LOG.info(this.loggingPrefix + ": No documents found to get the upper target date");
                Instant instant = null;
                return instant;
            }
            Max maxAgg = (Max)maxLastupdateDateResponse.getAggregations().get("max_lastupdate");
            LOG.info(this.loggingPrefix + ": maxAgg = " + maxAgg.getValueAsString());
            double maxAggValue = maxAgg.getValue();
            LOG.info(this.loggingPrefix + ": maxAggValue = " + maxAggValue);
            if (maxAggValue == Double.NEGATIVE_INFINITY) {
                LOG.info(this.loggingPrefix + ": Aggregation value not found to get the upper target date. Is '" + this.lastUpdateTimestampColumn + "' the correct aggregation field?");
                Instant instant = null;
                return instant;
            }
            Instant maxDate = Instant.ofEpochMilli((long)maxAggValue);
            LOG.fine(this.loggingPrefix + ": maxDate = " + maxDate);
            Instant instant = maxDate;
            return instant;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        finally {
            LOG.fine(this.loggingPrefix + ": getUpperTargetDate time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    long countDocuments(Instant lowerDateLimit, Instant upperDateLimit) throws ElasticsearchRelatedException {
        LOG.info(this.loggingPrefix + ": countDocuments lowerDateLimit=" + lowerDateLimit + ", upperDateLimit=" + upperDateLimit);
        long start = System.currentTimeMillis();
        try {
            SearchRequest countReq = new SearchRequest().indices(this.esIndex).source(new SearchSourceBuilder().size(0).query(QueryBuilders.rangeQuery(this.lastUpdateTimestampColumn).gte(lowerDateLimit.toEpochMilli()).lte(upperDateLimit.toEpochMilli())));
            SearchResponse countResponse = this.es.getClient().search(countReq, RequestOptions.DEFAULT);
            long l = countResponse.getHits().getTotalHits().value;
            return l;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        finally {
            LOG.fine(this.loggingPrefix + ": countDocuments time: " + (System.currentTimeMillis() - start) + "ms");
        }
    }
}

