/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.core.replicator.ElasticsearchRecordID;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashMap;

class RecordData {
    private final LinkedHashMap<String, Object> idColumnNamesAndValues;
    private final String recordId;
    private final Date lastUpdateDate;

    RecordData(LinkedHashMap<String, Object> idColumnNamesAndValues, Timestamp lastUpdateTimestamp) {
        this.idColumnNamesAndValues = idColumnNamesAndValues;
        this.recordId = ElasticsearchRecordID.create(idColumnNamesAndValues.values());
        this.lastUpdateDate = new Date(lastUpdateTimestamp.getTime());
    }

    RecordData(LinkedHashMap<String, Object> idColumnNamesAndValues, Date lastUpdateTimestamp) {
        this.idColumnNamesAndValues = idColumnNamesAndValues;
        this.recordId = ElasticsearchRecordID.create(idColumnNamesAndValues.values());
        this.lastUpdateDate = lastUpdateTimestamp;
    }

    public LinkedHashMap<String, Object> getIdColumnNamesAndValues() {
        return this.idColumnNamesAndValues;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public String toString() {
        return "RecordData{idColumnNamesAndValues=" + this.idColumnNamesAndValues + ", recordId='" + this.recordId + "', lastUpdateDate=" + this.lastUpdateDate + "}";
    }
}

