/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.core.replicator.ElasticsearchRecordID;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class TailSyncDatabaseHandler {
    private static final Logger LOG = Logger.getLogger(TailSyncDatabaseHandler.class.getName());
    private final String replicationJobId;
    private Connection dbConnection = null;
    private PreparedStatement selectByRangePreparedStatement = null;
    private PreparedStatement selectByIdPreparedStatement = null;
    private boolean vamWorkaroundActive = false;
    private String vamOrganizationId = null;

    TailSyncDatabaseHandler(DatabaseManager databaseManager, String dataSourceName, String replicationJobId) throws DataSourceNotFoundException, SQLException {
        this.replicationJobId = replicationJobId;
        this.dbConnection = databaseManager.getDataSource(dataSourceName).getConnection();
        this.dbConnection.setAutoCommit(false);
    }

    void destroy() {
        LOG.info(this.replicationJobId + ": destroy");
        if (this.selectByRangePreparedStatement != null) {
            try {
                this.selectByRangePreparedStatement.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, this.replicationJobId + ": Closing 'select by range' prepared statement failed.", ex);
            }
        }
        if (this.selectByIdPreparedStatement != null) {
            try {
                this.selectByIdPreparedStatement.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, this.replicationJobId + ": Closing 'select by id' prepared statement failed.", ex);
            }
        }
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, this.replicationJobId + ": Closing database connection failed.", ex);
            }
        }
    }

    void initVamWorkaround(String vamOrganizationId) {
        this.vamWorkaroundActive = vamOrganizationId != null;
        this.vamOrganizationId = vamOrganizationId;
    }

    void initSelectByIdPreparedStatement(String dbSourceTable, String[] dbIdColumnNames) throws SQLException {
        this.selectByIdPreparedStatement = this.createSelectByIdPreparedStatement(dbSourceTable, dbIdColumnNames);
    }

    void initSelectByRangePreparedStatements(String dbSourceTable, int blockSize, String[] dbIdColumnNames, String dbLastUpdateColumnName) throws SQLException {
        this.selectByRangePreparedStatement = this.createSelectByRangePreparedStatement(dbSourceTable, dbIdColumnNames, dbLastUpdateColumnName);
        this.selectByRangePreparedStatement.setFetchSize(blockSize);
    }

    private PreparedStatement createSelectByIdPreparedStatement(String dbSourceTable, String[] dbIdColumnNames) throws SQLException {
        LOG.fine("createSelectByIdPreparedStatement dbSourceTable=" + dbSourceTable + ", dbIdColumnNames=...");
        String preparedStatement = new DbQueryBuilder(this.dbConnection).withQuery("SELECT * FROM $TABLE WHERE $COLUMN = ?[ AND ]").withPlaceHolders(MapUtil.mapOf("$TABLE", dbSourceTable, "$COLUMN = ?[ AND ]", dbIdColumnNames)).build();
        LOG.info(this.replicationJobId + ": Prepared 'select by id' statement: " + preparedStatement);
        return this.dbConnection.prepareStatement(preparedStatement, 1003, 1007);
    }

    private PreparedStatement createSelectByRangePreparedStatement(String dbSourceTable, String[] dbIdColumnNames, String dbLastUpdateTimestampColumnName) throws SQLException {
        LOG.fine("createSelectByRangePreparedStatement dbSourceTable=" + dbSourceTable + ", dbIdColumnNames=..., dbLastUpdateTimestampColumnName=" + dbLastUpdateTimestampColumnName);
        ArrayList<String> columnsToSelect = new ArrayList<String>();
        columnsToSelect.addAll(Arrays.asList(dbIdColumnNames));
        columnsToSelect.add(dbLastUpdateTimestampColumnName);
        String preparedStatement = this.vamWorkaroundActive ? new DbQueryBuilder(this.dbConnection).withQuery("SELECT $COLUMNS_TO_SELECT[] FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN <= ? AND (DELETED = '0' AND ORGANIZATIONID = ?) ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$COLUMNS_TO_SELECT[]", columnsToSelect, "$TABLE", dbSourceTable, "$LASTUPDATE_COLUMN", dbLastUpdateTimestampColumnName)).build() : new DbQueryBuilder(this.dbConnection).withQuery("SELECT $COLUMNS_TO_SELECT[] FROM $TABLE WHERE $LASTUPDATE_COLUMN > ? AND $LASTUPDATE_COLUMN <= ? ORDER BY $LASTUPDATE_COLUMN ASC").withPlaceHolders(MapUtil.mapOf("$COLUMNS_TO_SELECT[]", columnsToSelect, "$TABLE", dbSourceTable, "$LASTUPDATE_COLUMN", dbLastUpdateTimestampColumnName)).build();
        LOG.info(this.replicationJobId + ": Prepared 'select by lastupdate date' statement: " + preparedStatement);
        return this.dbConnection.prepareStatement(preparedStatement, 1003, 1007);
    }

    Timestamp evaluateStartTimestamp(String dbSourceTable, String dbLastUpdateColumnName, ReplicationJob replicationJob) throws SQLException {
        LOG.fine(this.replicationJobId + ": evaluateStartTimestamp dbSourceTable=" + dbSourceTable + ", dbLastUpdateColumnName=" + dbLastUpdateColumnName + ", replicationJob=" + replicationJob);
        Timestamp startTimestamp = new Timestamp(replicationJob.getSettings().getReplicationStartDateAsDate().getTime());
        Timestamp lowerLimitTimestamp = replicationJob.getLowerLimitTimestamp(this.dbConnection, dbSourceTable, dbLastUpdateColumnName, startTimestamp);
        if (lowerLimitTimestamp != null && lowerLimitTimestamp.after(startTimestamp)) {
            LOG.info(this.replicationJobId + ": Fittet start date to oldest record found in range. Old limit: " + startTimestamp + " new limit: " + lowerLimitTimestamp);
            return lowerLimitTimestamp;
        }
        LOG.info(this.replicationJobId + ": No lower limit fitting needed");
        return startTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GetDataResult getRecordData(String[] dbIdColumnNames, String dbLastUpdateColumnName, Timestamp lowerDateLimit, Timestamp upperDateLimit) {
        LOG.info(this.replicationJobId + ": getRecordData dbIdColumnNames=..., dbLastUpdateColumnName=" + dbLastUpdateColumnName + ", lowerDateLimit=" + lowerDateLimit + ", upperDateLimit=" + upperDateLimit);
        long startTimestamp = System.currentTimeMillis();
        try {
            HashMap<String, RecordData> result = new HashMap<String, RecordData>();
            this.selectByRangePreparedStatement.setTimestamp(1, lowerDateLimit);
            this.selectByRangePreparedStatement.setTimestamp(2, upperDateLimit);
            if (this.vamWorkaroundActive) {
                this.selectByRangePreparedStatement.setString(3, this.vamOrganizationId);
            }
            try (ResultSet rs = this.selectByRangePreparedStatement.executeQuery();){
                while (rs.next()) {
                    RecordData recordData = new RecordData(ElasticsearchRecordID.getColumnNamesWithValues(rs, dbIdColumnNames), rs.getTimestamp(dbLastUpdateColumnName));
                    result.put(recordData.getRecordId(), recordData);
                }
            }
            GetDataResult getDataResult = new GetDataResult(result);
            return getDataResult;
        }
        catch (Throwable throwable) {
            GetDataResult getDataResult = new GetDataResult(throwable);
            return getDataResult;
        }
        finally {
            LOG.info(this.replicationJobId + ": getRecordData time: " + (System.currentTimeMillis() - startTimestamp) + "ms");
        }
    }

    ResultSet getDatabaseRecordByID(String[] idColumnNames, RecordData recordData) throws SQLException {
        LinkedHashMap<String, Object> idColumnNamesAndValues = recordData.getIdColumnNamesAndValues();
        for (int i = 0; i < idColumnNames.length; ++i) {
            this.selectByIdPreparedStatement.setObject(1 + i, idColumnNamesAndValues.get(idColumnNames[i]));
        }
        return this.selectByIdPreparedStatement.executeQuery();
    }
}

