/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

class TailSyncElasticsearchHandler {
    private static final Logger LOG = Logger.getLogger(TailSyncElasticsearchHandler.class.getName());
    private final ElasticsearchService es;
    private final String esIndex;
    private final String replicationJobId;

    TailSyncElasticsearchHandler(ElasticsearchService es, String esIndex, String replicationJobId) {
        this.es = es;
        this.esIndex = esIndex;
        this.replicationJobId = replicationJobId;
    }

    void destroy() {
        LOG.info(this.replicationJobId + ": destroy");
    }

    void deleteDocumentsOlderThan(String lastUpdateField, Timestamp startTimestamp) throws ElasticsearchRelatedException {
        LOG.info(this.replicationJobId + ": deleteDocumentsOlderThan lastUpdateField=" + lastUpdateField + ", startTimestamp=" + startTimestamp);
        try {
            RestHighLevelClient esClient = this.es.getClient();
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(this.esIndex).setQuery(QueryBuilders.rangeQuery(lastUpdateField).lt(startTimestamp.getTime()));
            BulkByScrollResponse dbqrsp = esClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            LOG.info(this.replicationJobId + ": Deleted " + dbqrsp.getDeleted() + " documents older than " + startTimestamp + " from '" + this.esIndex + "'");
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GetDataResult getRecordData(String[] dbIdColumnNames, String dbLastUpdateColumnName, Timestamp lowerDateLimit, Timestamp upperDateLimit) {
        LOG.info(this.replicationJobId + ": getRecordData dbIdColumnNames=..., dbLastUpdateColumnName=" + dbLastUpdateColumnName + ", lowerDateLimit=" + lowerDateLimit + ", upperDateLimit=" + upperDateLimit);
        long startTimestamp = System.currentTimeMillis();
        try {
            HashMap<String, RecordData> result = new HashMap<String, RecordData>();
            RestHighLevelClient esClient = this.es.getClient();
            ArrayList<String> fieldNamesToFetch = new ArrayList<String>();
            fieldNamesToFetch.addAll(Arrays.asList(dbIdColumnNames));
            fieldNamesToFetch.add(dbLastUpdateColumnName);
            SearchRequest searchRequest = new SearchRequest().indices(this.esIndex).source(new SearchSourceBuilder().fetchSource(fieldNamesToFetch.toArray(new String[0]), null).size(10000).query(QueryBuilders.rangeQuery(dbLastUpdateColumnName).gt(lowerDateLimit.getTime()).lte(upperDateLimit.getTime()))).scroll(new TimeValue(60000L));
            SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            do {
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    Map<String, Object> source = hit.getSourceAsMap();
                    LinkedHashMap<String, Object> idColumnNamesAndValues = new LinkedHashMap<String, Object>();
                    for (String columnName : dbIdColumnNames) {
                        idColumnNamesAndValues.put(columnName, source.get(columnName));
                    }
                    Object lastUpdateColumnValueObject = source.get(dbLastUpdateColumnName);
                    if (lastUpdateColumnValueObject instanceof String) {
                        Calendar calendar = DatatypeConverter.parseDateTime((String)((String)lastUpdateColumnValueObject));
                        RecordData recordData = new RecordData(idColumnNamesAndValues, calendar.getTime());
                        result.put(recordData.getRecordId(), recordData);
                        continue;
                    }
                    LOG.log(Level.SEVERE, this.replicationJobId + ": Unhandled type of lastUpdateColumnValueObject (" + lastUpdateColumnValueObject + "):" + lastUpdateColumnValueObject.getClass().getName());
                }
            } while ((searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            this.es.releaseScrollId(searchResponse);
            GetDataResult getDataResult = new GetDataResult(result);
            return getDataResult;
        }
        catch (IOException | ElasticsearchException ex) {
            GetDataResult getDataResult = new GetDataResult(ex);
            return getDataResult;
        }
        catch (Throwable throwable) {
            GetDataResult getDataResult = new GetDataResult(throwable);
            return getDataResult;
        }
        finally {
            LOG.info(this.replicationJobId + ": getRecordData time: " + (System.currentTimeMillis() - startTimestamp) + "ms");
        }
    }
}

