/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.jaxrs.impl.NewCookieHeaderProvider;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;

public class BpcNewCookieHeaderProvider
extends NewCookieHeaderProvider {
    private static final Logger LOG = Logger.getLogger(BpcNewCookieHeaderProvider.class.getName());
    public static final String SAME_SITE_NONE = "__SAME_SITE_NONE__";
    public static final String SAME_SITE_LAX = "__SAME_SITE_LAX__";
    public static final String SAME_SITE_STRICT = "__SAME_SITE_STRICT__";

    private static void setHeaderProviderForNewCookieClass(NewCookieHeaderProvider headerProvider) throws NoSuchFieldException, IllegalAccessException {
        Field headerProvidersField = RuntimeDelegateImpl.class.getDeclaredField("headerProviders");
        headerProvidersField.setAccessible(true);
        RuntimeDelegate runtimeDelegate = RuntimeDelegate.getInstance();
        RuntimeDelegateImpl runtimeDelegateImpl = (RuntimeDelegateImpl)runtimeDelegate;
        Map headerProviders = (Map)headerProvidersField.get(runtimeDelegateImpl);
        headerProviders.put(NewCookie.class, headerProvider);
    }

    public static void setAsUglyWorkaround() {
        try {
            BpcNewCookieHeaderProvider.setHeaderProviderForNewCookieClass(new BpcNewCookieHeaderProvider());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to enable the BPC specific 'NewCookieHeaderProvider' to set the 'SameSite' attribute to cookies.", ex);
        }
    }

    public static void removeUglyWorkaround() {
        try {
            BpcNewCookieHeaderProvider.setHeaderProviderForNewCookieClass(new NewCookieHeaderProvider());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to restore the original 'NewCookieHeaderProvider'.", ex);
        }
    }

    public String toString(NewCookie value) {
        String comment = value.getComment();
        if (!StringUtil.isNullOrEmpty(comment)) {
            if (comment.contains(SAME_SITE_NONE)) {
                return super.toString(value) + ";SameSite=None";
            }
            if (comment.contains(SAME_SITE_LAX)) {
                return super.toString(value) + ";SameSite=Lax";
            }
            if (comment.contains(SAME_SITE_STRICT)) {
                return super.toString(value) + ";SameSite=Strict";
            }
        }
        return super.toString(value);
    }
}

