/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.osgi.framework.BundleContext;

@Path(value="configuration")
public class ConfigurationBackupsEndpoint {
    private static final Logger LOG = Logger.getLogger(ConfigurationBackupsEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<BackupManager> backupManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public ConfigurationBackupsEndpoint(BundleContext bundleContext) {
        LOG.info("ConfigurationBackupsEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(this.bundleContext, BackupManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_VIEW", message="Not allowed to manage backups")
    public Response getBackups(@Context HttpHeaders hh) {
        LOG.info("getBackups");
        try {
            List<BackupSnapshotInfo> snapshotInfos = this.backupManagerTracker.getService().getAllBackups();
            snapshotInfos.sort(new Comparator<BackupSnapshotInfo>(){

                @Override
                public int compare(BackupSnapshotInfo o1, BackupSnapshotInfo o2) {
                    long o2StartTime;
                    long o1StartTime = o1.getStartTimeInMillis();
                    return o1StartTime == (o2StartTime = o2.getStartTimeInMillis()) ? 0 : (o1StartTime < o2StartTime ? 1 : -1);
                }
            });
            return Response.ok(snapshotInfos).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the list of backups: " + ex.getMessage(), ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @POST
    @Path(value="/backups/create")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_CREATE", message="Not allowed to manage backups")
    public Response createBackup(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("createBackup");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().createBackup(coreModule.getBpcConfigurationIndexBackupSetting());
            UserAuditLog.info(userSession, "BackupCreated", "Backup with the snapshot name '" + snapshotInfo.getName() + "' created");
            return Response.ok((Object)snapshotInfo).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create the 'bpc-configuration' index snapshot/backup.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_VIEW", message="Not allowed to manage backups")
    public Response getBackup(@PathParam(value="snapshotName") String snapshotName, @Context HttpHeaders hh) {
        LOG.info("getBackup snapshotName=" + snapshotName);
        try {
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().getBackupInfo(snapshotName);
            return Response.ok((Object)snapshotInfo).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not get the data of the snapshot '" + snapshotName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @DELETE
    @Path(value="/backups/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_DELETE", message="Not allowed to manage backups")
    public Response deleteBackup(@PathParam(value="snapshotName") String snapshotName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteBackup snapshotName=" + snapshotName);
        try {
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().deleteBackup(snapshotName);
            if (snapshotInfo != null) {
                UserAuditLog.info(userSession, "BackupDeleted", "Backup with the snapshot name '" + snapshotInfo.getName() + "' deleted");
            }
            return Response.ok((Object)snapshotInfo).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not delete the snapshot '" + snapshotName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @PUT
    @Path(value="/backups/activate/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_ACTIVATE", message="Not allowed to manage backups")
    public Response activateBackup(@PathParam(value="snapshotName") String snapshotName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("activateBackup snapshotName=" + snapshotName);
        try {
            BackupActivatedInfo backupActivatedInfo = this.backupManagerTracker.getService().activateBackup(snapshotName);
            UserAuditLog.info(userSession, "BackupRestored", "Backup with the snapshot name '" + snapshotName + "' restored");
            return Response.ok((Object)backupActivatedInfo).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not activate the snapshot '" + snapshotName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @PUT
    @Path(value="/backups/restore/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_RESTORE", message="Not allowed to manage backups")
    public Response restoreBackup(@PathParam(value="snapshotName") String snapshotName, @QueryParam(value="index-name") String givenIndexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("restoreBackup snapshotName=" + snapshotName);
        try {
            BackupRestoredInfo backupRestoredInfo = this.backupManagerTracker.getService().restoreBackup(snapshotName, givenIndexName);
            UserAuditLog.info(userSession, "BackupRestored", "Backup with the snapshot name '" + snapshotName + "' restored to the index '" + givenIndexName + "'.");
            return Response.ok((Object)backupRestoredInfo).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not restore the snapshot '" + snapshotName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups/download/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_DOWNLOAD", message="Not allowed to manage backups")
    public Response downloadBackup(@PathParam(value="snapshotName") String snapshotName, @Context HttpHeaders hh) {
        LOG.info("downloadBackup snapshotName=" + snapshotName);
        try {
            StreamingOutput stream = this.backupManagerTracker.getService().downloadSnapshotContent(snapshotName);
            return Response.ok((Object)stream, (String)"application/json").header("Content-Disposition", (Object)("attachment; filename=\"" + snapshotName + ".json\"")).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not download the content of the snapshot '" + snapshotName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/backups/export/{snapshotName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="BACKUPS_ADMIN", right="BACKUPS_EXPORT", message="Not allowed to manage backups")
    public Response exportBpcConfiguration(@PathParam(value="snapshotName") String snapshotName, @Context HttpHeaders hh) {
        LOG.info("exportBpcConfiguration snapshotName=" + snapshotName);
        try {
            GlobalConfig bpcConfig = this.backupManagerTracker.getService().exportBpcConfiguration(snapshotName);
            return Response.ok((Object)bpcConfig).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to export the bpc-configuration of the snapshot '" + snapshotName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

