/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserFlowIdentityProvider;
import de.virtimo.bpc.api.es.BpcIndexInfo;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ModuleConfigurationNotFoundException;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotInstantiableException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.apikey.APIKey;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.exception.SettingNotFoundException;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.core.resource.response.UserSessionBasedGlobalConfigImpl;
import de.virtimo.bpc.core.resource.response.UserSessionBasedModuleConfigImpl;
import de.virtimo.bpc.core.resource.response.UserSessionBasedModuleInstanceConfigImpl;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.module.simple.SimpleSettingSerializer;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;

@Path(value="configuration")
public class ConfigurationEndpoint {
    private static final Logger LOG = Logger.getLogger(ConfigurationEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<EventManager> eventManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerTracker;
    private BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;

    public ConfigurationEndpoint(BundleContext bundleContext) {
        LOG.info("ConfigurationEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(this.bundleContext, ElasticsearchService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.elasticsearchBpcPluginManagerTracker = new BpcServicesTracker<ElasticsearchBpcPluginManager>(this.bundleContext, ElasticsearchBpcPluginManager.class);
        this.coreBundleServiceTracker = new BpcServicesTracker<CoreBundleService>(this.bundleContext, CoreBundleService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private String serializeGlobalConfig(GlobalConfig globalConfig, UserSession userSession, ModuleManager moduleManager) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setConfig(SimpleSettingSerializer.getSerializationConfig(mapper, userSession, moduleManager));
        return mapper.writeValueAsString((Object)globalConfig);
    }

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getConfiguration(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getConfiguration");
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            ElasticsearchBpcPluginManager elasticsearchBpcPluginManager = this.elasticsearchBpcPluginManagerTracker.getService();
            BpcIndexInfo fromIndex = es.getBpcIndexInfoUsingIndexAlias("bpc-configuration");
            boolean embedMetadata = userSession != null && userSession.hasRole("bpcadmin") || CoreModule.isRequestFromOtherBpcServer(hh, coreBundleConfiguration, elasticsearchBpcPluginManager);
            boolean embedDefaultConfigurations = userSession != null && userSession.hasRole("bpcadmin") || CoreModule.isRequestFromOtherBpcServer(hh, coreBundleConfiguration, elasticsearchBpcPluginManager);
            UserSessionBasedGlobalConfigImpl globalConfig = new UserSessionBasedGlobalConfigImpl(moduleManager, fromIndex, userSession, true, false, false, embedMetadata, true, embedDefaultConfigurations);
            return Response.ok((Object)this.serializeGlobalConfig(globalConfig, userSession, moduleManager)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get configuration failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/compact")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response getCompactConfiguration(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getCompactConfiguration");
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            BpcIndexInfo fromIndex = es.getBpcIndexInfoUsingIndexAlias("bpc-configuration");
            boolean embedMetadata = userSession != null && userSession.hasRole("bpcadmin");
            UserSessionBasedGlobalConfigImpl globalConfig = new UserSessionBasedGlobalConfigImpl(moduleManager, fromIndex, userSession, true, false, true, embedMetadata, false, false);
            return Response.ok((Object)this.serializeGlobalConfig(globalConfig, userSession, moduleManager)).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get configuration failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/init")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    public Response getInitConfiguration(@Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOG.info("getInitConfiguration");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            ModuleConfiguration coreModuleConfig = coreModule.getConfiguration();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            CoreBundleService coreBundleService = this.coreBundleServiceTracker.getService();
            HashMap<String, Object> settingMap = new HashMap<String, Object>();
            settingMap.put("themes_available", coreBundleService.getThemeBundles());
            settingMap.put("login_showTenant", coreModuleConfig.getSettingValue("login_showTenant").asBoolean(true));
            settingMap.put("login_tenantDefaultValue", coreModuleConfig.getSettingValue("login_tenantDefaultValue").asString(null));
            settingMap.put("theme_name", coreModuleConfig.getSettingValue("theme_name").asString(null));
            settingMap.put("login_welcomeMsg", coreModuleConfig.getSettingValue("login_welcomeMsg").asString(null));
            settingMap.put("welcomeNotification", coreModuleConfig.getSettingValue("welcomeNotification").asString(null));
            settingMap.put("login_title", coreModuleConfig.getSettingValue("login_title").asString(null));
            settingMap.put("login_showReset", coreModuleConfig.getSettingValue("login_showReset").asBoolean(false));
            settingMap.put("browser_title", coreModuleConfig.getSettingValue("browser_title").asString(null));
            settingMap.put("core_name", coreBundleConfiguration.getBpcName());
            settingMap.put("maintenanceMode_enabled", coreBundleConfiguration.isMaintenanceModeEnabled());
            settingMap.put("maintenanceMode_message", coreBundleConfiguration.getMaintenanceModeMessage());
            settingMap.put("login_defaultLanguage", coreModuleConfig.getSettingValue("login_defaultLanguage").asString(null));
            settingMap.put("login_showLanguageSelector", coreModuleConfig.getSettingValue("login_showLanguageSelector").asBoolean(true));
            settingMap.put("baseUrl", coreModuleConfig.getSettingValue("baseUrl").asString(null));
            settingMap.put("moduleUrl", coreModuleConfig.getSettingValue("moduleUrl").asString(null));
            settingMap.put("cookie_showBanner", coreModuleConfig.getSettingValue("cookie_showBanner").asBoolean(false));
            settingMap.put("cookie_bannerText", coreModuleConfig.getSettingValue("cookie_bannerText").asString(null));
            IdentityProvider identityProvider = coreModule.getIdentityProvider();
            if (identityProvider instanceof UserFlowIdentityProvider) {
                UserFlowIdentityProvider userFlowIdentityProvider = (UserFlowIdentityProvider)identityProvider;
                settingMap.put("login_redirectUrl", userFlowIdentityProvider.createAuthenticationRequestURI(req.getRequestURL().toString()));
            }
            settingMap.put("gui_favIcon", coreModuleConfig.getSettingValue("gui_favIcon").asString(null));
            return Response.ok(settingMap).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get init configuration failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/uuid/generate")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response generateUUIDs(@QueryParam(value="count") @DefaultValue(value="1") int count, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("generateUUIDs count=" + count);
        try {
            if (count < 1 || count > 1000) {
                throw new IllegalArgumentException("'count' must be in the range 1-1000");
            }
            ArrayList<String> uuids = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                uuids.add(UUIDGenerator.randomUUID());
            }
            return Response.ok(uuids).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Generation of UUIDs failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/apikey/generate")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response generateAPIKey(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("generateAPIKey");
        try {
            String apiKey = UUIDGenerator.randomUUID();
            Map<String, String> result = Map.of("apiKey", apiKey, "id", APIKey.generateId(apiKey));
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Generation of API key failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{moduleId}/{instanceType}/newInstanceId")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getNewModuleInstanceId(@PathParam(value="moduleId") String moduleId, @PathParam(value="instanceType") String instanceType, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getNewModuleInstanceId moduleId=" + moduleId);
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModule(moduleId);
            if (module == null) {
                HashSet<String> moduleIDsOfLoadedInstantiableModules = new HashSet<String>();
                Map<String, Module> loadedModules = moduleManager.getLoadedModules();
                for (Module loadedModule : loadedModules.values()) {
                    if (!(loadedModule instanceof InstantiableModule)) continue;
                    moduleIDsOfLoadedInstantiableModules.add(loadedModule.getModuleId());
                }
                throw new SystemException((ErrorCode)BpcErrorCode.MODULE_NOT_FOUND, "Please use the ID of one of the loaded and instantiable modules: ${loadedInstantiableModules}", MapUtil.mapOf("loadedInstantiableModules", StringUtil.implode(", ", moduleIDsOfLoadedInstantiableModules)));
            }
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotInstantiableException(moduleId);
            }
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            String[] instanceTypes = instantiableModule.getSupportedInstanceTypes();
            if (instanceTypes != null) {
                Set<String> its = SetUtil.setOf(instanceTypes);
                if (!its.contains(instanceType)) {
                    throw new SystemException((ErrorCode)BpcErrorCode.MODULE_NOT_FOUND, "Please use one of the instance types the module '${moduleId}' supports: ${instanceTypes}", MapUtil.mapOf("moduleId", moduleId, "instanceTypes", StringUtil.implode(", ", instanceTypes)));
                }
            } else if (!instanceType.equals("none")) {
                throw new SystemException((ErrorCode)BpcErrorCode.MODULE_NOT_FOUND, "Please use 'none' as instance type.");
            }
            long instanceId = System.currentTimeMillis();
            HashMap<String, Object> resp = new HashMap<String, Object>();
            resp.put("moduleId", moduleId);
            resp.put("instanceType", instanceType);
            resp.put("instanceId", "" + instanceId);
            return Response.ok(resp).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get new module instance id failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Response _getModuleConfiguration(String moduleId, ModuleManager moduleManager, UserSession userSession) throws ModuleNotFoundException {
        LOG.info("_getModuleConfiguration moduleId=" + moduleId + ", moduleManager=..., userSession=...");
        moduleId = this.cleanUpModuleId(moduleId);
        Module module = moduleManager.getModuleById(moduleId);
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        return Response.ok((Object)new UserSessionBasedModuleConfigImpl(module, userSession, false, true, false, true)).build();
    }

    private Response _getModuleInstanceConfiguration(String moduleId, String moduleInstanceId, ModuleManager moduleManager, UserSession userSession) throws ModuleNotFoundException, ModuleNotInstantiableException, ModuleInstanceNotFoundException, ValidationException {
        LOG.info("_getModuleInstanceConfiguration moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", moduleManager=..., userSession=...");
        moduleId = this.cleanUpModuleId(moduleId);
        Module module = moduleManager.getModuleById(moduleId);
        if (!(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId);
        }
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        ModuleInstance moduleInstance = ((InstantiableModule)module).getModuleInstanceById(moduleInstanceId);
        if (!userSession.hasUseModuleInstanceRight(moduleInstance)) {
            throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
        }
        return Response.ok((Object)new UserSessionBasedModuleInstanceConfigImpl(moduleInstance, userSession, false)).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{moduleId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getModuleConfiguration(@PathParam(value="moduleId") String moduleId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getModuleConfiguration moduleId=" + moduleId);
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            return this._getModuleConfiguration(moduleId, moduleManager, userSession);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get module configuration failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/{moduleId}/{moduleInstanceId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getModuleConfiguration(@PathParam(value="moduleId") String moduleId, @PathParam(value="moduleInstanceId") String moduleInstanceId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getModuleConfiguration moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId);
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            if ("noinstance".equalsIgnoreCase(moduleInstanceId)) {
                return this._getModuleConfiguration(moduleId, moduleManager, userSession);
            }
            return this._getModuleInstanceConfiguration(moduleId, moduleInstanceId, moduleManager, userSession);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Get module instance configuration failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Response _setModuleConfiguration(String moduleId, List<Setting> settings, boolean force, UserSession userSession, HttpHeaders hh, ModuleManager moduleManager, EventManager eventManager) throws ModuleNotFoundException, SettingException, ValidationException, ServiceNotFoundException {
        CoreModule coreModule;
        LOG.info("_setModuleConfiguration moduleId=" + moduleId + ", settings=..., force=" + force + ", userSession=..., hh=..., moduleManager=..., eventManager=...");
        moduleId = this.cleanUpModuleId(moduleId);
        if (settings == null) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No 'settings' given");
        }
        Module module = moduleManager.getModuleById(moduleId);
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        if (!userSession.hasWriteAccessToSettings(module, settings)) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to change the setting(s) of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId));
        }
        Collection<Setting> existingSettings = module.getConfiguration().getSettings().values();
        new MaskPasswords().unmaskPasswords(existingSettings, settings);
        Collection<Setting> oldSettings = module.getConfiguration().getSettingsByName(ModuleConfiguration.getSettingNames(settings));
        ArrayList<Setting> newSettings = new ArrayList<Setting>(settings);
        List<FrontendWarningException> frontendWarnings = null;
        if (!force) {
            frontendWarnings = moduleManager.validateModuleSettings(moduleId, existingSettings, settings);
        }
        if ((coreModule = (CoreModule)moduleManager.getModuleById("_core")).isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(settings)) {
            coreModule.createBpcConfigurationSnapshot(userSession);
        }
        for (Setting setting : settings) {
            setting.setModuleId(moduleId);
            setting.setInstanceId("noinstance");
            module.getConfiguration().updateSetting(setting);
        }
        UserAuditLog.info(userSession, "ModuleUpdated", "Settings of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") updated: " + StringUtil.implode(", ", ModuleConfiguration.getSettingNames(settings)), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(oldSettings), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(newSettings), null));
        eventManager.broadcast().moduleUpdated(moduleId);
        if (frontendWarnings == null || frontendWarnings.isEmpty()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity(FrontendWarningException.asWarningsResponseMap(frontendWarnings, hh)).build();
    }

    private Response _setModuleInstanceConfiguration(String moduleId, String moduleInstanceId, String instanceType, boolean force, List<Setting> settings, UserSession userSession, HttpHeaders hh, ModuleManager moduleManager, EventManager eventManager) throws ModuleNotFoundException, ModuleNotInstantiableException, LicenseException, ValidationException, ModuleInstanceCreateException, SettingException, ModuleInstanceNotFoundException, ServiceNotFoundException {
        CoreModule coreModule;
        LOG.info("setModuleInstanceConfiguration moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", force=" + force + ", settings=..., userSession=..., hh=..., moduleManager=..., eventManager=...");
        moduleId = this.cleanUpModuleId(moduleId);
        Module module = moduleManager.getModuleById(moduleId);
        if (!userSession.hasLoadModuleRight(module)) {
            throw new ModuleNotFoundException(moduleId);
        }
        if (!(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId);
        }
        InstantiableModule instantiableModule = (InstantiableModule)module;
        ModuleInstance moduleInstance = instantiableModule.getModuleInstance(moduleInstanceId);
        if (moduleInstance == null) {
            Map<String, Module> allModules = moduleManager.getAllModules();
            for (String idOfModule : allModules.keySet()) {
                if (!idOfModule.equalsIgnoreCase(moduleInstanceId)) continue;
                throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}'. The used instance ID must no be the same as a module ID.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId));
            }
        }
        if (moduleInstance == null && !userSession.hasCreateModuleInstancesRight(instantiableModule)) {
            throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}'. Access right missing.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId));
        }
        if (moduleInstance == null) {
            for (Module m : moduleManager.getLoadedModules().values()) {
                InstantiableModule im;
                if (!(m instanceof InstantiableModule) || m.getModuleId().equalsIgnoreCase(moduleId) || (im = (InstantiableModule)m).getModuleInstance(moduleInstanceId) == null) continue;
                throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}'. A '${otherModuleId}' instance uses this id already.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId, "otherModuleId", m.getModuleId()));
            }
        }
        if (moduleInstance != null && !userSession.hasUseModuleInstanceRight(moduleInstance)) {
            throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
        }
        if (moduleInstance != null && !userSession.hasWriteAccessToSettings(moduleInstance, settings)) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to change the setting(s) of instance '${instanceId}' of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId, "instanceId", moduleInstanceId));
        }
        Collection<Setting> existingSettings = null;
        if (moduleInstance != null) {
            existingSettings = moduleInstance.getConfiguration().getSettings().values();
            new MaskPasswords().unmaskPasswords(existingSettings, settings);
        }
        Collection<Setting> oldSettings = moduleInstance == null ? null : moduleInstance.getConfiguration().getSettingsByName(ModuleConfiguration.getSettingNames(settings));
        ArrayList<Setting> newSettings = new ArrayList<Setting>(settings);
        if (instanceType == null && moduleInstance != null) {
            instanceType = moduleInstance.getInstanceType();
        }
        List<FrontendWarningException> frontendWarnings = null;
        if (!force) {
            frontendWarnings = moduleManager.validateModuleInstanceSettings(moduleId, moduleInstanceId, instanceType, existingSettings, settings);
        }
        if ((coreModule = (CoreModule)moduleManager.getModuleById("_core")).isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(settings)) {
            coreModule.createBpcConfigurationSnapshot(userSession);
        }
        Response.ResponseBuilder positiveResponseBuild = Response.ok();
        if (moduleInstance == null) {
            SimpleModuleConfig instanceModuleConfiguration = new SimpleModuleConfig(settings);
            moduleInstance = instantiableModule.createModuleInstance(moduleInstanceId, instanceType, instanceModuleConfiguration);
            positiveResponseBuild.status(Response.Status.CREATED);
            UserAuditLog.info(userSession, "ModuleInstanceCreated", "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + moduleInstanceId + ") of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") created");
            instantiableModule.moduleInstanceCreated(moduleInstance);
            eventManager.broadcast().moduleInstanceCreated(moduleId, moduleInstanceId, instanceType);
        } else {
            for (Setting setting : settings) {
                setting.setModuleId(moduleId);
                setting.setInstanceId(moduleInstanceId);
                moduleInstance.getConfiguration().updateSetting(setting);
            }
            UserAuditLog.info(userSession, "ModuleInstanceUpdated", "Settings of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + moduleInstanceId + ") of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") updated: " + StringUtil.implode(", ", ModuleConfiguration.getSettingNames(settings)), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(oldSettings), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(newSettings), null));
            instantiableModule.moduleInstanceUpdated(moduleInstance);
            eventManager.broadcast().moduleInstanceUpdated(moduleId, moduleInstanceId, instanceType);
        }
        if (frontendWarnings == null || frontendWarnings.isEmpty()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity(FrontendWarningException.asWarningsResponseMap(frontendWarnings, hh)).build();
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/{moduleId}")
    @BpcUserSessionRequired
    public Response setModuleConfiguration(@PathParam(value="moduleId") String moduleId, List<SimpleSettingImpl> simpleSettings, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("setModuleConfiguration moduleId=" + moduleId);
        try {
            ArrayList<Setting> settings = new ArrayList<Setting>(simpleSettings);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            EventManager eventManager = this.eventManagerTracker.getService();
            return this._setModuleConfiguration(moduleId, settings, force, userSession, hh, moduleManager, eventManager);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Set module configuration failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/{moduleId}/{moduleInstanceId}")
    @BpcUserSessionRequired
    public Response setModuleInstanceConfiguration(@PathParam(value="moduleId") String moduleId, @PathParam(value="moduleInstanceId") String moduleInstanceId, @QueryParam(value="instanceType") String instanceType, @QueryParam(value="force") @DefaultValue(value="false") boolean force, List<SimpleSettingImpl> simpleSettings, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("setModuleInstanceConfiguration moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType);
        try {
            ArrayList<Setting> settings = new ArrayList<Setting>(simpleSettings);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            EventManager eventManager = this.eventManagerTracker.getService();
            if ("noinstance".equals(moduleInstanceId)) {
                return this._setModuleConfiguration(moduleId, settings, force, userSession, hh, moduleManager, eventManager);
            }
            return this._setModuleInstanceConfiguration(moduleId, moduleInstanceId, instanceType, force, settings, userSession, hh, moduleManager, eventManager);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Set module instance configuration failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{moduleId}/{moduleInstanceId}/settings/{settingName}")
    @BpcUserSessionRequired
    public Response deleteModuleSetting(@PathParam(value="moduleId") String moduleId, @PathParam(value="moduleInstanceId") String moduleInstanceId, @PathParam(value="settingName") String settingName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteModuleSetting moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (module instanceof InstantiableModule && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId) && !userSession.hasUseModuleInstanceRight((ModuleInstance)(module = ((InstantiableModule)module).getModuleInstanceById(moduleInstanceId)))) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            Setting targetSetting = module.getConfiguration().getSetting(settingName);
            if (!userSession.hasWriteAccessToSetting(module, targetSetting)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to delete the setting of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId));
            }
            CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
            if (coreModule.isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(Collections.singletonList(targetSetting))) {
                coreModule.createBpcConfigurationSnapshot(userSession);
            }
            this.deleteSetting(userSession, module, targetSetting);
            if (module instanceof ModuleInstance) {
                ModuleInstance moduleInstance = (ModuleInstance)module;
                moduleInstance.getParentModule().moduleInstanceUpdated(moduleInstance);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete module setting failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{moduleId}/{moduleInstanceId}/settings")
    @BpcUserSessionRequired
    public Response deleteModuleSettings(@PathParam(value="moduleId") String moduleId, @PathParam(value="moduleInstanceId") String moduleInstanceId, List<SimpleSettingImpl> simpleSettings, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteModuleSettings moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            ArrayList<Setting> settings = new ArrayList<Setting>(simpleSettings);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (module instanceof InstantiableModule && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId) && !userSession.hasUseModuleInstanceRight((ModuleInstance)(module = ((InstantiableModule)module).getModuleInstanceById(moduleInstanceId)))) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            if (!userSession.hasWriteAccessToSettings(module, settings)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "Not allowed to delete the setting(s) of module '${moduleId}'.", MapUtil.mapOf("moduleId", moduleId));
            }
            CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
            if (coreModule.isBpcConfigurationIndexBackupOnChangesEnabled() && coreModule.isBpcConfigurationIndexBackupNecessary(settings)) {
                coreModule.createBpcConfigurationSnapshot(userSession);
            }
            for (Setting setting : settings) {
                this.deleteSetting(userSession, module, setting);
            }
            if (module instanceof ModuleInstance) {
                ModuleInstance moduleInstance = (ModuleInstance)module;
                moduleInstance.getParentModule().moduleInstanceUpdated(moduleInstance);
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete module setting failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{moduleId}/{moduleInstanceId}")
    @BpcUserSessionRequired
    public Response deleteModuleInstance(@PathParam(value="moduleId") String moduleId, @PathParam(value="moduleInstanceId") String moduleInstanceId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteModuleInstance moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            EventManager eventManager = this.eventManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotInstantiableException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            ModuleInstance moduleInstance = instantiableModule.getModuleInstanceById(moduleInstanceId);
            if (!userSession.hasUseModuleInstanceRight(moduleInstance)) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            if (!userSession.hasDeleteModuleInstancesRight(moduleInstance)) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
            if (coreModule.isBpcConfigurationIndexBackupOnChangesEnabled()) {
                coreModule.createBpcConfigurationSnapshot(userSession);
            }
            moduleInstance.deleteInstance();
            UserAuditLog.info(userSession, "ModuleInstanceDeleted", "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + moduleInstanceId + ") of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") deleted");
            instantiableModule.moduleInstanceDeleted(moduleInstance);
            eventManager.broadcast().moduleInstanceDeleted(moduleId, moduleInstanceId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Delete module instance failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/test/{moduleId}/{moduleInstanceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response testModuleInstance(@PathParam(value="moduleId") String moduleId, @PathParam(value="moduleInstanceId") String moduleInstanceId, @Context UriInfo uriInfo, @Context UserSession userSession, @Context HttpHeaders hh, Map<String, Object> testData) {
        LOG.info("testModuleInstance moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId);
        try {
            moduleId = this.cleanUpModuleId(moduleId);
            testData.put("___uriInfo___", uriInfo);
            testData.put("___userSession___", userSession);
            testData.put("___httpHeaders___", hh);
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Module module = moduleManager.getModuleById(moduleId);
            if (!userSession.hasLoadModuleRight(module)) {
                throw new ModuleNotFoundException(moduleId);
            }
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotInstantiableException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            ModuleInstance moduleInstance = instantiableModule.getModuleInstanceById(moduleInstanceId);
            if (!userSession.hasUseModuleInstanceRight(moduleInstance)) {
                throw new ModuleInstanceNotFoundException(moduleId, moduleInstanceId);
            }
            moduleManager.performConnectionTest(moduleInstance, testData);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Connection testing the module instance failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/jsonschema/{moduleId}/{setting}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getJsonSchema(@PathParam(value="moduleId") String moduleId, @PathParam(value="setting") String settingName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getJsonSchema moduleId=" + moduleId + ", settingName=" + settingName);
        try {
            Module module = this.moduleManagerTracker.getService().getModuleById(moduleId);
            ModuleConfiguration defaultModuleConfiguration = module.getDefaultConfiguration();
            if (defaultModuleConfiguration == null) {
                throw new ModuleConfigurationNotFoundException("The module '${module}' does not have a default configuration.", MapUtil.mapOf("module", moduleId));
            }
            Setting setting = defaultModuleConfiguration.getSetting(settingName);
            if (setting == null) {
                throw new SettingNotFoundException(moduleId, settingName);
            }
            String jsonSchemaFile = setting.getCustomFields().getStringValue("_schema");
            if (StringUtil.isNullOrEmpty(jsonSchemaFile)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "The setting '${setting}' of module '${module} does not have a JSON schema.", MapUtil.mapOf("module", moduleId, "setting", settingName));
            }
            Map<String, Object> jsonSchema = JsonDefaultsUtil.loadJsonFileAsMap(module.getModuleBundle(), jsonSchemaFile);
            if (jsonSchema == null) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to load the JSON schema (${schema}) from setting '${setting} of module '${module}.", MapUtil.mapOf("module", moduleId, "setting", settingName, "schema", jsonSchemaFile));
            }
            return Response.ok(jsonSchema).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Getting the requested JSON schema failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/jsonschema/{moduleId}/{instanceType}/{setting}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    public Response getJsonSchema(@PathParam(value="moduleId") String moduleId, @PathParam(value="instanceType") String instanceType, @PathParam(value="setting") String settingName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getJsonSchema moduleId=" + moduleId + ", instanceType=" + instanceType + ", settingName=" + settingName);
        try {
            Module module = this.moduleManagerTracker.getService().getModuleById(moduleId);
            if (!(module instanceof InstantiableModule)) {
                throw new ModuleNotFoundException(moduleId);
            }
            InstantiableModule instantiableModule = (InstantiableModule)module;
            ModuleConfiguration defaultModuleInstanceConfiguration = instantiableModule.getDefaultInstanceConfiguration(instanceType);
            if (defaultModuleInstanceConfiguration == null) {
                throw new ModuleConfigurationNotFoundException("The instantiable module '${module}' does not have a default instance configuration.", MapUtil.mapOf("module", moduleId, "instanceType", instanceType));
            }
            Setting setting = defaultModuleInstanceConfiguration.getSetting(settingName);
            if (setting == null) {
                throw new SettingNotFoundException(moduleId, settingName);
            }
            String jsonSchemaFile = setting.getCustomFields().getStringValue("_schema");
            if (StringUtil.isNullOrEmpty(jsonSchemaFile)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "The setting '${setting}' of module '${module} and the instance type '${instanceType}' does not have a JSON schema.", MapUtil.mapOf("module", moduleId, "instanceType", instanceType, "setting", settingName));
            }
            Map<String, Object> jsonSchema = JsonDefaultsUtil.loadJsonFileAsMap(instantiableModule.getModuleBundle(), jsonSchemaFile);
            if (jsonSchema == null) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to load the JSON schema (${schema}) from setting '${setting} of module '${module} and instance type '${instanceType}'.", MapUtil.mapOf("module", moduleId, "instanceType", instanceType, "setting", settingName, "schema", jsonSchemaFile));
            }
            return Response.ok(jsonSchema).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Getting the requested JSON schema failed.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private String cleanUpModuleId(String moduleId) {
        return moduleId;
    }

    private void deleteSetting(UserSession userSession, Module module, Setting setting) throws SettingException, ServiceNotFoundException {
        LOG.log(Level.FINEST, "deleteSetting");
        String settingName = setting.getName();
        String moduleId = module.getModuleId();
        module.getConfiguration().removeSetting(setting);
        EventManager eventManager = this.eventManagerTracker.getService();
        if (!(module instanceof ModuleInstance)) {
            UserAuditLog.info(userSession, "ModuleSettingDeleted", "Setting of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") deleted: " + settingName, (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(setting)), null), null);
            eventManager.broadcast().moduleSettingDeleted(moduleId, settingName);
        } else {
            String parentModuleId = ((ModuleInstance)module).getParentModule().getModuleId();
            UserAuditLog.info(userSession, "ModuleInstanceSettingDeleted", "Setting of module instance '" + ConfigurationEndpoint.getModuleInstanceName((ModuleInstance)module) + "' (" + moduleId + ") and module '" + module.getModuleName() + "' (" + parentModuleId + ") deleted: " + settingName, (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(setting)), null), null);
            eventManager.broadcast().moduleInstanceSettingDeleted(parentModuleId, moduleId, ((ModuleInstance)module).getInstanceType(), settingName);
        }
    }

    public static String getModuleInstanceName(ModuleInstance moduleInstance) {
        try {
            return ConfigurationEndpoint.getModuleInstanceName(moduleInstance.getConfiguration());
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getModuleInstanceName(ModuleConfiguration moduleInstanceConfiguration) {
        try {
            return String.valueOf(moduleInstanceConfiguration.getSetting("module_name").getValue());
        }
        catch (Exception ex) {
            return "";
        }
    }
}

