/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.es.IndexInfo;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.ExtElasticsearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.replicator.ReindexAction;
import de.virtimo.bpc.core.replicator.ReindexActionException;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.SetUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="elastic")
public class ElasticEndpoint {
    private static final Logger LOG = Logger.getLogger(ElasticEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private BpcServicesTracker<ExtElasticsearchService> extElasticsearchServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private static final Object REINDEXING_LOCK = new Object();
    private final Map<String, String> currentlyReindexing;

    public ElasticEndpoint(BundleContext bundleContext) {
        LOG.info("ElasticEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.currentlyReindexing = new HashMap<String, String>();
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(this.bundleContext, ElasticsearchService.class);
        this.extElasticsearchServiceTracker = new BpcServicesTracker<ExtElasticsearchService>(this.bundleContext, ExtElasticsearchService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="ELASTICSEARCH_ADMIN", right="ELASTICSEARCH_LIST_INDICES", message="Not allowed to handle elasticsearch indices")
    @Path(value="/indices")
    public Response listIndices(@Context HttpHeaders hh) {
        LOG.info("listIndices");
        try {
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            Map<String, IndexInfo> indexInfos = es.getIndexInfos();
            Object object = REINDEXING_LOCK;
            synchronized (object) {
                for (String reindexSource : this.currentlyReindexing.keySet()) {
                    String reindexTarget = this.currentlyReindexing.get(reindexSource);
                    if (reindexSource != null && indexInfos.containsKey(reindexSource)) {
                        IndexInfo reindexSourceIndexInfo = indexInfos.get(reindexSource);
                        reindexSourceIndexInfo.setReindexRunning(true);
                    }
                    if (reindexTarget == null || !indexInfos.containsKey(reindexTarget)) continue;
                    IndexInfo reindexTargetIndexInfo = indexInfos.get(reindexTarget);
                    reindexTargetIndexInfo.setReindexRunning(true);
                }
            }
            return Response.ok(indexInfos.values()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @Path(value="/indices/compact")
    public Response getCompactIndicesList(@Context HttpHeaders hh) {
        LOG.info("getCompactIndicesList");
        try {
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            HashMap result = new HashMap();
            Map<String, IndexInfo> indexInfos = es.getIndexInfos();
            for (String indexName : indexInfos.keySet()) {
                IndexInfo indexInfo = indexInfos.get(indexName);
                if (!indexInfo.isInState("open") || indexInfo.isHidden()) continue;
                if (indexInfo.getAliases().isEmpty()) {
                    result.put(indexName, new HashSet());
                    continue;
                }
                for (String alias : indexInfo.getAliases()) {
                    if (result.containsKey(alias)) {
                        Set alreadySetAlternativeNames = (Set)result.get(alias);
                        alreadySetAlternativeNames.add(indexName);
                        continue;
                    }
                    HashSet<String> alternativeNames = new HashSet<String>();
                    alternativeNames.add(indexName);
                    result.put(alias, alternativeNames);
                }
            }
            ArrayList resultList = new ArrayList();
            for (Map.Entry stringSetEntry : result.entrySet()) {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("alias", stringSetEntry.getKey());
                entry.put("indices", stringSetEntry.getValue());
                resultList.add(entry);
            }
            return Response.ok(resultList).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="ELASTICSEARCH_ADMIN", right="ELASTICSEARCH_GET_MAPPING", message="Not allowed to handle elasticsearch indices")
    @Path(value="/indices/mapping/{indexName}")
    public Response getMapping(@PathParam(value="indexName") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getMapping indexName=" + indexName);
        try {
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            result.put("settings", es.getSettings(indexName));
            result.put("mappings", es.getMapping(indexName));
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    @BpcRoleOrRightRequired(role="ELASTICSEARCH_ADMIN", right="ELASTICSEARCH_DELETE_INDEX", message="Not allowed to handle elasticsearch indices")
    @Path(value="/indices/operations/{indexName}")
    public Response deleteIndex(@PathParam(value="indexName") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deleteIndex indexName=" + indexName);
        try {
            ExtElasticsearchService extElasticsearchService = this.extElasticsearchServiceTracker.getService();
            try {
                extElasticsearchService.deleteIndex(indexName, userSession);
                return Response.ok((Object)("Index " + indexName + " successfully deleted")).build();
            }
            catch (ElasticsearchRelatedException ex) {
                return Response.serverError().status(500).entity((Object)("Index " + indexName + " was not deleted")).build();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to delete the index '" + indexName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="ELASTICSEARCH_ADMIN", right="ELASTICSEARCH_REINDEX", message="Not allowed to handle elasticsearch indices")
    @Path(value="/indices/reindex/{indexName}")
    public Response getReindexIndexInfo(@PathParam(value="indexName") String indexName, @QueryParam(value="copyIndexMapping") @DefaultValue(value="true") boolean copyIndexMapping, @QueryParam(value="copyMetaData") @DefaultValue(value="true") boolean copyMetaData, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getReindexIndexInfo indexName=" + indexName + ", copyIndexMapping=" + copyIndexMapping + ", copyMetaData=" + copyMetaData);
        Object object = REINDEXING_LOCK;
        synchronized (object) {
            if (this.currentlyReindexing.containsKey(indexName)) {
                return ErrorResponse.forException(new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALREADY_STARTED, "Reindex of index '${index}' is already running.", MapUtil.mapOf("index", indexName))).usingTracker(this.errorResponseServiceTracker).languageFrom(hh).build();
            }
        }
        try {
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            LogServiceModule logServiceModule = (LogServiceModule)moduleManager.getModuleById("logservice");
            Set<String> aliasesForIndexName = es.getAliasesForIndexName(indexName);
            List<ReplicationJob> relatedReplicationJobs = replicationManager.getJobsUsingTargetIndexAliases(aliasesForIndexName);
            List<LogServiceModuleInstance> relatedLogServices = logServiceModule.getLogServicesUsingTargetIndexAliases(aliasesForIndexName);
            Map<String, ?> defaultIndexCreationSettings = es.getDefaultIndexCreationSettings();
            List defaultDynamicTemplates = es.getDefaultDynamicTemplates();
            ReindexAction reindexAction = new ReindexAction(this.bundleContext, es, indexName, copyIndexMapping, copyMetaData, false, defaultIndexCreationSettings, defaultDynamicTemplates);
            reindexAction.setRelatedReplicationJobs(relatedReplicationJobs);
            reindexAction.setRelatedLogServices(relatedLogServices);
            Object result = "";
            result = (String)result + "{";
            result = (String)result + "  \"source\": {";
            result = (String)result + "    \"settings\":" + this.mapSortedByKeysAsJsonString(this.cleanupSettingsMap(reindexAction.getSourceIndexSettings()));
            result = (String)result + "    ,";
            result = (String)result + "    \"mappings\":" + this.mapSortedByKeysAsJsonString(reindexAction.getSourceIndexMappings());
            result = (String)result + "  },";
            result = (String)result + "  \"target\": {";
            result = (String)result + "    \"settings\":" + this.mapSortedByKeysAsJsonString(reindexAction.getTargetIndexSettings());
            result = (String)result + "    ,";
            result = (String)result + "    \"mappings\":" + this.mapSortedByKeysAsJsonString(reindexAction.getTargetIndexMappings());
            result = (String)result + "  }";
            result = (String)result + "}";
            return Response.ok((Object)result).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the reindex infos of the index '" + indexName + "'.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Map<String, Object> cleanupSettingsMap(Map<String, Object> settingsMap) {
        Set<String> irrelevantSettingNamesToIgnore = SetUtil.setOf("creation_date", "max_result_window", "uuid", "version", "provided_name");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String settingName : settingsMap.keySet()) {
            if (irrelevantSettingNamesToIgnore.contains(settingName)) continue;
            result.put(settingName, settingsMap.get(settingName));
        }
        return result;
    }

    private String mapSortedByKeysAsJsonString(Map<String, ?> map) throws JsonProcessingException {
        ObjectMapper om = ObjectMapperPool.createCustomizedObjectMapper();
        om.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return om.writeValueAsString(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @BpcRoleOrRightRequired(role="ELASTICSEARCH_ADMIN", right="ELASTICSEARCH_REINDEX", message="Not allowed to handle elasticsearch indices")
    @Path(value="/indices/reindex/{indexName}")
    public Response reindexIndex(@PathParam(value="indexName") String indexName, @QueryParam(value="copyIndexMapping") @DefaultValue(value="true") boolean copyIndexMapping, @QueryParam(value="copyMetaData") @DefaultValue(value="true") boolean copyMetaData, @QueryParam(value="deleteSourceIndexAfterwards") @DefaultValue(value="false") boolean deleteSourceIndexAfterwards, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("reindexIndex indexName=" + indexName + ", copyIndexMapping=" + copyIndexMapping + ", copyMetaData=" + copyMetaData + ", deleteSourceIndexAfterwards=" + deleteSourceIndexAfterwards);
        Object object = REINDEXING_LOCK;
        synchronized (object) {
            if (this.currentlyReindexing.containsKey(indexName)) {
                return ErrorResponse.forException(new ReindexActionException((ErrorCode)CoreErrorCode.REINDEX_ACTION_ALREADY_STARTED, "Reindex of index '${index}' is already running.", MapUtil.mapOf("index", indexName))).usingTracker(this.errorResponseServiceTracker).languageFrom(hh).build();
            }
            this.currentlyReindexing.put(indexName, null);
        }
        try {
            Response response;
            block28: {
                boolean mustStopRelatedReplicationJobs;
                ElasticsearchService es = this.elasticsearchServiceTracker.getService();
                CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
                ReplicationManager replicationManager = this.replicationManagerTracker.getService();
                ModuleManager moduleManager = this.moduleManagerTracker.getService();
                LogServiceModule logServiceModule = (LogServiceModule)moduleManager.getModuleById("logservice");
                Set<String> aliasesForIndexName = es.getAliasesForIndexName(indexName);
                List<ReplicationJob> relatedReplicationJobs = replicationManager.getJobsUsingTargetIndexAliases(aliasesForIndexName);
                List<LogServiceModuleInstance> relatedLogServices = logServiceModule.getLogServicesUsingTargetIndexAliases(aliasesForIndexName);
                boolean bl = mustStopRelatedReplicationJobs = !coreBundleConfiguration.isMaintenanceModeEnabled() && replicationManager.isReplicationEnabled();
                if (mustStopRelatedReplicationJobs) {
                    for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                        replicationManager.stopReplicationJob(relatedReplicationJob.getId());
                        SystemAuditLog.info("ReplicationJobStopped", "Replication job '" + relatedReplicationJob.getId() + "' stopped. Caused by reindex action of index '" + indexName + "'.");
                    }
                }
                Map<String, ?> defaultIndexCreationSettings = es.getDefaultIndexCreationSettings();
                List defaultDynamicTemplates = es.getDefaultDynamicTemplates();
                ReindexAction reindexAction = new ReindexAction(this.bundleContext, es, indexName, copyIndexMapping, copyMetaData, deleteSourceIndexAfterwards, defaultIndexCreationSettings, defaultDynamicTemplates);
                reindexAction.setRelatedReplicationJobs(relatedReplicationJobs);
                reindexAction.setRelatedLogServices(relatedLogServices);
                response = REINDEXING_LOCK;
                synchronized (response) {
                    this.currentlyReindexing.put(indexName, reindexAction.getTargetIndexName());
                }
                try {
                    reindexAction.perform();
                    UserAuditLog.info(userSession, "ElasticsearchIndexReindexed", "Elasticsearch index '" + reindexAction.getSourceIndexName() + "' with the alias '" + reindexAction.getAliasName() + "' reindexed to '" + reindexAction.getTargetIndexName() + "'.", (Object)reindexAction.getSourceIndexName(), (Object)reindexAction.getTargetIndexName());
                    if (!mustStopRelatedReplicationJobs) break block28;
                }
                catch (Throwable throwable) {
                    if (mustStopRelatedReplicationJobs) {
                        for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                            replicationManager.startReplicationJob(relatedReplicationJob);
                            SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by reindex action of index '" + indexName + "'.");
                        }
                    }
                    throw throwable;
                }
                for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                    replicationManager.startReplicationJob(relatedReplicationJob);
                    SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by reindex action of index '" + indexName + "'.");
                }
            }
            response = Response.ok((Object)("Index " + indexName + " successfully reindexed")).build();
            return response;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to reindex the index '" + indexName + "'.", ex);
            Response response = ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
            return response;
        }
        finally {
            Object object2 = REINDEXING_LOCK;
            synchronized (object2) {
                this.currentlyReindexing.remove(indexName);
            }
        }
    }
}

