/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="replication")
public class ReplicationEndpoint {
    private static final Logger LOG = Logger.getLogger(ReplicationEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public ReplicationEndpoint(BundleContext bundleContext) {
        LOG.info("ReplicationEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/lastupdatetimestamp/{replicationJobId}")
    @BpcRoleOrRightRequired(role="REPLICATION_ADMIN", right="REPLICATION_GET_LAST_UPDATE_TIMESTAMP_ON_RESTART", message="Not allowed to get the replication job last update timestamp on restart")
    public Response getLastUpdateTimestampOnRestart(@PathParam(value="replicationJobId") String replicationJobId, @Context HttpHeaders hh) {
        LOG.info("getLastUpdateTimestampOnRestart replicationJobId=" + replicationJobId);
        try {
            ReplicationJob replicationJob = this.replicationManagerTracker.getService().getReplicationJobById(replicationJobId);
            Timestamp lastUpdateTimestampOnRestart = replicationJob.getLastUpdateTimestampOnRestart();
            return Response.ok().entity(lastUpdateTimestampOnRestart == null ? "-" : Long.valueOf(lastUpdateTimestampOnRestart.getTime())).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not get the last update timestamp on restart of the replication job with the id: " + replicationJobId, ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/lastupdatetimestamp/{replicationJobId}")
    @BpcRoleOrRightRequired(role="REPLICATION_ADMIN", right="REPLICATION_RESET_LAST_UPDATE_TIMESTAMP_ON_RESTART", message="Not allowed to reset the replication job last update timestamp on restart")
    public Response resetLastUpdateTimestampOnRestart(@PathParam(value="replicationJobId") String replicationJobId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOG.info("resetLastUpdateTimestampOnRestart replicationJobId=" + replicationJobId);
        try {
            ReplicationJob replicationJob = this.replicationManagerTracker.getService().getReplicationJobById(replicationJobId);
            replicationJob.resetLastUpdateTimestampOnRestart();
            UserAuditLog.info(userSession, "ReplicationJobRestart", "Restarted the replication job with the id: " + replicationJobId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not reset the last update timestamp on restart of the replication job with the id: " + replicationJobId, ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/{replicationJobId}/start")
    @BpcRoleOrRightRequired(role="REPLICATION_ADMIN", right="REPLICATION_FORCED_START")
    public Response forcedStartOfReplicationJob(@PathParam(value="replicationJobId") String replicationJobId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOG.info("forcedStartOfReplicationJob replicationJobId=" + replicationJobId);
        try {
            this.replicationManagerTracker.getService().forcedStartOfReplicationJob(replicationJobId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to start the replication job with the id: " + replicationJobId, ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

