/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.response.ConnectedServer;
import de.virtimo.bpc.core.es.plugin.response.ConnectedServers;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.util.MapUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="server")
public class ServerEndpoints {
    private static final Logger LOG = Logger.getLogger(ServerEndpoints.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public ServerEndpoints(BundleContext bundleContext) {
        LOG.info("ServerInfoEndpoints bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.elasticsearchBpcPluginManagerTracker = new BpcServicesTracker<ElasticsearchBpcPluginManager>(this.bundleContext, ElasticsearchBpcPluginManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="SERVER_ADMIN", right="SERVER_GET_UUIDS")
    public Response getUUIDsOfServers(@Context HttpHeaders hh) {
        LOG.info("getUUIDsOfServers");
        try {
            ElasticsearchBpcPluginManager elasticsearchBpcPluginManager = this.elasticsearchBpcPluginManagerTracker.getService();
            ConnectedServers connectedServers = elasticsearchBpcPluginManager.getConnectedServers();
            return Response.ok(connectedServers.getUUIDs()).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the UUIDs of the connected BPC servers.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{uuid}/info")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="SERVER_ADMIN", right="SERVER_GET_INFO")
    public Response getServerInfo(@PathParam(value="uuid") String serverUUID, @Context HttpHeaders hh) {
        LOG.info("getServerInfo serverUUID=" + serverUUID);
        try {
            ElasticsearchBpcPluginManager elasticsearchBpcPluginManager = this.elasticsearchBpcPluginManagerTracker.getService();
            ConnectedServer connectedServer = elasticsearchBpcPluginManager.getConnectedServers().getConnectedServerByUUID(serverUUID);
            if (connectedServer != null) {
                return Response.ok((Object)connectedServer).build();
            }
            throw new SystemException((ErrorCode)CoreErrorCode.SERVER_NOT_FOUND, "The server with the UUID '${uuid}' does not exist.", MapUtil.mapOf("uuid", serverUUID));
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the server info.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

