/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.response.ConnectedServer;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.resource.response.ActiveSessions;
import de.virtimo.bpc.core.resource.response.BpcStatusAdminImpl;
import de.virtimo.bpc.core.resource.response.BpcStatusUserImpl;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRightRequired;
import de.virtimo.bpc.util.SetUtil;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.karaf.log.core.LogService;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Path(value="status")
public class StatusEndpoint {
    private static final Logger LOG = Logger.getLogger(StatusEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerTracker;
    private BpcServicesTracker<LicenseService> licenseServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<LogService> karafLogServiceTracker;

    public StatusEndpoint(BundleContext bundleContext) {
        LOG.info("StatusEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(this.bundleContext, ElasticsearchService.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.elasticsearchBpcPluginManagerTracker = new BpcServicesTracker<ElasticsearchBpcPluginManager>(this.bundleContext, ElasticsearchBpcPluginManager.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(this.bundleContext, LicenseService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.karafLogServiceTracker = new BpcServicesTracker<LogService>(this.bundleContext, LogService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    public Response getLocalStatus(@Context HttpHeaders hh) {
        LOG.info("getLocalStatus");
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            ElasticsearchBpcPluginManager elasticsearchBpcPluginManager = this.elasticsearchBpcPluginManagerTracker.getService();
            LicenseService licenseService = this.licenseServiceTracker.getService();
            LogService karafLogService = this.karafLogServiceTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(hh);
            if (userSession != null && userSession.hasRole("bpcadmin") || CoreModule.isRequestFromOtherBpcServer(hh, coreBundleConfiguration, elasticsearchBpcPluginManager)) {
                return Response.ok((Object)new BpcStatusAdminImpl(this.bundleContext, moduleManager, coreBundleConfiguration, licenseService, clientSessionManager, replicationManager, databaseManager, es, elasticsearchBpcPluginManager, karafLogService)).build();
            }
            if (userSession != null) {
                return Response.ok((Object)new BpcStatusUserImpl(this.bundleContext, moduleManager, coreBundleConfiguration, licenseService)).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the local server status", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @Path(value="/server/{serverUUID}")
    @BpcEndpoint
    public Response getRemoteStatus(@PathParam(value="serverUUID") String serverUUID, @Context UriInfo uriInfo, @Context HttpHeaders hh) {
        Response response;
        block7: {
            LOG.info("getRemoteStatus serverUUID=" + serverUUID);
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            ElasticsearchBpcPluginManager elasticsearchBpcPluginManager = this.elasticsearchBpcPluginManagerTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(hh);
            if (userSession == null || !userSession.hasRole("bpcadmin")) {
                return Response.ok().build();
            }
            Client client = null;
            try {
                client = RestWebServiceClientFactory.newClient(false);
                ConnectedServer connectedServer = elasticsearchBpcPluginManager.getConnectedServers().getConnectedServerByUUID(serverUUID);
                String remoteServerUrl = uriInfo.getRequestUri().getScheme() + "://" + connectedServer.getServerAddress() + ":" + connectedServer.getServerHttpPort() + "/cxf/bpc-core/status";
                String remoteServerResponse = (String)client.target(new URI(remoteServerUrl)).request(new String[]{"application/json"}).header("X-Active-Active", (Object)coreBundleConfiguration.getServerUUID()).get(String.class);
                response = Response.ok((Object)remoteServerResponse).build();
                if (client == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        client.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Exception while getting the remote server status", ex);
                    return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/health")
    @BpcEndpoint
    public Response getHealth(@Context HttpHeaders hh) {
        LOG.info("getHealth");
        try {
            Response bpcStatusResponse = this.getBpcStatus(hh);
            if (bpcStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return bpcStatusResponse;
            }
            Response maintenanceStatus = this.getMaintenanceStatus(hh);
            if (maintenanceStatus.getStatus() != Response.Status.OK.getStatusCode()) {
                return maintenanceStatus;
            }
            Response elasticsearchStatusResponse = this.getElasticsearchStatus();
            if (elasticsearchStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return elasticsearchStatusResponse;
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the health state", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bpc")
    @BpcEndpoint
    public Response getBpcStatus(@Context HttpHeaders hh) {
        LOG.info("getBpcStatus");
        try {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!BpcBundleUtil.isBpcBundle(bundle)) continue;
                String state = BpcBundleUtil.getBundleState(this.bundleContext, bundle);
                if (!SetUtil.setOf("RESOLVED", "FAILURE").contains(state.toUpperCase())) continue;
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the bpc state", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/maintenance")
    @BpcEndpoint
    public Response getMaintenanceStatus(@Context HttpHeaders hh) {
        LOG.info("getMaintenanceStatus");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            if (coreModule.isMaintenanceModeEnabled()) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the maintenance mode state", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/elasticsearch")
    @BpcEndpoint
    public Response getElasticsearchStatus() {
        LOG.info("getElasticsearchStatus");
        try {
            RestHighLevelClient esClient = this.elasticsearchServiceTracker.getService().getClient();
            if (esClient == null) {
                LOG.warning("No Elasticsearch client available");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            List<Node> nodes = esClient.getLowLevelClient().getNodes();
            if (nodes == null || nodes.isEmpty()) {
                LOG.warning("No Elasticsearch nodes found.");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            ClusterHealthRequest request = new ClusterHealthRequest();
            request.timeout(TimeValue.timeValueSeconds(30L));
            ClusterHealthResponse healths = esClient.cluster().health(request, RequestOptions.DEFAULT);
            ClusterHealthStatus clusterStatus = healths.getStatus();
            LOG.info("Cluster state: " + clusterStatus);
            if (clusterStatus == ClusterHealthStatus.RED) {
                LOG.warning("Elasticsearch cluster in state RED");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Exception while querying the Elasticsearch state", ex);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @GET
    @Path(value="/sessions")
    @BpcRightRequired(right="getSessionStatus")
    @Produces(value={"application/json"})
    public Response getSessionStatus(@Context HttpHeaders hh) {
        LOG.info("getSessionStatus");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            ActiveSessions sessions = new ActiveSessions(clientSessionManager.getAllSessions());
            return Response.ok((Object)sessions).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the session status", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/clustermaster")
    @BpcEndpoint
    public Response getMasterServerStatus(@Context HttpHeaders hh) {
        LOG.info("getMasterServerStatus");
        try {
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            if (replicationManager.isReplicationEnabled()) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the master server status", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

