/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.core.auth.UserIdentification;
import de.virtimo.bpc.core.websocket.BpcWebsocket;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.api.Session;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ActiveWebsocketSession {
    private static final Logger LOG = Logger.getLogger(ActiveWebsocketSession.class.getName());
    private final InetSocketAddress remoteAddress;
    private final boolean open;
    private final UserIdentification userIdentification;

    public ActiveWebsocketSession(Session websocketSession) {
        this.remoteAddress = websocketSession.getRemoteAddress();
        this.open = websocketSession.isOpen();
        this.userIdentification = ActiveWebsocketSession.getUserIdentification(websocketSession);
    }

    @JsonProperty(value="remoteAddress")
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @JsonProperty(value="isOpen")
    public boolean isOpen() {
        return this.open;
    }

    @JsonProperty(value="remote")
    public UserIdentification getUserIdentification() {
        return this.userIdentification;
    }

    private static UserIdentification getUserIdentification(Session websocketSession) {
        BundleContext bundleContext = FrameworkUtil.getBundle(ActiveWebsocketSession.class).getBundleContext();
        BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        try {
            HttpServletRequest httpServletRequest = BpcWebsocket.getHttpServletRequest(websocketSession);
            String forwardedForHttpHeaderName = coreBundleConfigurationTracker.getService().getIpPinningCheckHttpHeaderName();
            UserIdentification userIdentification = new UserIdentification(httpServletRequest, forwardedForHttpHeaderName);
            coreBundleConfigurationTracker.close();
            return userIdentification;
        }
        catch (Throwable throwable) {
            try {
                try {
                    coreBundleConfigurationTracker.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to get the user identification of a websocket session.", ex);
                return null;
            }
        }
    }
}

