/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaskPasswords {
    private static final Logger LOG = Logger.getLogger(MaskPasswords.class.getName());
    private static final AtomicLong ID_COUNTER = new AtomicLong(System.nanoTime());
    public static final String DO_NOT_DELETE_ID = "doNotDeleteId";
    private static final String PASSWORD_MASK = "******";
    private static final String CLEARED_PASSWORD_VALUE = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Setting> maskPasswords(Collection<Setting> settings) {
        LOG.fine("maskPasswords");
        long startTimestamp = System.currentTimeMillis();
        try {
            ArrayList<Setting> result = new ArrayList<Setting>();
            for (Setting setting : settings) {
                Setting updatedSetting = null;
                String settingType = setting.getType();
                if (!StringUtil.isNullOrEmpty(settingType)) {
                    if (settingType.equalsIgnoreCase("text")) {
                        updatedSetting = this.processTextSetting(setting);
                    } else if (settingType.equalsIgnoreCase("password")) {
                        updatedSetting = this.processPasswordSetting(setting);
                    } else if (settingType.equalsIgnoreCase("json")) {
                        updatedSetting = this.processJsonSetting(setting);
                    }
                }
                if (updatedSetting != null) {
                    result.add(updatedSetting);
                    continue;
                }
                result.add(setting);
            }
            ArrayList<Setting> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not mask the passwords of the given settings. Using the unmasked settings.", ex);
        }
        finally {
            LOG.fine("maskPasswords time: " + (System.currentTimeMillis() - startTimestamp) + " ms");
        }
        return new ArrayList<Setting>(settings);
    }

    private Setting processTextSetting(Setting setting) {
        LOG.fine("processTextSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!this.isPasswordField(setting.getName())) {
            return null;
        }
        if (!this.isPasswordSet(setting.getValue())) {
            return null;
        }
        SimpleSettingImpl updatedSetting = new SimpleSettingImpl(setting);
        updatedSetting.setValue(PASSWORD_MASK);
        return updatedSetting;
    }

    private Setting processPasswordSetting(Setting setting) {
        LOG.fine("processPasswordSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!this.isPasswordSet(setting.getValue())) {
            return null;
        }
        SimpleSettingImpl updatedSetting = new SimpleSettingImpl(setting);
        updatedSetting.setValue(PASSWORD_MASK);
        return updatedSetting;
    }

    private Setting processJsonSetting(Setting setting) {
        LOG.fine("processJsonSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return setting;
        }
        Object enrichedSettingValue = this.recursiveProcessJsonValueObject(setting.getValue(), false, false, true);
        ((SimpleSettingImpl)setting).setValue(enrichedSettingValue);
        Object maskedSettingValue = this.recursiveProcessJsonValueObject(enrichedSettingValue, true, false, false);
        SimpleSettingImpl updatedSetting = new SimpleSettingImpl(setting);
        updatedSetting.setValue(maskedSettingValue);
        return updatedSetting;
    }

    private boolean isPasswordField(String value) {
        return value != null && value.toLowerCase().contains("password");
    }

    private boolean isPasswordSet(Object valueObject) {
        if (valueObject == null) {
            return false;
        }
        return !(valueObject instanceof String) || !StringUtil.isNullOrEmpty((String)valueObject);
    }

    private Object recursiveProcessJsonValueObject(Object object, boolean maskPasswords, boolean deleteMaskedPasswords, boolean addUniqueId) {
        if (object instanceof List) {
            ArrayList updatedList = new ArrayList();
            for (Object listEntry : (List)object) {
                Object updatedObject = listEntry instanceof List ? this.recursiveProcessJsonValueObject(listEntry, maskPasswords, deleteMaskedPasswords, addUniqueId) : (listEntry instanceof Map ? this.recursiveProcessJsonValueObject(listEntry, maskPasswords, deleteMaskedPasswords, addUniqueId) : listEntry);
                updatedList.add(updatedObject);
            }
            return updatedList;
        }
        if (object instanceof Map) {
            HashMap<String, Object> updatedMap = new HashMap<String, Object>();
            Map map = (Map)object;
            for (Object mapKey : map.keySet()) {
                Object updatedObject;
                Object mapValue = map.get(mapKey);
                if (mapValue instanceof List) {
                    updatedObject = this.recursiveProcessJsonValueObject(mapValue, maskPasswords, deleteMaskedPasswords, addUniqueId);
                } else if (mapValue instanceof Map) {
                    updatedObject = this.recursiveProcessJsonValueObject(mapValue, maskPasswords, deleteMaskedPasswords, addUniqueId);
                } else if (mapKey instanceof String && this.isPasswordField((String)mapKey)) {
                    updatedObject = maskPasswords ? (this.isPasswordSet(mapValue) ? PASSWORD_MASK : mapValue) : mapValue;
                    if (deleteMaskedPasswords && PASSWORD_MASK.equals(updatedObject)) {
                        updatedObject = CLEARED_PASSWORD_VALUE;
                    }
                    if (addUniqueId && updatedMap.get(DO_NOT_DELETE_ID) == null) {
                        updatedMap.put(DO_NOT_DELETE_ID, CLEARED_PASSWORD_VALUE + ID_COUNTER.getAndIncrement());
                    }
                } else {
                    updatedObject = mapValue;
                }
                updatedMap.put((String)mapKey, updatedObject);
            }
            return updatedMap;
        }
        return object;
    }

    public void unmaskPasswords(Collection<Setting> existingSettings, Collection<Setting> updatedSettings) {
        LOG.fine("unmaskPasswords existingSettings=..., updatedSettings=...");
        if (existingSettings == null || updatedSettings == null) {
            return;
        }
        for (Setting updatedSetting : updatedSettings) {
            Setting existingSetting = this.getSettingByName(updatedSetting.getName(), existingSettings);
            if (existingSetting == null) continue;
            if ("text".equalsIgnoreCase(updatedSetting.getType())) {
                this.processUpdatedTextSetting(updatedSetting, existingSetting);
                continue;
            }
            if ("password".equalsIgnoreCase(updatedSetting.getType())) {
                this.processUpdatedPasswordSetting(updatedSetting, existingSetting);
                continue;
            }
            if (!"json".equalsIgnoreCase(updatedSetting.getType())) continue;
            this.processUpdatedJsonSetting(updatedSetting, existingSetting);
        }
    }

    private Setting getSettingByName(String name, Collection<Setting> settings) {
        LOG.fine("getSettingByName '" + name + "'");
        if (name == null || settings == null) {
            return null;
        }
        for (Setting setting : settings) {
            if (!name.equals(setting.getName())) continue;
            return setting;
        }
        return null;
    }

    private void processUpdatedTextSetting(Setting updatedSetting, Setting existingSetting) {
        LOG.fine("processUpdatedTextSetting");
        if (!this.isPasswordField(updatedSetting.getName())) {
            return;
        }
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        Object valueObject = updatedSetting.getValue();
        if (!(valueObject instanceof String)) {
            return;
        }
        if (!valueObject.equals(PASSWORD_MASK)) {
            return;
        }
        SimpleSettingImpl ssi = (SimpleSettingImpl)updatedSetting;
        ssi.setValue(existingSetting.getValue());
    }

    private void processUpdatedPasswordSetting(Setting updatedSetting, Setting existingSetting) {
        LOG.fine("processUpdatedPasswordSetting updatedSetting=..., existingSetting=...");
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        Object valueObject = updatedSetting.getValue();
        if (!(valueObject instanceof String)) {
            return;
        }
        if (!valueObject.equals(PASSWORD_MASK)) {
            return;
        }
        SimpleSettingImpl ssi = (SimpleSettingImpl)updatedSetting;
        ssi.setValue(existingSetting.getValue());
    }

    private void processUpdatedJsonSetting(Setting updatedSetting, Setting existingSetting) {
        LOG.fine("processUpdatedJsonSetting");
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        Object updatedValue = this.recursiveUnmaskPasswords(updatedSetting.getValue(), existingSetting.getValue());
        SimpleSettingImpl ssi = (SimpleSettingImpl)updatedSetting;
        ssi.setValue(updatedValue);
    }

    private Object recursiveUnmaskPasswords(Object object, Object existingObject) {
        if (object instanceof List) {
            List currentList = (List)object;
            ArrayList<Object> updatedList = new ArrayList<Object>();
            for (Object listEntry : currentList) {
                Object updatedObject = listEntry instanceof List ? this.recursiveUnmaskPasswords(listEntry, existingObject) : (listEntry instanceof Map ? this.recursiveUnmaskPasswords(listEntry, existingObject) : listEntry);
                updatedList.add(updatedObject);
            }
            return updatedList;
        }
        if (object instanceof Map) {
            Map currentMap = (Map)object;
            HashMap updatedMap = new HashMap();
            for (Object mapKey : currentMap.keySet()) {
                Object updatedObject;
                Object mapValue = currentMap.get(mapKey);
                if (mapValue instanceof List) {
                    updatedObject = this.recursiveUnmaskPasswords(mapValue, existingObject);
                } else if (mapValue instanceof Map) {
                    updatedObject = this.recursiveUnmaskPasswords(mapValue, existingObject);
                } else {
                    Object realPassword;
                    String doNotDeleteId;
                    Map relatedExistingMap;
                    Object doNotDeleteIdObject;
                    updatedObject = mapValue;
                    if (mapKey instanceof String && this.isPasswordField((String)mapKey) && PASSWORD_MASK.equals(mapValue) && (doNotDeleteIdObject = currentMap.get(DO_NOT_DELETE_ID)) instanceof String && (relatedExistingMap = this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId = (String)doNotDeleteIdObject, existingObject)) != null && (realPassword = relatedExistingMap.get(mapKey)) instanceof String) {
                        updatedObject = realPassword;
                    }
                }
                updatedMap.put(mapKey, updatedObject);
            }
            return updatedMap;
        }
        return object;
    }

    private Map recursiveFindMapWithDoNotDeleteId(String doNotDeleteId, Object object) {
        if (object instanceof List) {
            Object listEntry;
            List currentList = (List)object;
            Map foundMap = null;
            Iterator iterator = currentList.iterator();
            while (iterator.hasNext() && (foundMap = (listEntry = iterator.next()) instanceof List ? this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, listEntry) : (listEntry instanceof Map ? this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, listEntry) : null)) == null) {
            }
            return foundMap;
        }
        if (object instanceof Map) {
            Map currentMap = (Map)object;
            Map foundMap = null;
            for (Object mapKey : currentMap.keySet()) {
                Object mapValue = currentMap.get(mapKey);
                if (mapValue instanceof List) {
                    foundMap = this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, mapValue);
                } else if (mapValue instanceof Map) {
                    foundMap = this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, mapValue);
                } else {
                    if (mapKey.equals(DO_NOT_DELETE_ID) && doNotDeleteId.equals(mapValue)) {
                        foundMap = currentMap;
                        break;
                    }
                    foundMap = null;
                }
                if (foundMap == null) continue;
                break;
            }
            return foundMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskedPasswords(Collection<Setting> settings) {
        LOG.fine("clearMaskedPasswords settings=...");
        long startTimestamp = System.currentTimeMillis();
        try {
            for (Setting setting : settings) {
                String settingType = setting.getType();
                if (!StringUtil.isNullOrEmpty(settingType)) {
                    if (settingType.equalsIgnoreCase("text")) {
                        this.clearMaskedPasswordFromTextSetting(setting);
                        continue;
                    }
                    if (settingType.equalsIgnoreCase("password")) {
                        this.clearMaskedPasswordFromSetting(setting);
                        continue;
                    }
                    if (!settingType.equalsIgnoreCase("json")) continue;
                    this.clearMaskedPasswordsFromJsonSetting(setting);
                    continue;
                }
                LOG.info("type is null?");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to clear masked passwords of the given settings. Using the masked settings.", ex);
        }
        finally {
            LOG.fine("clearMaskedPasswords time: " + (System.currentTimeMillis() - startTimestamp) + " ms");
        }
    }

    private void clearMaskedPasswordFromTextSetting(Setting setting) {
        LOG.fine("clearMaskedPasswordFromTextSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        if (!this.isPasswordField(setting.getName())) {
            return;
        }
        if (!PASSWORD_MASK.equals(setting.getValue())) {
            return;
        }
        ((SimpleSettingImpl)setting).setValue(CLEARED_PASSWORD_VALUE);
    }

    private void clearMaskedPasswordFromSetting(Setting setting) {
        LOG.fine("clearMaskedPasswordFromSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        if (!PASSWORD_MASK.equals(setting.getValue())) {
            return;
        }
        ((SimpleSettingImpl)setting).setValue(CLEARED_PASSWORD_VALUE);
    }

    private void clearMaskedPasswordsFromJsonSetting(Setting setting) {
        LOG.fine("clearMaskedPasswordsFromJsonSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        Object enrichedSettingValue = this.recursiveProcessJsonValueObject(setting.getValue(), false, false, true);
        ((SimpleSettingImpl)setting).setValue(enrichedSettingValue);
        Object maskedSettingValue = this.recursiveProcessJsonValueObject(enrichedSettingValue, false, true, false);
        ((SimpleSettingImpl)setting).setValue(maskedSettingValue);
    }
}

