/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.es.BpcIndexInfo;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.response.ModuleConfig;
import de.virtimo.bpc.core.resource.response.SettingsBasedModuleConfigImpl;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SettingsBasedConfigImpl
implements GlobalConfig {
    private static final Logger LOG = Logger.getLogger(SettingsBasedConfigImpl.class.getName());
    private final ModuleManager moduleManager;
    private final BpcIndexInfo fromIndex;
    private final int modelVersion;
    private final List<Setting> allSettings;

    public SettingsBasedConfigImpl(ModuleManager moduleManager, BpcIndexInfo fromIndex, int modelVersion, List<Setting> allSettings) {
        this.moduleManager = moduleManager;
        this.fromIndex = fromIndex;
        this.modelVersion = modelVersion;
        this.allSettings = allSettings;
    }

    private static Set<String> getModuleIDsFromSettings(List<Setting> allSettings) {
        HashSet<String> result = new HashSet<String>();
        if (allSettings != null) {
            for (Setting setting : allSettings) {
                String moduleId = setting.getModuleId();
                if (StringUtil.isNullOrEmpty(moduleId)) continue;
                result.add(moduleId);
            }
        }
        return result;
    }

    private static List<Setting> getSettingsOfModule(String moduleId, List<Setting> allSettings) {
        ArrayList<Setting> result = new ArrayList<Setting>();
        if (!StringUtil.isNullOrEmpty(moduleId)) {
            for (Setting setting : allSettings) {
                if (!moduleId.equals(setting.getModuleId())) continue;
                result.add(setting);
            }
        }
        return result;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getMetadata() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("modelVersion", this.modelVersion);
        result.put("fromIndex", this.fromIndex);
        return result;
    }

    @Override
    public List<ModuleConfig> getModules() {
        ArrayList<ModuleConfig> result = new ArrayList<ModuleConfig>();
        Set<String> moduleIDs = SettingsBasedConfigImpl.getModuleIDsFromSettings(this.allSettings);
        for (String moduleID : moduleIDs) {
            Module module = this.moduleManager.getModule(moduleID);
            if (module == null) {
                LOG.warning("Found settings for a module that is not available: " + moduleID);
            }
            List<Setting> moduleSettings = SettingsBasedConfigImpl.getSettingsOfModule(moduleID, this.allSettings);
            result.add(new SettingsBasedModuleConfigImpl(moduleID, module, moduleSettings));
        }
        return result;
    }
}

