/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.es.BpcIndexInfo;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.es.IndexInfo;
import de.virtimo.bpc.api.es.ManagedIndicesHandler;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.ElasticsearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.BpcIndexInfoImpl;
import de.virtimo.bpc.core.es.BpcIndexStateImpl;
import de.virtimo.bpc.core.es.ManagedIndicesHandlerImpl;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineResponse;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.core.MainResponse;
import org.elasticsearch.client.indices.CloseIndexRequest;
import org.elasticsearch.client.indices.CloseIndexResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.IndexTemplateMetadata;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.client.tasks.GetTaskRequest;
import org.elasticsearch.client.tasks.GetTaskResponse;
import org.elasticsearch.client.tasks.TaskId;
import org.elasticsearch.client.tasks.TaskSubmissionResponse;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

public class ElasticsearchServiceImpl
implements ElasticsearchService {
    private static final Logger LOG = Logger.getLogger(ElasticsearchServiceImpl.class.getName());
    private BundleContext bundleContext;
    private EventRegistration eventRegistration;
    private ElasticsearchServiceStatus status;
    private RestHighLevelClient _client;
    private long _clientRecreationsCnt = 0L;
    private String _version;
    private String esHost;
    private int esPort;
    private String esScheme;
    private String esUsername;
    private String esPassword;
    private ManagedIndicesHandler managedIndicesHandler;
    private Map<String, BpcIndexState> indexStates;
    private Map<String, ?> defaultIndexCreationSettings;
    private List defaultDynamicTemplates;
    private static final Object INDEX_STATES_LOCK = new Object();
    private static final Object CLIENT_LOCK = new Object();

    private ElasticsearchServiceImpl() {
    }

    public ElasticsearchServiceImpl(BundleContext bundleContext, CoreBundleConfiguration conf) throws UnknownHostException, ElasticsearchRelatedException {
        this(bundleContext, conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.es.host", "localhost"), conf.getSystemPropertyValueAsInt("de.virtimo.bpc.core.es.port", 9200), conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.es.scheme", "http"), conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.es.username", null), conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.es.password", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElasticsearchServiceImpl(BundleContext bundleContext, String host, int port, String scheme, String username, String password) throws ElasticsearchRelatedException {
        LOG.info("ElasticsearchServiceImpl bundleContext=" + bundleContext + ", host=" + host + ", port=" + port + ", scheme=" + scheme + ", username=" + username + ", password=...");
        this.bundleContext = bundleContext;
        this.status = ElasticsearchServiceStatus.Starting;
        try {
            this.esHost = host;
            this.esPort = port;
            this.esScheme = scheme;
            this.esUsername = username;
            this.esPassword = password;
            this.managedIndicesHandler = new ManagedIndicesHandlerImpl(bundleContext, this);
            this.indexStates = new ConcurrentHashMap<String, BpcIndexState>();
            this.defaultIndexCreationSettings = null;
            this.defaultDynamicTemplates = null;
            this._client = this.createClient();
            LOG.info("Hi Elasticsearch " + this._client.toString());
            LOG.finest("Read managed indices configuration file");
            Map<String, Object> managedIndicesConfigMap = JsonDefaultsUtil.loadJsonFileAsMap("managed_indices.json");
            this.prepareManagedIndices(managedIndicesConfigMap);
            this.eventRegistration = new EventRegistration(bundleContext);
            this.eventRegistration.forModuleUpdatedEvents("_core", "indexCreationSettings", new DefaultIndexCreationSettingsSettingUpdatedEventHandler());
            this.eventRegistration.forModuleUpdatedEvents("_core", "indexDynamicTemplates", new DefaultDynamicTemplatesSettingUpdatedEventHandler());
        }
        finally {
            this.status = ElasticsearchServiceStatus.Active;
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownService() {
        block12: {
            LOG.info("shutdownService");
            this.status = ElasticsearchServiceStatus.ShuttingDown;
            try {
                BpcServicesTracker.stopAll(this);
                this.eventRegistration.unregisterAllEventHandler();
                Object object = INDEX_STATES_LOCK;
                synchronized (object) {
                    for (BpcIndexState indexState : this.indexStates.values()) {
                        indexState.destroy();
                    }
                    this.indexStates.clear();
                }
                if (this._client == null) break block12;
                try {
                    this._client.close();
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to close the Elasticsearch client", ex);
                }
                finally {
                    this._client = null;
                    this._version = null;
                }
            }
            finally {
                this.status = ElasticsearchServiceStatus.ShutDown;
            }
        }
    }

    @Override
    public void setDefaultIndexCreationSettings(Map<String, ?> defaultIndexCreationSettings) {
        this.defaultIndexCreationSettings = defaultIndexCreationSettings;
    }

    @Override
    public Map<String, ?> getDefaultIndexCreationSettings() {
        return this.defaultIndexCreationSettings;
    }

    @Override
    public void setDefaultDynamicTemplates(List defaultDynamicTemplates) {
        this.defaultDynamicTemplates = defaultDynamicTemplates;
    }

    @Override
    public List getDefaultDynamicTemplates() {
        return this.defaultDynamicTemplates;
    }

    @Override
    public ManagedIndicesHandler getManagedIndicesHandler() {
        return this.managedIndicesHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIndexState(String indexAlias) {
        LOG.info("hasIndexState indexAlias=" + indexAlias);
        Object object = INDEX_STATES_LOCK;
        synchronized (object) {
            return this.indexStates.get(indexAlias) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BpcIndexState getIndexState(String indexAlias) {
        LOG.info("getIndexState indexAlias=" + indexAlias);
        Object object = INDEX_STATES_LOCK;
        synchronized (object) {
            BpcIndexState indexState = this.indexStates.get(indexAlias);
            if (indexState == null) {
                indexState = new BpcIndexStateImpl(this, indexAlias);
                this.indexStates.put(indexAlias, indexState);
            }
            return indexState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestHighLevelClient createClient() {
        LOG.info("createClient");
        try {
            RestClientBuilder restClientBuilder = RestClient.builder(new HttpHost(this.esHost, this.esPort, this.esScheme));
            if (this.esUsername != null && this.esPassword != null) {
                final BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.esUsername, this.esPassword));
                restClientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                    @Override
                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                    }
                });
            }
            if ("https".equalsIgnoreCase(this.esScheme)) {
                try {
                    final SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(BpcTrustStore.getInstance().getTrustStore(this.bundleContext), null).build();
                    restClientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                        @Override
                        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                            return httpClientBuilder.setSSLContext(sslContext);
                        }
                    });
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to set the pax web related truststore to the Elasticsearch client.", ex);
                }
            }
            RestHighLevelClient restHighLevelClient = new RestHighLevelClient(restClientBuilder);
            try {
                MainResponse infoResponse = restHighLevelClient.info(RequestOptions.DEFAULT);
                this._version = infoResponse.getVersion().getNumber();
            }
            catch (Exception exception) {
                // empty catch block
            }
            RestHighLevelClient restHighLevelClient2 = restHighLevelClient;
            return restHighLevelClient2;
        }
        finally {
            ++this._clientRecreationsCnt;
        }
    }

    private boolean isIOReactorStopped(RestHighLevelClient client) {
        LOG.fine("isIOReactorStopped client=" + client);
        try {
            DefaultConnectingIOReactor ioreactor;
            IOReactorStatus ioReactorStatus;
            RestClient lowLevelClient = client.getLowLevelClient();
            Field clientField = RestClient.class.getDeclaredField("client");
            clientField.setAccessible(true);
            Object clientFieldValue = clientField.get(lowLevelClient);
            Field connmgrField = clientFieldValue.getClass().getDeclaredField("connmgr");
            connmgrField.setAccessible(true);
            Object connmgrFieldValue = connmgrField.get(clientFieldValue);
            Field ioreactorField = connmgrFieldValue.getClass().getDeclaredField("ioreactor");
            ioreactorField.setAccessible(true);
            Object ioreactorFieldValue = ioreactorField.get(connmgrFieldValue);
            if (ioreactorFieldValue instanceof DefaultConnectingIOReactor && ((ioReactorStatus = (ioreactor = (DefaultConnectingIOReactor)ioreactorFieldValue).getStatus()) == IOReactorStatus.SHUTTING_DOWN || ioReactorStatus == IOReactorStatus.SHUT_DOWN)) {
                return true;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to check if the I/O reactor of the Elasticsearch RestHighLevelClient is in status 'STOPPED'.", ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestHighLevelClient getClient() {
        LOG.fine("getClient");
        Object object = CLIENT_LOCK;
        synchronized (object) {
            if (this.status == ElasticsearchServiceStatus.Active && this._client != null && this.isIOReactorStopped(this._client)) {
                LOG.warning("Not good ... the I/O reactor status of the Elasticsearch client is in status 'STOPPED' and must be re-created. This has already been done: " + this._clientRecreationsCnt + " times");
                this._client = this.createClient();
            }
            return this._client;
        }
    }

    @Override
    public String getEsHost() {
        return this.esHost;
    }

    @Override
    public int getPort() {
        return this.esPort;
    }

    @Override
    public String getEsScheme() {
        return this.esScheme;
    }

    @Override
    public String getEsVersion() {
        return this._version;
    }

    public String getEsUsername() {
        return this.esUsername;
    }

    public String getEsPassword() {
        return this.esPassword;
    }

    @Override
    public boolean existsIndex(String indexOrAliasName) throws ElasticsearchRelatedException {
        LOG.info("existsIndex indexOrAliasName:" + indexOrAliasName);
        try {
            RestHighLevelClient client = this.getClient();
            if (client.indices().existsAlias(new GetAliasesRequest(indexOrAliasName), RequestOptions.DEFAULT)) {
                return true;
            }
            return client.indices().exists(new GetIndexRequest(indexOrAliasName), RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean createIndex(String indexName) throws ElasticsearchRelatedException {
        LOG.info("createIndex name:" + indexName);
        try {
            CreateIndexResponse createIndexResponse = this.getClient().indices().create(new CreateIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!createIndexResponse.isAcknowledged()) {
                LOG.warning("Creation of index '" + indexName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean createIndex(String indexName, Map<String, ?> settings) throws ElasticsearchRelatedException {
        LOG.info("createIndex indexName:" + indexName + ", settings:" + settings);
        try {
            CreateIndexResponse createIndexResponse = this.getClient().indices().create(new CreateIndexRequest(indexName).settings(settings), RequestOptions.DEFAULT);
            if (!createIndexResponse.isAcknowledged()) {
                LOG.warning("Creation of index '" + indexName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public String createIndex(String aliasName, Map<String, ?> settings, Map<String, Object> mappings) throws ElasticsearchRelatedException {
        LOG.fine("createIndex aliasName:" + aliasName + ", settings:" + settings + ", mappings:" + mappings);
        if (StringUtil.isNullOrEmpty(aliasName)) {
            throw new NullPointerException("An aliasName must be given.");
        }
        return this.createIndex(aliasName, null, settings, mappings);
    }

    @Override
    public String createIndex(String aliasName, String indexName, Map<String, ?> settings, Map<String, Object> mappings) throws ElasticsearchRelatedException {
        LOG.info("createIndex aliasName:" + aliasName + ", indexName:" + indexName + ", settings:" + settings + ", mappings:" + mappings);
        if (StringUtil.isNullOrEmpty(aliasName) && StringUtil.isNullOrEmpty(indexName)) {
            throw new NullPointerException("An aliasName and/or indexName must be given.");
        }
        if (StringUtil.isNullOrEmpty(indexName)) {
            indexName = this.newIndexNameForAlias(aliasName);
        }
        LOG.finest("created index name: " + indexName);
        CreateIndexRequest cir = new CreateIndexRequest(indexName);
        if (!StringUtil.isNullOrEmpty(aliasName)) {
            LOG.finest("add alias: " + aliasName);
            cir.alias(new Alias(aliasName));
        }
        if (settings != null) {
            LOG.finest("add settings");
            cir.settings(settings);
        }
        if (mappings != null) {
            LOG.finest("add mapping " + mappings);
            cir.mapping(mappings);
        }
        LOG.fine("create Index: " + Strings.toString(cir));
        try {
            this.getClient().indices().create(cir, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        return indexName;
    }

    @Override
    public Map<String, Object> getMapping(String indexName) {
        LOG.fine("getMapping indexName=" + indexName);
        try {
            return this.getMappingMetaData(indexName).sourceAsMap();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the mapping of the index '" + indexName + "'.", ex);
            return null;
        }
    }

    @Override
    public MappingMetadata getMappingMetaData(String indexName) throws ElasticsearchIndexMappingNotFoundException, ElasticsearchIndexNotFoundException, ElasticsearchRelatedException {
        try {
            GetMappingsResponse response = this.getClient().indices().getMapping(new GetMappingsRequest().indices(indexName), RequestOptions.DEFAULT);
            Map<String, MappingMetadata> mappings = response.mappings();
            if (mappings != null && !mappings.isEmpty()) {
                return mappings.values().iterator().next();
            }
            throw new ElasticsearchIndexMappingNotFoundException(indexName);
        }
        catch (ElasticsearchStatusException ex) {
            if (RestStatus.NOT_FOUND == ex.status() && ex.getMessage().contains("index_not_found_exception")) {
                throw new ElasticsearchIndexNotFoundException(indexName);
            }
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public Map<String, Object> getSettings(String indexName) {
        LOG.fine("getSettings indexName=" + indexName);
        try {
            GetSettingsResponse response = this.getClient().indices().getSettings(new GetSettingsRequest().indices(indexName), RequestOptions.DEFAULT);
            if (response != null) {
                ImmutableOpenMap<String, Settings> indexToSettings = response.getIndexToSettings();
                Settings settings = indexToSettings.get(indexName);
                try {
                    Method getAsStructuredMapMethod = settings.getClass().getDeclaredMethod("getAsStructuredMap", new Class[0]);
                    getAsStructuredMapMethod.setAccessible(true);
                    Map structuredMap = (Map)getAsStructuredMapMethod.invoke((Object)settings, new Object[0]);
                    return (Map)structuredMap.get("index");
                }
                catch (Exception exception) {}
            }
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOG.log(Level.SEVERE, "Failed to get the settings of the not existing index '" + indexName + "'.");
            } else {
                LOG.log(Level.SEVERE, "Unhandled exception in ElasticsearchServiceImpl.getSettings(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the settings of the index '" + indexName + "'.", ex);
        }
        return null;
    }

    @Override
    public Map<String, String> getFieldsTypeMapping(String index) {
        LinkedHashMap properties;
        LOG.info("getFieldsTypeMapping index=" + index);
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> map = this.getMapping(index);
        if (map != null && (properties = (LinkedHashMap)map.get("properties")) != null) {
            for (String key : properties.keySet()) {
                LinkedHashMap value = (LinkedHashMap)properties.get(key);
                String columnType = (String)value.get("type");
                if (columnType == null) continue;
                LOG.info("Elasticsearch fieldname:" + key + ", type:" + columnType);
                result.put(key, columnType);
            }
        }
        return result;
    }

    @Override
    public Set<String> getFieldNamesOfType(String index, String type) {
        LOG.info("getFieldNamesOfType index=" + index + ", type=" + type);
        HashSet<String> result = new HashSet<String>();
        Map<String, String> fieldsTypeMapping = this.getFieldsTypeMapping(index);
        for (String fieldName : fieldsTypeMapping.keySet()) {
            String fieldType = fieldsTypeMapping.get(fieldName);
            if (!fieldType.equalsIgnoreCase(type)) continue;
            result.add(fieldName);
        }
        return result;
    }

    @Override
    public boolean copyIndexMapping(String sourceIndexName, String targetIndexName) throws ElasticsearchRelatedException {
        LOG.fine("copyIndexMapping sourceIndexName:" + sourceIndexName + ", targetIndexName:" + targetIndexName);
        try {
            RestHighLevelClient client = this.getClient();
            GetMappingsResponse mappingsResponse = client.indices().getMapping(new GetMappingsRequest().indices(sourceIndexName), RequestOptions.DEFAULT);
            Map<String, MappingMetadata> mappingsByIndex = mappingsResponse.mappings();
            for (MappingMetadata mappingMetaData : mappingsByIndex.values()) {
                PutMappingRequest pmr = new PutMappingRequest(targetIndexName);
                pmr.source(mappingMetaData.sourceAsMap());
                AcknowledgedResponse putMappingResponse = client.indices().putMapping(pmr, RequestOptions.DEFAULT);
                if (putMappingResponse.isAcknowledged()) continue;
                LOG.warning("Setting the source mapping to the target index '" + targetIndexName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean hasDynamicTemplatesMapping(String indexName) {
        LOG.info("hasDynamicTemplatesMapping indexName=" + indexName);
        return this.hasDynamicTemplatesMapping(this.getMapping(indexName));
    }

    @Override
    public boolean hasDynamicTemplatesMapping(Map<String, Object> mapping) {
        return mapping != null && mapping.containsKey("dynamic_templates");
    }

    @Override
    public boolean deleteIndex(String indexName) throws ElasticsearchRelatedException {
        LOG.info("deleteIndex indexName:" + indexName);
        try {
            AcknowledgedResponse deleteIndexResponse = this.getClient().indices().delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!deleteIndexResponse.isAcknowledged()) {
                LOG.warning("Deletion of index '" + indexName + "' has not been acknowledged.");
                return false;
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() != RestStatus.NOT_FOUND) {
                LOG.log(Level.SEVERE, "Unhandled exception in ElasticsearchServiceImpl.deleteIndex(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
                throw new ElasticsearchRelatedException(ex);
            }
            LOG.log(Level.INFO, "The Elasticsearch index '" + indexName + "' to delete does not exist.");
            return false;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Could not delete the Elasticsearch index '" + indexName + "'", t);
            return false;
        }
        return true;
    }

    @Override
    public boolean closeIndex(String indexName) throws ElasticsearchRelatedException {
        LOG.info("closeIndex indexName:" + indexName);
        try {
            CloseIndexResponse closeIndexResponse = this.getClient().indices().close(new CloseIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!closeIndexResponse.isAcknowledged()) {
                LOG.warning("Closing the index '" + indexName + "' has not been acknowledged");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean openIndex(String indexName) throws ElasticsearchRelatedException {
        LOG.info("openIndex indexName:" + indexName);
        try {
            OpenIndexResponse openIndexResponse = this.getClient().indices().open(new OpenIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!openIndexResponse.isAcknowledged()) {
                LOG.warning("Opening the index '" + indexName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public String newIndexNameForAlias(String aliasName) {
        LOG.info("newIndexNameForAlias:" + aliasName);
        return aliasName + "_" + new Date().getTime();
    }

    @Override
    public String aliasFromBpcIndexName(String indexName) {
        Pattern pattern;
        Matcher matcher;
        LOG.info("aliasFromBpcIndexName:" + indexName);
        if (indexName != null && indexName.length() > 0 && (matcher = (pattern = Pattern.compile("^(.+)_\\d+$")).matcher(indexName)).find()) {
            String aliasName = matcher.group(1);
            return aliasName;
        }
        return null;
    }

    @Override
    public long getCreationTimestampOfIndexName(String aliasName, String indexName) {
        LOG.fine("getCreationTimestampOfIndexName aliasName:" + aliasName + " indexName:" + indexName);
        if (aliasName == null || indexName == null) {
            return -1L;
        }
        if (!indexName.startsWith(aliasName + "_")) {
            return -1L;
        }
        String creationTimestampString = indexName.substring(aliasName.length() + 1);
        try {
            return Long.valueOf(creationTimestampString);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not convert '" + creationTimestampString + "' to a long value.", ex);
            return -1L;
        }
    }

    @Override
    public boolean addAliasToIndex(String aliasName, String indexName) throws ElasticsearchRelatedException {
        LOG.info("addAliasToIndex alias:" + aliasName + ", index:" + indexName);
        try {
            IndicesAliasesRequest.AliasActions addAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexName).alias(aliasName);
            IndicesAliasesRequest addAliasRequest = new IndicesAliasesRequest().addAliasAction(addAliasAction);
            AcknowledgedResponse indicesAliasesResponse = this.getClient().indices().updateAliases(addAliasRequest, RequestOptions.DEFAULT);
            if (!indicesAliasesResponse.isAcknowledged()) {
                LOG.warning("Adding the alias '" + aliasName + "' to the index '" + indexName + "' has not been acknowledged");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean moveAlias(String sourceIndexName, String targetIndexName) throws ElasticsearchRelatedException {
        LOG.info("moveAlias sourceIndexName:" + sourceIndexName + ", targetIndexName:" + targetIndexName);
        Set<String> sourceIndexAliases = this.getAliasesForIndexName(sourceIndexName);
        LOG.fine("Source index aliases = " + sourceIndexAliases);
        try {
            if (!sourceIndexAliases.isEmpty()) {
                IndicesAliasesRequest moveAliasRequest = new IndicesAliasesRequest();
                for (String sourceIndexAlias : sourceIndexAliases) {
                    IndicesAliasesRequest.AliasActions addAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(targetIndexName).alias(sourceIndexAlias);
                    IndicesAliasesRequest.AliasActions removeAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(sourceIndexName).alias(sourceIndexAlias);
                    moveAliasRequest.addAliasAction(addAliasAction);
                    moveAliasRequest.addAliasAction(removeAliasAction);
                }
                AcknowledgedResponse indicesAliasesResponse = this.getClient().indices().updateAliases(moveAliasRequest, RequestOptions.DEFAULT);
                if (!indicesAliasesResponse.isAcknowledged()) {
                    LOG.warning("Alias modification has not been acknowledged. Source index:" + sourceIndexName + ", target index:" + targetIndexName);
                    return false;
                }
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean removeAlias(String indexName, String aliasName) throws ElasticsearchRelatedException {
        LOG.info("removeAlias indexName:" + indexName + ", aliasName=" + aliasName);
        try {
            IndicesAliasesRequest.AliasActions removeAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(indexName).alias(aliasName);
            IndicesAliasesRequest removeAliasRequest = new IndicesAliasesRequest().addAliasAction(removeAliasAction);
            AcknowledgedResponse indicesAliasesResponse = this.getClient().indices().updateAliases(removeAliasRequest, RequestOptions.DEFAULT);
            if (!indicesAliasesResponse.isAcknowledged()) {
                LOG.warning("Alias modification has not been acknowledged. Index:" + indexName + ", alias:" + aliasName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public Set<String> getAliasesOfAllIndices() throws ElasticsearchRelatedException {
        LOG.fine("getAliasesOfAllIndices");
        try {
            GetAliasesResponse aliasesResponseOfAllIndices = this.getClient().indices().getAlias(new GetAliasesRequest().indices("*"), RequestOptions.DEFAULT);
            HashSet<String> result = new HashSet<String>();
            Map<String, Set<AliasMetadata>> indexNamesWithAliases = aliasesResponseOfAllIndices.getAliases();
            for (String indexName : indexNamesWithAliases.keySet()) {
                Set<AliasMetadata> aliasMetadata = indexNamesWithAliases.get(indexName);
                for (AliasMetadata aliasMetadatum : aliasMetadata) {
                    result.add(aliasMetadatum.alias());
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public Set<String> getAliasesForIndexName(String indexName) throws ElasticsearchRelatedException {
        LOG.info("getAliasesForIndexName indexName:" + indexName);
        try {
            HashSet<String> result = new HashSet<String>();
            GetAliasesResponse response = this.getClient().indices().getAlias(new GetAliasesRequest().indices(indexName), RequestOptions.DEFAULT);
            for (String aliasIndexName : response.getAliases().keySet()) {
                Set<AliasMetadata> metaDatas = response.getAliases().get(aliasIndexName);
                for (AliasMetadata metaData : metaDatas) {
                    result.add(metaData.alias());
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public Set<String> getIndexNamesWithAlias(String aliasName) throws ElasticsearchRelatedException {
        LOG.info("getIndexNamesWithAlias aliasName:" + aliasName);
        try {
            GetAliasesResponse response = this.getClient().indices().getAlias(new GetAliasesRequest().aliases(aliasName), RequestOptions.DEFAULT);
            return new HashSet<String>(response.getAliases().keySet());
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public String getBpcIndexNameForAlias(String indexAlias) throws ElasticsearchRelatedException {
        LOG.info("getBpcIndexNameForAlias indexAlias:" + indexAlias);
        Set<String> indexNames = this.getIndexNamesWithAlias(indexAlias);
        if (indexNames == null || indexNames.size() == 0) {
            throw new ElasticsearchRelatedException((ErrorCode)BpcErrorCode.ELASTICSEARCH_FAILED, "The Elasticsearch alias '${indexAlias}' is probably an index and not just an alias for an index. Please fix this.", MapUtil.mapOf("indexAlias", indexAlias));
        }
        if (indexNames.size() == 1) {
            return indexNames.iterator().next();
        }
        throw new ElasticsearchRelatedException((ErrorCode)BpcErrorCode.ELASTICSEARCH_FAILED, "The Elasticsearch alias '${indexAlias}' has multiple indices assigned. Please fix this.", MapUtil.mapOf("indexAlias", indexAlias));
    }

    @Override
    @NotNull
    public List<String> getAllIndexNamesWithPrefix(String indexNamePrefix) throws ElasticsearchRelatedException {
        LOG.info("getAllIndexNamesWithPrefix indexNamePrefix:" + indexNamePrefix);
        try {
            ArrayList<String> result = new ArrayList<String>();
            GetIndexResponse response = this.getClient().indices().get(new GetIndexRequest("*"), RequestOptions.DEFAULT);
            String[] allIndexNames = response.getIndices();
            if (allIndexNames != null) {
                for (String indiceName : allIndexNames) {
                    if (indexNamePrefix != null && !indiceName.startsWith(indexNamePrefix)) continue;
                    result.add(indiceName);
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public List<String> getAllBpcIndexNamesWithAlias(String bpcAlias) throws ElasticsearchRelatedException {
        LOG.info("getAllBpcIndexNamesWithAliasPrefix bpcAlias:" + bpcAlias);
        ArrayList<String> result = new ArrayList<String>();
        for (String indexName : this.getAllIndexNamesWithPrefix(bpcAlias)) {
            String extractedAliasFromIndexName = this.aliasFromBpcIndexName(indexName);
            if (!bpcAlias.equals(extractedAliasFromIndexName) || result.contains(indexName)) continue;
            result.add(indexName);
        }
        return result;
    }

    @Override
    public void refreshIndices(String ... indexNames) throws ElasticsearchRelatedException {
        LOG.info("refreshIndices indexNames:" + Arrays.toString(indexNames));
        try {
            RefreshResponse refreshResponse = this.getClient().indices().refresh(new RefreshRequest(indexNames), RequestOptions.DEFAULT);
            LOG.info("Refresh request successful? " + (refreshResponse.getStatus() == RestStatus.OK) + ". Executed with " + refreshResponse.getSuccessfulShards() + " successful shards and " + refreshResponse.getFailedShards() + " failed shards.");
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public void flushIndices(String ... indexNames) throws ElasticsearchRelatedException {
        LOG.info("flushIndices indexNames:" + Arrays.toString(indexNames));
        try {
            FlushRequest flushRequest = new FlushRequest(indexNames).waitIfOngoing(true);
            FlushResponse flushResponse = this.getClient().indices().flush(flushRequest, RequestOptions.DEFAULT);
            LOG.info("Flush request successful? " + (flushResponse.getStatus() == RestStatus.OK) + ". Executed with " + flushResponse.getSuccessfulShards() + " successful shards and " + flushResponse.getFailedShards() + " failed shards.");
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public void reindex(String sourceIndexName, String targetIndexName, QueryBuilder filterQuery) throws ElasticsearchRelatedException {
        LOG.info("reindex sourceIndexName:" + sourceIndexName + ", targetIndexName:" + targetIndexName + ", filterQuery:" + filterQuery);
        try {
            ReindexRequest request = ((ReindexRequest)new ReindexRequest().setSourceIndices(sourceIndexName).setDestIndex(targetIndexName).setRefresh(true)).setSourceQuery(filterQuery);
            TaskSubmissionResponse reindexTaskSubmissionResponse = this.getClient().submitReindexTask(request, RequestOptions.DEFAULT);
            TaskId reindexTaskId = new TaskId(reindexTaskSubmissionResponse.getTask());
            this.waitForTaskCompletionByPollingStatus(reindexTaskId, 3000L);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (RuntimeException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public void waitForTaskCompletionByPollingStatus(TaskId taskId, long pollTimeInMillis) throws ElasticsearchRelatedException {
        LOG.info("waitForTaskCompletionByPollingStatus taskId=" + taskId + ", pollTimeInMillis=" + pollTimeInMillis);
        try {
            GetTaskRequest getTaskRequest;
            Optional<GetTaskResponse> getTaskResponse;
            do {
                this.threadSleepAndIgnoreInterruptions(pollTimeInMillis);
                getTaskRequest = new GetTaskRequest(taskId.getNodeId(), taskId.getId());
            } while ((getTaskResponse = this.getClient().tasks().get(getTaskRequest, RequestOptions.DEFAULT)).isPresent() && !getTaskResponse.get().isCompleted());
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (RuntimeException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private void threadSleepAndIgnoreInterruptions(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Ignored thread sleep interruption.", e);
        }
    }

    @Override
    public Map<String, Object> getMetaDataValues(String indexName) {
        LOG.info("getMetaDataValues indexName:" + indexName);
        Map<String, Object> mappingsMap = this.getMapping(indexName);
        if (mappingsMap != null) {
            return (Map)mappingsMap.get("_meta");
        }
        return null;
    }

    @Override
    public boolean setMetaDataValues(String indexName, Map<String, Object> values) throws ElasticsearchRelatedException {
        LOG.info("setMetaDataValues indexName=" + indexName + ", values=" + values);
        try {
            HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
            mappings.put("_meta", values);
            String mappingsAsJsonString = JsonUtil.getInstance().convertPojoToJsonString(mappings);
            LOG.info("mappingsAsJsonString = " + mappingsAsJsonString);
            PutMappingRequest request = new PutMappingRequest(indexName).source(mappingsAsJsonString, XContentType.JSON);
            AcknowledgedResponse putMappingResponse = this.getClient().indices().putMapping(request, RequestOptions.DEFAULT);
            if (!putMappingResponse.isAcknowledged()) {
                LOG.warning("Mapping update on index '" + indexName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public Object getMetaDataValue(String indexName, String propertyName) {
        LOG.info("getMetaDataValue indexName=" + indexName + ", propertyName=" + propertyName);
        Map<String, Object> props = this.getMetaDataValues(indexName);
        if (props != null) {
            return props.get(propertyName);
        }
        return null;
    }

    @Override
    public boolean setMetaDataValue(String indexName, String propertyName, Object propertyValue) throws ElasticsearchRelatedException {
        LOG.info("setMetaDataValue indexName=" + indexName + ", propertyName=" + propertyName + ", propertyValue=" + propertyValue);
        Map<String, Object> props = this.getMetaDataValues(indexName);
        if (props == null) {
            props = new HashMap<String, Object>();
        }
        props.put(propertyName, propertyValue);
        return this.setMetaDataValues(indexName, props);
    }

    @Override
    public boolean removeMetaDataValue(String indexName, String propertyName) throws ElasticsearchRelatedException {
        LOG.info("removeMetaDataValue indexName=" + indexName + ", propertyName=" + propertyName);
        Map<String, Object> props = this.getMetaDataValues(indexName);
        if (props == null) {
            return true;
        }
        props.remove(propertyName);
        return this.setMetaDataValues(indexName, props);
    }

    @Override
    public int getModelVersion(String indexName) {
        LOG.info("getModelVersion indexName:" + indexName);
        Object modelVersionObject = this.getMetaDataValue(indexName, "model_version");
        if (modelVersionObject instanceof Integer) {
            LOG.info("Found the model version '" + modelVersionObject + "' in [" + indexName + "]");
            return (Integer)modelVersionObject;
        }
        LOG.info("Did not find the model version in [" + indexName + "]. Using 1 as the version");
        return 1;
    }

    @Override
    public boolean setModelVersion(String indexName, int modelVersion) throws ElasticsearchRelatedException {
        LOG.info("setModelVersion indexName:" + indexName + ", modelVersion:" + modelVersion);
        return this.setMetaDataValue(indexName, "model_version", modelVersion);
    }

    @Override
    @NotNull
    public Set<String> getTemplateNames() throws ElasticsearchRelatedException {
        LOG.info("getTemplateNames");
        try {
            HashSet<String> result = new HashSet<String>();
            GetIndexTemplatesResponse getIndexTemplatesResponse = this.getClient().indices().getIndexTemplate(new GetIndexTemplatesRequest("*"), RequestOptions.DEFAULT);
            List<IndexTemplateMetadata> indexTemplates = getIndexTemplatesResponse.getIndexTemplates();
            for (IndexTemplateMetadata indexTemplate : indexTemplates) {
                result.add(indexTemplate.name());
            }
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public Set<String> getTemplateNamesWithPrefix(String prefix) throws ElasticsearchRelatedException {
        LOG.info("getTemplateNamesWithPrefix prefix=" + prefix);
        HashSet<String> result = new HashSet<String>();
        for (String templateName : this.getTemplateNames()) {
            if (!templateName.startsWith(prefix)) continue;
            result.add(templateName);
        }
        return result;
    }

    @Override
    public boolean deleteTemplate(String templateName) throws ElasticsearchRelatedException {
        LOG.info("deleteTemplate templateName=" + templateName);
        try {
            AcknowledgedResponse deleteIndexTemplateResponse = this.getClient().indices().deleteTemplate(new DeleteIndexTemplateRequest(templateName), RequestOptions.DEFAULT);
            if (!deleteIndexTemplateResponse.isAcknowledged()) {
                LOG.warning("Deletion of the index template '" + templateName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean createTemplate(String templateName, Map<String, Object> templateValue) throws ElasticsearchRelatedException {
        LOG.info("createTemplate templateName=" + templateName + ", templateValue=...");
        try {
            AcknowledgedResponse putIndexTemplateResponse = this.getClient().indices().putTemplate(new PutIndexTemplateRequest(templateName).source(templateValue), RequestOptions.DEFAULT);
            if (!putIndexTemplateResponse.isAcknowledged()) {
                LOG.warning("Creation of the template '" + templateName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean updateIndexSettings(String indexName, Settings.Builder settingsBuilder) throws ElasticsearchRelatedException {
        LOG.info("updateIndexSettings indexName=" + indexName + ", settingsBuilder=" + settingsBuilder);
        try {
            AcknowledgedResponse updateSettingsResponse = this.getClient().indices().putSettings(new UpdateSettingsRequest(indexName).settings(settingsBuilder), RequestOptions.DEFAULT);
            if (!updateSettingsResponse.isAcknowledged()) {
                LOG.warning("Updating the settings of the index '" + indexName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean updateIndexMapping(String indexName, Map<String, Object> mapping) throws ElasticsearchRelatedException {
        LOG.info("updateIndexMapping indexName=" + indexName + ", mapping=...");
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(indexName).source(mapping);
            AcknowledgedResponse updateMappingsResponse = this.getClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
            if (!updateMappingsResponse.isAcknowledged()) {
                LOG.warning("Updating the mappings of the index '" + indexName + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private static String getWaitTime(long startTime, long maxRetryTimeMillis) {
        return "(" + (System.currentTimeMillis() - startTime) / 1000L + " / " + maxRetryTimeMillis / 1000L + " seconds)";
    }

    @Override
    public boolean waitForElasticsearch(int waitMaxSeconds, String[] indices) throws InterruptedException {
        LOG.info("waitForElasticsearch waitMaxSeconds:" + waitMaxSeconds + ", indices:" + (indices == null ? null : Arrays.toString(indices)));
        long retryMillis = 2000L;
        long maxRetryTimeMillis = waitMaxSeconds * 1000;
        long startTimeMillis = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTimeMillis + maxRetryTimeMillis) {
            try {
                ClusterHealthRequest request = indices == null ? new ClusterHealthRequest().waitForStatus(ClusterHealthStatus.RED).timeout(TimeValue.timeValueMillis(1000L)) : new ClusterHealthRequest(indices).waitForStatus(ClusterHealthStatus.YELLOW).timeout(TimeValue.timeValueMillis(1000L));
                ClusterHealthResponse clusterHealthResponse = this.getClient().cluster().health(request, RequestOptions.DEFAULT);
                if (clusterHealthResponse.isTimedOut()) {
                    LOG.warning("Elasticsearch cannot be reached. Did get a timeout. " + ElasticsearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis));
                    Thread.sleep(retryMillis);
                    continue;
                }
                LOG.info("Elasticsearch is available!");
                return true;
            }
            catch (NoNodeAvailableException ex) {
                LOG.warning("Elasticsearch cannot be reached (host=" + this.esHost + ", port=" + this.esPort + ", scheme=" + this.esScheme + "). Still no started? " + ElasticsearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis));
                Thread.sleep(retryMillis);
            }
            catch (MasterNotDiscoveredException ex) {
                LOG.warning("Elasticsearch cannot be reached (host=" + this.esHost + ", port=" + this.esPort + ", scheme=" + this.esScheme + "). But we are very close. " + ElasticsearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis));
                Thread.sleep(retryMillis);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Elasticsearch cannot be reached (host=" + this.esHost + ", port=" + this.esPort + ", scheme=" + this.esScheme + "). Unhandled exception received. " + ElasticsearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis), ex);
                Thread.sleep(retryMillis);
            }
        }
        return false;
    }

    public String toString() {
        return "ElasticsearchServiceImpl{client=" + this._client + "}";
    }

    @Override
    public void prepareManagedIndices(Map<String, Object> managedIndicesConfigMap) throws ElasticsearchRelatedException {
        LOG.fine("prepareManagedIndices managedIndicesConfigMap=" + managedIndicesConfigMap);
        try {
            this.waitForElasticsearch(30, null);
            this.managedIndicesHandler.prepareManagedIndices(managedIndicesConfigMap);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Failed prepare managed indices", e);
        }
    }

    @Override
    public boolean releaseScrollId(SearchResponse searchResponse) {
        LOG.fine("releaseScrollId searchResponse=" + searchResponse);
        if (searchResponse != null) {
            return this.releaseScrollId(searchResponse.getScrollId());
        }
        return false;
    }

    @Override
    public boolean releaseScrollId(String scrollId) {
        LOG.fine("releaseScrollId scrollId=" + scrollId);
        if (scrollId != null) {
            try {
                ClearScrollRequest request = new ClearScrollRequest();
                request.addScrollId(scrollId);
                ClearScrollResponse clearScrollResponse = this.getClient().clearScroll(request, RequestOptions.DEFAULT);
                return clearScrollResponse.isSucceeded();
            }
            catch (Throwable t) {
                LOG.warning("Failed to release the scroll id: " + scrollId);
            }
        }
        return false;
    }

    @Override
    public Map<String, IndexInfo> getIndexInfos() throws ElasticsearchRelatedException {
        LOG.fine("getIndexInfos");
        try {
            GetAliasesResponse aliasesResponseOfAllIndices = this.getClient().indices().getAlias(new GetAliasesRequest().indices("*"), RequestOptions.DEFAULT);
            Map<String, Map<String, Object>> indexAliasWithManagedIndexConfigs = this.managedIndicesHandler.getManagedIndexConfigsFromAllBpcBackendBundles();
            HashMap<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
            List<Map<String, Object>> indexCatalog = this.getIndexCatalog();
            for (Map<String, Object> indexMetaData : indexCatalog) {
                String index = MapUtil.getValueAsString(indexMetaData, "index", null);
                String health = MapUtil.getValueAsString(indexMetaData, "health", "");
                String state = MapUtil.getValueAsString(indexMetaData, "status", "");
                long docsCountLucene = MapUtil.getValueAsLong(indexMetaData, "docs.count", -1L);
                long docsDeletedLucene = MapUtil.getValueAsLong(indexMetaData, "docs.deleted", -1L);
                long storeSizeInBytes = MapUtil.getValueAsLong(indexMetaData, "store.size", -1L);
                long primaryStoreSizeInBytes = MapUtil.getValueAsLong(indexMetaData, "pri.store.size", -1L);
                long docsCount = this.getDocsCount(index);
                Set<String> aliases = this.extractAliases(index, aliasesResponseOfAllIndices);
                boolean bpcConformIndex = this.isBpcConformIndex(index, aliases);
                boolean indexWithHiddenFlag = this.isIndexWithHiddenFlag(aliases, indexAliasWithManagedIndexConfigs);
                IndexInfo indexInfo = new IndexInfo(index);
                indexInfo.setHealth(health);
                indexInfo.setState(state);
                indexInfo.setDocsCount(docsCount);
                indexInfo.setDocsCountLucene(docsCountLucene);
                indexInfo.setDocsDeletedLucene(docsDeletedLucene);
                indexInfo.setStoreSizeInBytes(storeSizeInBytes);
                indexInfo.setPrimaryStoreSizeInBytes(primaryStoreSizeInBytes);
                indexInfo.setAliases(aliases);
                indexInfo.setBpcConform(bpcConformIndex);
                indexInfo.setHidden(indexWithHiddenFlag);
                indexInfos.put(index, indexInfo);
            }
            return indexInfos;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private Set<String> extractAliases(String indexName, GetAliasesResponse aliasesResponseOfAllIndices) {
        Map<String, Set<AliasMetadata>> indexNamesWithAliases;
        HashSet<String> result = new HashSet<String>();
        if (aliasesResponseOfAllIndices != null && (indexNamesWithAliases = aliasesResponseOfAllIndices.getAliases()) != null) {
            for (AliasMetadata aliasMetaData : indexNamesWithAliases.get(indexName)) {
                result.add(aliasMetaData.alias());
            }
        }
        return result;
    }

    private boolean isBpcConformIndex(String indexName, Set<String> aliases) {
        return aliases != null && aliases.size() == 1 && aliases.iterator().next().equals(this.aliasFromBpcIndexName(indexName));
    }

    private boolean isIndexWithHiddenFlag(Set<String> aliases, Map<String, Map<String, Object>> indexAliasWithManagedIndexConfigs) {
        for (String indexAlias : aliases) {
            Map<String, Object> managedIndexConfig;
            if (!indexAliasWithManagedIndexConfigs.containsKey(indexAlias) || !(managedIndexConfig = indexAliasWithManagedIndexConfigs.get(indexAlias)).containsKey("hidden") || !managedIndexConfig.get("hidden").equals(Boolean.TRUE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpen(String indexName) throws ElasticsearchRelatedException {
        LOG.fine("isOpen indexName=" + indexName);
        Map<String, Object> indexMetaData = this.getIndexMetaData(indexName);
        return "open".equals(indexMetaData.get("status"));
    }

    @Override
    public boolean isClosed(String indexName) throws ElasticsearchRelatedException {
        LOG.fine("isClosed indexName=" + indexName);
        Map<String, Object> indexMetaData = this.getIndexMetaData(indexName);
        return "close".equals(indexMetaData.get("status"));
    }

    private Map<String, Object> getIndexMetaData(String indexName) throws ElasticsearchRelatedException {
        Map map;
        block8: {
            InputStream inputStream = this.openElasticsearchGetEndpointAsJsonInputStream("/_cat/indices/" + indexName.trim(), null);
            try {
                ObjectMapper mapper = new ObjectMapper();
                List indexMetaDatas = (List)mapper.readValue(inputStream, List.class);
                map = (Map)indexMetaDatas.get(0);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ElasticsearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getIndexCatalog() throws ElasticsearchRelatedException {
        List list;
        block8: {
            InputStream inputStream = this.openElasticsearchGetEndpointAsJsonInputStream("/_cat/indices", Map.of("bytes", "b"));
            try {
                ObjectMapper mapper = new ObjectMapper();
                list = (List)mapper.readValue(inputStream, List.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ElasticsearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return list;
    }

    private long getDocsCount(String indexName) {
        LOG.info("getDocsCount indexName=" + indexName);
        long result = -1L;
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query(QueryBuilders.matchAllQuery());
            CountRequest countRequest = new CountRequest(indexName);
            countRequest.source(searchSourceBuilder);
            CountResponse countResponse = this.getClient().count(countRequest, RequestOptions.DEFAULT);
            if (countResponse.status() == RestStatus.OK) {
                result = countResponse.getCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Map<String, Object> getFilesystemStats() throws ElasticsearchRelatedException {
        Map map;
        block8: {
            InputStream inputStream = this.openElasticsearchGetEndpointAsJsonInputStream("/_nodes/stats/fs", null);
            try {
                ObjectMapper mapper = new ObjectMapper();
                map = (Map)mapper.readValue(inputStream, Map.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ElasticsearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getInstalledPlugins() throws ElasticsearchRelatedException {
        List list;
        block8: {
            InputStream inputStream = this.openElasticsearchGetEndpointAsJsonInputStream("/_cat/plugins", null);
            try {
                ObjectMapper mapper = new ObjectMapper();
                list = (List)mapper.readValue(inputStream, List.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ElasticsearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return list;
    }

    private InputStream openElasticsearchGetEndpointAsJsonInputStream(String endpoint, Map<String, String> additionalParameters) throws ElasticsearchRelatedException {
        try {
            Request req = new Request("GET", endpoint);
            req.addParameter("format", "json");
            if (additionalParameters != null) {
                for (String name : additionalParameters.keySet()) {
                    String value = additionalParameters.get(name);
                    req.addParameter(name, value);
                }
            }
            return this.getClient().getLowLevelClient().performRequest(req).getEntity().getContent();
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public String getAttachmentsPipelineName(String indexAlias) {
        return "bpc-attachments-" + indexAlias;
    }

    @Override
    public void prepareAttachmentsPipeline(String indexAlias) throws ElasticsearchRelatedException {
        LOG.info("prepareAttachmentsPipeline indexAlias=" + indexAlias);
        String pipelineName = this.getAttachmentsPipelineName(indexAlias);
        try {
            Set<String> binaryFields = this.getFieldNamesOfType(indexAlias, "binary");
            XContentBuilder pipelineBuilder = XContentFactory.jsonBuilder().prettyPrint();
            pipelineBuilder.startObject();
            pipelineBuilder.field("description", "BPC attachment pipeline for index '" + indexAlias + "'.");
            pipelineBuilder.startArray("processors");
            for (String binaryField : binaryFields) {
                pipelineBuilder.startObject();
                pipelineBuilder.startObject("attachment");
                pipelineBuilder.field("field", binaryField);
                pipelineBuilder.field("target_field", "bpc-attachment-" + binaryField);
                pipelineBuilder.field("ignore_missing", true);
                pipelineBuilder.endObject();
                pipelineBuilder.endObject();
            }
            pipelineBuilder.endArray();
            pipelineBuilder.endObject();
            PutPipelineRequest request = new PutPipelineRequest(pipelineName, BytesReference.bytes(pipelineBuilder), XContentType.JSON);
            AcknowledgedResponse response = this.getClient().ingest().putPipeline(request, RequestOptions.DEFAULT);
            LOG.info("prepareAttachmentsPipeline : Pipeline '" + pipelineName + "' creation acknowledged? " + response.isAcknowledged());
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean existsAttachmentsPipeline(String indexAlias) throws ElasticsearchRelatedException {
        LOG.info("existsAttachmentsPipeline indexAlias=" + indexAlias);
        if (indexAlias == null) {
            return false;
        }
        String pipelineName = this.getAttachmentsPipelineName(indexAlias);
        try {
            GetPipelineRequest getPipelineRequest = new GetPipelineRequest(pipelineName);
            GetPipelineResponse getPipelineResponse = this.getClient().ingest().getPipeline(getPipelineRequest, RequestOptions.DEFAULT);
            boolean exists = getPipelineResponse.isFound();
            LOG.info("existsAttachmentsPipeline indexAlias=" + indexAlias + " exists? " + exists);
            return exists;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public boolean deleteAttachmentsPipeline(String indexAlias) throws ElasticsearchRelatedException {
        LOG.info("deleteAttachmentsPipeline indexAlias=" + indexAlias);
        String pipelineName = this.getAttachmentsPipelineName(indexAlias);
        try {
            DeletePipelineRequest deletePipelineRequest = new DeletePipelineRequest(pipelineName);
            AcknowledgedResponse deletePipelineResponse = this.getClient().ingest().deletePipeline(deletePipelineRequest, RequestOptions.DEFAULT);
            if (!deletePipelineResponse.isAcknowledged()) {
                LOG.warning("Deleting the pipeline '" + pipelineName + "' of the index '" + indexAlias + "' has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (ElasticsearchStatusException ex) {
            if (ex.status().equals((Object)RestStatus.NOT_FOUND)) {
                LOG.info("deleteAttachmentsPipeline : Pipeline '" + pipelineName + "' does not exist!");
                return true;
            }
            throw new ElasticsearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public String formatForElasticsearch(Date dateValue) {
        if (dateValue != null) {
            return this.formatForElasticsearch(dateValue.toInstant());
        }
        return null;
    }

    @Override
    public String formatForElasticsearch(java.sql.Date dateValue) {
        if (dateValue != null) {
            return dateValue.toString();
        }
        return null;
    }

    @Override
    public String formatForElasticsearch(Timestamp timestampValue) {
        if (timestampValue != null) {
            return this.formatForElasticsearch(timestampValue.toInstant());
        }
        return null;
    }

    @Override
    public String formatForElasticsearch(Instant instantValue) {
        if (instantValue != null) {
            return XContentElasticsearchExtension.DEFAULT_FORMATTER.format(ZonedDateTime.ofInstant(instantValue, ZoneOffset.UTC));
        }
        return null;
    }

    @Override
    public boolean removeAllReadOnlyFlags() throws ElasticsearchRelatedException {
        try {
            Settings.Builder settings = Settings.builder().put("index.blocks.read_only_allow_delete", (String)null);
            AcknowledgedResponse updateSettingsResponse = this.getClient().indices().putSettings(new UpdateSettingsRequest("_all").settings(settings), RequestOptions.DEFAULT);
            if (!updateSettingsResponse.isAcknowledged()) {
                LOG.warning("Removing the read only flag of all indices has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public BpcIndexInfo getBpcIndexInfoUsingIndexName(String indexName) throws ElasticsearchRelatedException {
        if (this.existsIndex(indexName)) {
            String indexAlias = this.aliasFromBpcIndexName(indexName);
            Map<String, Object> indexSettings = this.getSettings(indexName);
            Map<String, Object> indexMappings = this.getMapping(indexName);
            return new BpcIndexInfoImpl(indexAlias, indexName, indexSettings, indexMappings);
        }
        return null;
    }

    @Override
    public BpcIndexInfo getBpcIndexInfoUsingIndexAlias(String indexAlias) throws ElasticsearchRelatedException {
        if (this.existsIndex(indexAlias)) {
            String indexName = this.getBpcIndexNameForAlias(indexAlias);
            Map<String, Object> indexSettings = this.getSettings(indexName);
            Map<String, Object> indexMappings = this.getMapping(indexName);
            return new BpcIndexInfoImpl(indexAlias, indexName, indexSettings, indexMappings);
        }
        return null;
    }

    public static enum ElasticsearchServiceStatus {
        Starting,
        Active,
        ShuttingDown,
        ShutDown;

    }

    private class DefaultIndexCreationSettingsSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultIndexCreationSettingsSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting indexCreationSettingsSetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting indexCreationSettingsSetting=...");
            ElasticsearchServiceImpl.this.setDefaultIndexCreationSettings(indexCreationSettingsSetting.getSettingValue().asMap(null));
        }
    }

    private class DefaultDynamicTemplatesSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultDynamicTemplatesSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting dynamicTemplatesSetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting dynamicTemplatesSetting=...");
            ElasticsearchServiceImpl.this.setDefaultDynamicTemplates(dynamicTemplatesSetting.getSettingValue().asList(null));
        }
    }
}

