/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.es.Broadcast;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.es.BroadcastImpl;
import de.virtimo.bpc.util.DictionaryUtil;
import java.util.Dictionary;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventManagerImpl
implements EventManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(EventManagerImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<EventAdmin> eventAdminTracker;
    private String serverUUID;

    public EventManagerImpl(BundleContext bundleContext, String serverUUID) {
        LOG.info("EventManagerImpl bundleContext=..., serverUUID=" + serverUUID);
        this.bundleContext = bundleContext;
        this.serverUUID = serverUUID;
        this.eventAdminTracker = new BpcServicesTracker<EventAdmin>(bundleContext, EventAdmin.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setServerUUID(String serverUUID) {
        this.serverUUID = serverUUID;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public void fireEvent(String topic, Dictionary properties) {
        LOG.info("fireEvent topic=" + topic + ", properties=...");
        try {
            this.eventAdminTracker.getService().postEvent(new Event(topic, properties));
        }
        catch (ServiceNotFoundException ex) {
            LOG.warning("No EventAdmin to fire an event!!!");
        }
    }

    @Override
    public void fireEvent(String topic, String propertyName, Object propertyValue) {
        LOG.info("fireEvent topic=" + topic + ", propertyName=" + propertyName + ", propertyValue=...");
        this.fireEvent(topic, DictionaryUtil.dictionaryOf(propertyName, propertyValue));
    }

    @Override
    public void fireMaintenanceModeAcknowledgedEvent(String moduleId, String handler) {
        LOG.info("fireMaintenanceModeAcknowledgedEvent moduleId=" + moduleId + ", handler=" + handler);
        this.fireEvent("de/virtimo/bpc/core/maintenanceMode/acknowledged", DictionaryUtil.dictionaryOf("moduleId", moduleId, "handler", handler));
    }

    @Override
    public Broadcast broadcast() throws ServiceNotFoundException {
        return new BroadcastImpl(this, this.serverUUID);
    }
}

