/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.api.service.ExtElasticsearchService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class ExtElasticsearchServiceImpl
implements ExtElasticsearchService,
BpcService {
    private static final Logger LOG = Logger.getLogger(ExtElasticsearchServiceImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;

    public ExtElasticsearchServiceImpl(BundleContext bundleContext) {
        LOG.info("ExtElasticsearchServiceImpl bundleContext=...");
        this.bundleContext = bundleContext;
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIndex(String indexName, Object initiator) throws ServiceNotFoundException, ElasticsearchRelatedException {
        block13: {
            LOG.info("deleteIndex indexName=" + indexName + ", initiator=...");
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            Set<String> aliasesOfIndexName = es.getAliasesForIndexName(indexName);
            List<ReplicationJob> relatedReplicationJobs = null;
            if (!coreBundleConfiguration.isMaintenanceModeEnabled() && replicationManager.isReplicationEnabled()) {
                relatedReplicationJobs = replicationManager.getJobsUsingTargetIndexAliases(aliasesOfIndexName);
                for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                    replicationManager.stopReplicationJob(relatedReplicationJob.getId());
                    SystemAuditLog.info("ReplicationJobStopped", "Replication job '" + relatedReplicationJob.getId() + "' stopped. Caused by deletion of index '" + indexName + "'.");
                }
            }
            try {
                String alias;
                es.deleteIndex(indexName);
                if (initiator instanceof String) {
                    UserAuditLog.info((String)initiator, "ElasticsearchIndexDeleted", "Elasticsearch index '" + indexName + "' deleted.");
                } else if (initiator instanceof UserSession) {
                    UserAuditLog.info((UserSession)initiator, "ElasticsearchIndexDeleted", "Elasticsearch index '" + indexName + "' deleted.");
                }
                if (aliasesOfIndexName.size() == 1 && es.existsAttachmentsPipeline(alias = aliasesOfIndexName.iterator().next())) {
                    es.deleteAttachmentsPipeline(alias);
                }
                if (aliasesOfIndexName.size() >= 1) {
                    for (String aliasOfIndexName : aliasesOfIndexName) {
                        if (!es.hasIndexState(aliasOfIndexName)) continue;
                        BpcIndexState indexState = es.getIndexState(aliasOfIndexName);
                        indexState.handleDeletedIndex(indexName);
                    }
                }
                if (relatedReplicationJobs == null) break block13;
            }
            catch (Throwable throwable) {
                if (relatedReplicationJobs != null) {
                    for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                        replicationManager.startReplicationJob(relatedReplicationJob);
                        SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by deletion of index '" + indexName + "'.");
                    }
                }
                throw throwable;
            }
            for (ReplicationJob relatedReplicationJob : relatedReplicationJobs) {
                replicationManager.startReplicationJob(relatedReplicationJob);
                SystemAuditLog.info("ReplicationJobRestarted", "Replication job '" + relatedReplicationJob.getId() + "' restarted. Caused by deletion of index '" + indexName + "'.");
            }
        }
    }
}

