/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.es.BpcIndexCreateCallable;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.es.BpcIndexStateException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.core.service.MetricsService;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import io.prometheus.client.Collector;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.framework.BundleContext;

public class MetricsServiceImpl
implements MetricsService,
BpcService {
    private static final Logger LOG = Logger.getLogger(MetricsServiceImpl.class.getName());
    public static final String INDEX_NAME = "bpc-metrics";
    private final BlockingQueue<Map<String, Object>> metricsToBeWrittenQueue = new LinkedBlockingDeque<Map<String, Object>>();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private ScheduledExecutorService metricsCollectorExecutorService;
    private ScheduledFuture<?> metricsCollectorExecutorHandle;
    private ScheduledExecutorService metricsWriterExecutorService;
    private ScheduledFuture<?> metricsWriterHandle;
    private List<CollectorWithRuntimeInfos> collectorsWithRuntimeInfos;

    public MetricsServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.collectorsWithRuntimeInfos = new ArrayList<CollectorWithRuntimeInfos>();
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.metricsCollectorExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-metrics-executor"));
        this.metricsWriterExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-metrics-writer"));
        this.metricsCollectorExecutorHandle = this.metricsCollectorExecutorService.scheduleWithFixedDelay(new MetricsCollectorRunnable(), 15L, 1L, TimeUnit.SECONDS);
        this.metricsWriterHandle = this.metricsWriterExecutorService.scheduleWithFixedDelay(new MetricsWriterRunnable(), 15L, 15L, TimeUnit.SECONDS);
        this.startMetricsIndexCleanupTask();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.stopMetricsIndexCleanupTask();
        if (this.metricsCollectorExecutorHandle != null) {
            if (this.metricsCollectorExecutorHandle.cancel(true)) {
                LOG.info("Running metrics collector cancelled");
            } else {
                LOG.warning("Failed to stop/cancel the running metrics collector");
            }
            this.metricsCollectorExecutorHandle = null;
        }
        if (this.metricsCollectorExecutorService != null) {
            try {
                this.metricsCollectorExecutorService.shutdownNow();
                this.metricsCollectorExecutorService = null;
            }
            catch (RuntimeException ex) {
                LOG.log(Level.SEVERE, "Failed to shutdown the metrics collector executor");
            }
        }
        if (this.metricsWriterHandle != null) {
            if (this.metricsWriterHandle.cancel(false)) {
                LOG.info("Running metrics writer cancelled");
            } else {
                LOG.warning("Failed to stop/cancel the running metrics writer");
            }
            this.metricsWriterHandle = null;
        }
        if (this.metricsWriterExecutorService != null) {
            try {
                this.metricsWriterExecutorService.shutdownNow();
                this.metricsWriterExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.metricsWriterExecutorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOG.log(Level.SEVERE, "Failed to shutdown the metrics writer executor");
            }
        }
        this.collectorsWithRuntimeInfos.clear();
        this.collectorsWithRuntimeInfos = null;
        BpcServicesTracker.stopAll(this);
    }

    private void startMetricsIndexCleanupTask() {
        LOG.info("startMetricsIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, "timestamp", "1 year ago", 4, TimeUnit.HOURS);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to schedule the index cleanup task for the index 'bpc-metrics'.", ex);
        }
    }

    private void stopMetricsIndexCleanupTask() {
        LOG.info("stopMetricsIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to stop/cancel the running cleanup task for the index 'bpc-metrics'.", ex);
        }
    }

    @Override
    public void registerCollector(String name, Collector collector, long collectEveryNumberOfSeconds) {
        LOG.info("registerCollector name=" + name + ", collector=" + collector + ", collectEveryNumberOfSeconds=" + collectEveryNumberOfSeconds);
        if (collector == null) {
            return;
        }
        CollectorWithRuntimeInfos existingCollectorWithRuntimeInfos = null;
        for (CollectorWithRuntimeInfos collectorWithRuntimeInfos : this.collectorsWithRuntimeInfos) {
            if (!collectorWithRuntimeInfos.isSameCollector(collector)) continue;
            existingCollectorWithRuntimeInfos = collectorWithRuntimeInfos;
            break;
        }
        if (existingCollectorWithRuntimeInfos != null) {
            this.collectorsWithRuntimeInfos.remove(existingCollectorWithRuntimeInfos);
        }
        this.collectorsWithRuntimeInfos.add(new CollectorWithRuntimeInfos(name, collector, collectEveryNumberOfSeconds));
    }

    private synchronized ElasticsearchService getElasticsearchServiceWithPreparedMetricsIndex() throws ServiceNotFoundException, ElasticsearchRelatedException, BpcIndexStateException, ModuleNotFoundException {
        LOG.info("getElasticsearchServiceWithPreparedMetricsIndex");
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        BpcIndexState metricsIndexState = es.getIndexState(INDEX_NAME);
        metricsIndexState.prepareUsing(new BpcIndexCreateCallable(){

            @Override
            public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                return es.getManagedIndicesHandler().createManagedIndex(MetricsServiceImpl.INDEX_NAME);
            }
        });
        return es;
    }

    class MetricsCollectorRunnable
    implements Runnable {
        MetricsCollectorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (CollectorWithRuntimeInfos collectorWithRuntimeInfos : MetricsServiceImpl.this.collectorsWithRuntimeInfos) {
                if (!collectorWithRuntimeInfos.mustRun()) continue;
                try {
                    Map<String, Object> esSourceValue = collectorWithRuntimeInfos.collectAndConvertToElasticsearchSourceValue();
                    if (esSourceValue == null) continue;
                    MetricsServiceImpl.this.metricsToBeWrittenQueue.add(esSourceValue);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Failed to execute a collector.", t);
                }
                finally {
                    collectorWithRuntimeInfos.setAsJustRun();
                }
            }
        }
    }

    class MetricsWriterRunnable
    implements Runnable {
        MetricsWriterRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                LOG.info(this.getClass().getSimpleName() + ": Starting ...");
                long startTime = System.currentTimeMillis();
                try {
                    Map entryToWrite;
                    ZonedDateTime now = ZonedDateTime.now().minus(500L, ChronoUnit.MILLIS);
                    ArrayList<Map> entriesToWrite = new ArrayList<Map>();
                    while ((entryToWrite = (Map)MetricsServiceImpl.this.metricsToBeWrittenQueue.poll()) != null) {
                        entriesToWrite.add(entryToWrite);
                        ZonedDateTime logEntryDateTime = ZonedDateTime.parse((String)entryToWrite.get("timestamp"), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                        if (!logEntryDateTime.isAfter(now)) continue;
                        break;
                    }
                    LOG.info(this.getClass().getSimpleName() + ": " + entriesToWrite.size() + " entries to index (" + MetricsServiceImpl.this.metricsToBeWrittenQueue.size() + " entries still in the queue)");
                    if (entriesToWrite.isEmpty()) break block11;
                    ElasticsearchService es = MetricsServiceImpl.this.getElasticsearchServiceWithPreparedMetricsIndex();
                    try {
                        RestHighLevelClient esClient = es.getClient();
                        BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        for (Map entryToWrite2 : entriesToWrite) {
                            bulkRequest.add(((IndexRequest)new IndexRequest().index(MetricsServiceImpl.INDEX_NAME)).source(entryToWrite2, XContentType.JSON));
                        }
                        BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                        if (bulkResponse.hasFailures()) {
                            throw new Exception("Metrics indexing failed: " + bulkResponse.buildFailureMessage());
                        }
                        MetricsServiceImpl.this.percolatorsManagerTracker.getService().informClientsAboutReplicatedData(es, MetricsServiceImpl.INDEX_NAME, bulkResponse);
                    }
                    catch (IOException ex) {
                        throw new ElasticsearchRelatedException(ex);
                    }
                    catch (ElasticsearchException ex) {
                        throw new ElasticsearchRelatedException(ex);
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed to write the metrics in batch.", ex);
                }
                finally {
                    LOG.info(this.getClass().getSimpleName() + ": Finished after " + (System.currentTimeMillis() - startTime) + " milliseconds");
                }
            }
        }
    }

    static class CollectorWithRuntimeInfos {
        private final String name;
        private final Collector collector;
        private final long collectEveryNumberOfSeconds;
        private long lastRunWasAtTimeInMillis;

        public CollectorWithRuntimeInfos(String name, Collector collector, long collectEveryNumberOfSeconds) {
            this.name = name;
            this.collector = collector;
            this.collectEveryNumberOfSeconds = collectEveryNumberOfSeconds;
            this.lastRunWasAtTimeInMillis = -1L;
        }

        public boolean isSameCollector(Collector collector) {
            return this.collector.getClass().equals(collector.getClass());
        }

        public boolean mustRun() {
            if (this.collectEveryNumberOfSeconds <= 0L) {
                return false;
            }
            if (this.lastRunWasAtTimeInMillis <= -1L) {
                return true;
            }
            return this.lastRunWasAtTimeInMillis + TimeUnit.SECONDS.toMillis(this.collectEveryNumberOfSeconds) <= System.currentTimeMillis();
        }

        public void setAsJustRun() {
            this.lastRunWasAtTimeInMillis = System.currentTimeMillis();
        }

        public Map<String, Object> collectAndConvertToElasticsearchSourceValue() {
            List metricSamples = this.collector.collect();
            return this.convertToElasticsearchSource(metricSamples);
        }

        private Map<String, Object> convertToElasticsearchSource(List<Collector.MetricFamilySamples> metricSamples) {
            String now = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            HashMap<String, Double> values = new HashMap<String, Double>();
            for (Collector.MetricFamilySamples metricSample : metricSamples) {
                if (metricSample.type == Collector.Type.GAUGE) {
                    values.put(metricSample.name, ((Collector.MetricFamilySamples.Sample)metricSample.samples.get((int)0)).value);
                    continue;
                }
                LOG.severe("Please get in touch with the BPC developers. There is a implementation missing for the metric type: " + metricSample.type);
            }
            if (values.isEmpty()) {
                return null;
            }
            HashMap<String, Object> elasticsearchSourceValue = new HashMap<String, Object>();
            elasticsearchSourceValue.put("name", this.name);
            elasticsearchSourceValue.put("value", values);
            elasticsearchSourceValue.put("timestamp", now);
            return elasticsearchSourceValue;
        }
    }
}

