/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.service.ReplicationInfoService;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class ReplicationInfoServiceImpl
implements ReplicationInfoService,
BpcService {
    private static final Logger LOG = Logger.getLogger(ReplicationInfoServiceImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;

    public ReplicationInfoServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public Map<String, Object> getReplicationJob(String dataIndex) {
        LOG.info("getReplicationJob dataIndex=" + dataIndex);
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ReplicationJob job : this.replicationManagerTracker.getService().getJobs()) {
                if (!dataIndex.equalsIgnoreCase(job.getTarget().getIndex())) continue;
                HashMap<String, Object> replicationMap = new HashMap<String, Object>();
                replicationMap.put("Job", job.getTarget().getIndex());
                replicationMap.put("errorCount", job.getStats().getErrorCount());
                replicationMap.put("lastRunEnd", job.getStats().getLastRunEndDate());
                replicationMap.put("currentErrorMessage", job.getStats().getCurrentErrorMessage());
                if (job.getConsistencyCheck().isEnabled()) {
                    replicationMap.put("sourceAndTargetConsistent", job.getConsistencyCheck().isSourceAndTargetConsistent());
                }
                result.put("id", job.getId());
                result.put("replication", replicationMap);
            }
            return result;
        }
        catch (Exception e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "Can't get replication job information: " + e.getLocalizedMessage());
            return result;
        }
    }
}

