/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.core.auth.ClientSessionImpl;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.osgi.service.event.Event;

public class EventUtil {
    private static final Logger LOG = Logger.getLogger(EventUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String eventAsJsonString(Event event) throws JsonProcessingException {
        LOG.info("eventAsJsonString event=" + event);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (String propertyName : event.getPropertyNames()) {
            Object propertyValue = event.getProperty(propertyName);
            if (propertyValue instanceof Module) {
                ((Dictionary)props).put(propertyName, propertyValue.toString());
                continue;
            }
            if (propertyValue instanceof ClientSessionImpl) {
                ClientSessionImpl clientSession = (ClientSessionImpl)propertyValue;
                ((Dictionary)props).put(propertyName, clientSession.getSessionId());
                continue;
            }
            ((Dictionary)props).put(propertyName, propertyValue);
        }
        ((Dictionary)props).remove("event.topics");
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Hashtable<String, Object> eventProps = new Hashtable<String, Object>();
            ((Dictionary)eventProps).put("topic", event.getTopic());
            ((Dictionary)eventProps).put("properties", props);
            String string = mapper.writeValueAsString(eventProps);
            return string;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }
}

